// PATCH.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"
#include <time.h>

#define PROGRAM "PATCH"  // Name of module
/*********************************************************************/

/**/
static int patch(AU *au, char *file_name)
{
	check_for_key();

	au_printf(au, "@?6Processing @?1%-*s@?H\n", FILE_SIZE+2, file_name); // display file name
	au->number_processed++;
	fix_flist(au, file_name, file_name);
	return 0;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	Unused(cur_argv);
	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case '?':
			au_standard_opt_header(au, "Patch", NULL);
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_patch(AU *au, int argc, char *argv[])
{
	au->allow_rename = FALSE;	  // no sense since unarcers not called

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, NULL);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, patch);

	if (!au->no_extra)
		au_printf_c(au, 15, "\nFiles Processed = %d\n", au->number_processed);

	return 0;
}

