// SIZE.CPP 								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"

#define PROGRAM "SIZE"    // Name of module
/*********************************************************************/

#define SELF  MAX_TYPES
#define TOTAL MAX_TYPES +1

typedef struct
{
	char non_arcs;					  // include the non-arcs
	int first;

	long uncomp_size[MAX_TYPES+2],
		 comp_size[MAX_TYPES+2],
		 count[MAX_TYPES+2],
		 inside_count[MAX_TYPES+2];
} SIZE_INFO;

/**/
static void set_stats(AU *au, char *file_name, int type, long uncomp,
					  long comp, int inside)
{
	SIZE_INFO *in = (SIZE_INFO *)au->info;

	printf("%-15s", file_name);
	if (uncomp < 0)
	{
		add_to_bad_list(au, au->source_directory, file_name);
		return;
	}
	in->uncomp_size[type]+=uncomp;
	in->comp_size[type]+=comp;
	in->count[type]++;
	in->inside_count[type]+=inside;

	printf("%11ld %11ld, %s%%  %d\n", comp, uncomp, percent_string(uncomp,comp),
		   inside);
}
/**/
static long size_of_archive(AU *au, int *inside, ARC_FILE *arcFile)
{
	ARC_RECORD record;
	int ret_code;
	long unpacked_sum=0;

	*inside = 0;

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
			return -2;
		else if (ret_code == -3)
			return 0;
		unpacked_sum += record.unpacked_size;
		(*inside)++;
	}
	return unpacked_sum;
}
/**/
static int size(AU *au, char *file_name)
{
	ARC_FILE arcFile;
	int inside;
	long comp;
	long uncomp;
	SIZE_INFO *in = (SIZE_INFO *)au->info;

	check_for_key();

	arc_file_init(au, &arcFile, file_name);
	comp = filelength(arcFile.file);

	switch (arcFile.type)
	{
		case NONARC:
			if (in->non_arcs == ON)
				 set_stats(au, file_name, NONARC, comp, comp, 1);
			break;
		default:
			uncomp = size_of_archive(au, &inside, &arcFile);
			set_stats(au, file_name, (arcFile.is_self ? SELF : arcFile.type),
					  uncomp, comp, inside);
			break;
	}
	arc_file_deinit(au, &arcFile);
	return 0;
}
/**/
static void show_stats(AU *au, char *string, int type)
{
	SIZE_INFO *in = (SIZE_INFO *)au->info;

	if (in->comp_size[type]==0 && in->uncomp_size[type]==0)
		return;

	if (!in->first)
		printf("+---------+----------+----------+------------+---------------+---------+\n");
	else
		in->first = FALSE;

	printf("| %-6s  | %7ld  | %7ld  | %10ld |  %10ld   | %s  |\n", string,
		   in->count[type], in->inside_count[type], in->comp_size[type],
		   in->uncomp_size[type],
		   percent_string(in->uncomp_size[type], in->comp_size[type]));

	return;
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	Unused(cur_argv);

	SIZE_INFO *in = (SIZE_INFO *)au->info;

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case 'X':
			au->self_extracts = get_value(au, OFF | ON);
			break;
		case 'N':
			in->non_arcs = get_value(au, OFF | ON);
			break;
		case '?':
			au_standard_opt_header(au, "SIze",
				"@?3-X@?Hon|off         self eXtracts\n"
				"@?3-N@?Hon|off         process Non-Arcs\n");
			exit(0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_size(AU *au, int argc, char *argv[])
{
	SIZE_INFO *in;

	in = (SIZE_INFO *)au_malloc(au, sizeof(SIZE_INFO));
	memset(in, '\0', sizeof(SIZE_INFO));
	au->info = in;
	in->non_arcs = ON;
	in->first = TRUE;

	au->allow_rename = FALSE;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, NULL);

	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, size);

	for (int i=0 ; i<MAX_TYPES ; i++)
	{
		in->comp_size[TOTAL]   += in->comp_size[i];
		in->uncomp_size[TOTAL] += in->uncomp_size[i];
		in->count[TOTAL]	   += in->count[i];
		in->inside_count[TOTAL]+= in->inside_count[i];
	}
	if (in->comp_size[TOTAL]!=0)
	{
		printf("\n"
			   "+=========+==========+==========+============+===============+=========+\n"
			   "| Archive |   File   |  Inside  |   Total    |     Total     | Percent |\n"
			   "|   Type  |   Count  |   Count  | Compressed |  UnCompressed | Savings |\n"
			   "+=========+==========+==========+============+===============+=========+\n");

		for (i = 1; i < MAX_TYPES; i++)
			show_stats(au, au->package[i].extension, i);

		show_stats(au, "SlfExt", SELF);
		show_stats(au, "NonArc", NONARC);

		printf("+=========+==========+==========+============+===============+=========+\n");
		in->first = TRUE;
		show_stats(au, "Total", TOTAL);
		printf("+=========+==========+==========+============+===============+=========+\n");
	}
	else
		printf("\nNo Stats Available\n");

	return 0;
}

