#include "..\au.hpp"

/*************************************************************************/
static void add_to_list2(AU *au, char *dir, char *filespec)
{
	char fname[FLENGTH];
	build_fname(fname, dir, filespec);
	add_to_list(au, &au->process_list, fname);
}
/*************************************************************************/
static void fill_list_from_GT(AU *au, char *filespec)
{
	int i, c;
	char string[FLENGTH];
	HANDLE file = au_open(au, "gtdir.bbs");

	au_printf_c(au, 15, "GT file directories\n\n");

	for (EVER)
	{
		do				  /* go until a space is hit */
		{
			if ((c = my_getc(file)) == EOF)
				goto end;
		} while (c > ' ');

		do				  /* go until a non-space is hit */
		{
			if ((c = my_getc(file)) == EOF)
				goto end;
		} while (c <= ' ');

		i=0;
		do				  /* go until a space is hit */
		{
			string[i++]=c;
			if ((c = my_getc(file)) == EOF)
				goto end;
		} while (c > ' ');
		string[i]='\0';
		add_to_list2(au, string, filespec);

		do				  /* pass over the description */
		{
			if ((c = my_getc(file)) == EOF)
				goto end;
		} while (c != '\n');
	}
end:
	close(file);
}
/*************************************************************************/
/* OPUS version 1.03 & 1.1x */
static void fill_list_from_Opus(AU *au, char *filespec, int is_103, struct ffblk *ffblk)
{
	int i,c;
	HANDLE file;
	char string[FLENGTH];

	au_printf_c(au, 15, "Opus %s file directories\n\n", is_103 ? "1.03" : "1.1x");

 /* open up the system files one at a time and pick off the download dir */
	do
	{
		 if (strlen(ffblk->ff_name)<11)
			 continue;

		 file = au_open(au, ffblk->ff_name);
		 lseek(file, is_103 ? 164:130, SEEK_SET);
		 {
			 i = 0;
			 while ((c=my_getc(file)) > ' ')
			 {
				 if (c==EOF)
					 break;
				 string[i++] = c;
			 }
			 string[i] = '\0';
		 }
		 close(file);

		 if (string[0]>33)
			 add_to_list2(au, string, filespec);

	} while (!findnext(ffblk));
}
/*************************************************************************/
static void fill_list_from_Max(AU *au, char *filespec)	  /* Maximus */
{
	long pos = 1378;
	int  version;
	int  ch, ch2;
	char string[FLENGTH];
	HANDLE file = au_open(au, "area.dat");

	lseek(file, 4L, SEEK_SET);
	ch = my_getc_1(file);
	ch2 = my_getc_1(file);
	if (ch == 0x60 && ch2 == 0x04)
	{
		version = 200;
		pos = 1518;
	}
	else /* (ch == 0xD4 && ch2 == 0x03) */
	{
		version = 102;
		pos = 1378;
	}
	au_printf_c(au, 15, "Maximus %s file directories\n\n", version==102 ? "1.02" : "2.00");

	for (EVER)
	{
		lseek(file, pos, SEEK_SET);
		if (read(file, string, FLENGTH) == 0)
			break;
		if (string[0] != '\0')
			add_to_list2(au, string, filespec);
		pos+= version==102 ? 980 : 1120;
	}
	close(file);
}
/*************************************************************************/
static void fill_list_from_RBBS(AU *au, char *filespec)    /* RBBS */
{
	long last_comma=0;
	long pos=0;
	int  ch;
	int  i;
	char string[FLENGTH];
	HANDLE file = au_open(au, "rbbs-pc.def", O_BINARY);

	au_printf_c(au, 15, "RBBS file directories\n\n");

   /* Find the last , *************************/

	while ((ch = my_getc(file)) != EOF)
	{
		pos++;
		if (ch == ',')
			last_comma = pos;
	}

	lseek(file, last_comma, SEEK_SET);

	/* Skip the first 2 quote marks ***********/

	for (i=0; i<2; i++)
	{
		while ((ch = my_getc_1(file)) != '\"')
		{
			if (ch == EOF)
				goto Error0;
		}
	}

	for(EVER)
	{
		i=0;
		while ((ch = my_getc_1(file)) != '\"')
		{
			if (ch == EOF)
				goto Error0;
		}
		while ((ch = my_getc_1(file)) != '\"')
		{
			string[i++] = ch;
			if (ch == EOF)
				goto Error0;
		}
		string[i] = '\0';
		add_to_list2(au, string, filespec);
	}

Error0:
	close(file);
	return;
}
/*************************************************************************/
void fill_list_from_BBS(AU *au, char *filespec)
{
	struct ffblk ffblk;

	if (!findfirst("system*.bbs", &ffblk, 0))
		fill_list_from_Opus(au, filespec, TRUE, &ffblk);
	else if (!findfirst("system*.dat", &ffblk, 0))
		fill_list_from_Opus(au, filespec, FALSE, &ffblk);
	else if (!findfirst("gtdir.bbs", &ffblk, 0))
		fill_list_from_GT(au, filespec);
	else if (!findfirst("area.dat", &ffblk, 0))
		fill_list_from_Max(au, filespec);
	else if (!findfirst("rbbs-pc.def", &ffblk, 0))
		fill_list_from_RBBS(au, filespec);
	else
	{
		au_printf_error(au, "\nNo Recognizable BBS files containing needed directories");
		exit(1);
	}
}
