#include "..\au.hpp"
/******************************************************************/
char *date_to_string(DATE *date)
{
	static char ret_string[9];
	sprintf(ret_string, "%02d-%02d-%02d", date->month, date->day,
			date->year % 100);
	return ret_string;
}
/******************************************************************/
void fdate_to_date(DATE *date, struct ffblk *ffblk)
{
	date->year = (((ffblk->ff_fdate & 0xFE00) >> 9) + 1980) % 100;
	date->month = (ffblk->ff_fdate & 0x01E0) >> 5;
	date->day = ffblk->ff_fdate & 0x001F;
	return;
}

/*******************************************************************/
static long date_to_days(DATE *date)
{
	long ret_value;

	ret_value=365*(long)date->year	/* without Leap year */
			  +(date->year-1)/4 	/* +leap years */
			  -(date->year-1)/100	/* -leap year once a century */
			  +(date->year-1)/400	/* +leap year once every 4th century */
			  +date->day			/* +# of days into the year */
			  +((date->year % 4)==0 && date->month>2 ? 1:0); /* + 1 on leap year itself */
	switch (date->month)			/* add the month to it */
	{
		case 2:
			ret_value+=31;
			break;
		case 3:
			ret_value+=59;
			break;
		case 4:
			ret_value+=90;
			break;
		case 5:
			ret_value+=120;
			break;
		case 6:
			ret_value+=151;
			break;
		case 7:
			ret_value+=181;
			break;
		case 8:
			ret_value+=212;
			break;
		case 9:
			ret_value+=243;
			break;
		case 10:
			ret_value+=273;
			break;
		case 11:
			ret_value+=304;
			break;
		case 12:
			ret_value+=334;
	}
	return ret_value;
}
/*******************************************************************/
static void days_to_date(DATE *date, long days)
{
	int year, month=1;
	long temp;

	temp=days / 146097; 	/* In groups of 400 */
	days-=146097*temp;
	year=temp*400;

	temp=days / 36524;		/* In groups of 100 */
	days-=36524*temp;
	year+=temp*100;

	temp=days / 1461;		/* In groups of 4 */
	days-=1461*temp;
	year+=temp*4;

	temp=days / 365;		/* In groups of 1 */
	days-=365*temp;
	year+=temp;

	if (year % 4 == 0)
		days++;

	if (days>31)		  /* move to FEB */
	{
		days-=31;
		month++;
	}
	if (days > ((year % 4 == 0) ? 29:28))		  /* Move to March */
	{
		days-=((year % 4 == 0) ? 29:28);
		month++;
	}
	if (days>31)		  /* move to April */
	{
		days-=31;
		month++;
	}
	if (days>30)		  /* move to May */
	{
		days-=30;
		month++;
	}
	if (days>31)		  /* move to June */
	{
		days-=31;
		month++;
	}
	if (days>30)		  /* move to July */
	{
		days-=30;
		month++;
	}
	if (days>31)		  /* move to August */
	{
		days-=31;
		month++;
	}
	if (days>31)		  /* move to September */
	{
		days-=31;
		month++;
	}
	if (days>30)		  /* move to October */
	{
		days-=30;
		month++;
	}
	if (days>31)		  /* move to November */
	{
		days-=31;
		month++;
	}
	if (days>30)		  /* move to December */
	{
		days-=30;
		month++;
	}
	date->year	= year;
	date->month = month;
	date->day	= days;
	return;
}

/******************************************************************/
void date_add(DATE *s, DATE *t, long days)
{
	days_to_date(t, date_to_days(s) + days);
}
/******************************************************************/
long days_diff(DATE *s, DATE *e)
{
	return date_to_days(e) - date_to_days(s);
}
