#include "..\au.hpp"

/**/
static void dbad_printf(AU *au, char *format, ...)
{
	va_list plist;
	char string[200];

	va_start(plist, format);
	vsprintf(string, format, plist);
	va_end(plist);

	au_printf_c(au, 12, "%s", string);

	if (au->problem_file == -1 && au->problem_log[0] != '\0')
	{
		au->problem_file = au_open(au, au->problem_log, O_CREAT|O_WRONLY|O_TEXT);
		lseek(au->problem_file, 0, SEEK_END);
	}
	write(au->problem_file, string, strlen(string));
	return;
}
/**/
void add_to_bad_list(AU *au, char *path, char *file_name, BYTE errorlevel,
					 int type)
{
	char string[FLENGTH];

	build_fname(string, path, file_name);
	add_to_list(au, &au->bad_list[type], string);
	au->bad_count[type]++;

	au_printf(au, "\a");      /* bell sound */
	switch (type)
	{
		case 0:
			dbad_printf(au, "\nSuspicious Archive: '%s' Possibly Damaged\n", string);
			break;
		case 1:
			dbad_printf(au, "\nDamaged Archive: '%s'\n", file_name);
			break;
		case 2:
			dbad_printf(au, "\nInfected Archive: %s\n", file_name);
			break;
		case 3:
			dbad_printf(au, "  Future Dated  ");
			break;
		case 4:
			dbad_printf(au, "\nVirus checker was unable to process: %s\n", file_name);
			break;
		case 5:
			dbad_printf(au, "\nFile is password encrypted, unable to process: %s\n", file_name);
			break;
	}
	if (errorlevel > 0)
		dbad_printf(au, "   (Errorlevel = %d)\n", errorlevel);

	press_any_key(au);	   //FIXIT, seems like we almost need levels here

}
/**/
static void retest_suspicious(AU *au)
{
	LIST *el;
	char hold_dir[FLENGTH];
	char name[FILE_SIZE];
	char path[FLENGTH];

	if (au->bad_list[0].head != NULL)
		dbad_printf(au, "\nTesting Suspicious Archives\n");

	for (el = au->bad_list[0].head; el != NULL; el = el->next)
	{
		split_file(el->data, path, name);
		cd(au, path, hold_dir);
		if (test(au, name) < 0)
		{
			el->data[0] = '\0';
			au->bad_count[0]--;
		}
		cd(au, hold_dir);
	}
	return;
}
/**/
int display_bad_arcs(AU *au)
{
	LIST *el;
	int  any=FALSE;

	if (au->retest == ON)
		retest_suspicious(au);

	for (int i=0; i < MAX_ERRORS; i++)
	{
		if (au->bad_count[i] > 0)
		{
			any = TRUE;
			switch (i)
			{
				case 0:
					if (au->retest == ON)
						dbad_printf(au, "\nFiles AU had trouble with (please report) = %d\n",
								au->bad_count[i]);
					else
						dbad_printf(au, "\nSuspicious Archives (Possibly Damaged) = %d\n",
								au->bad_count[i]);
					break;
				case 1:
					dbad_printf(au, "\nDamaged Archives = %d\n", au->bad_count[i]);
					break;
				case 2:
					dbad_printf(au, "VIRUS(es) DETECTED!!!!\n");
					dbad_printf(au, "\nInfected Archives = %d\n", au->bad_count[i]);
					break;
				case 3:
					dbad_printf(au, "Future Dated Files = %d\n", au->bad_count[i]);
					break;
				case 4:
					dbad_printf(au, "Files the virus checker couldn't handle = %d\n", au->bad_count[i]);
					break;
				case 5:
					dbad_printf(au, "Files that are password encrypted = %d\n", au->bad_count[i]);
					break;
			}
			dbad_printf(au, "----------------------------------\n");
			for (el = au->bad_list[i].head; el != NULL; el = el->next)
			{
				if (el->data[0] != '\0')
					dbad_printf(au, "%s\n", el->data);
			}
			dbad_printf(au, "----------------------------------\n");
			press_any_key(au);
		}
	}
	return any;
}
