#include "..\au.hpp"

/* get_file_line2() gets a raw line from a text file
   get_file_line()	gets a .cfg file line from a text file */

/************************************************************************/
int get_file_line2(HANDLE file, char *string)
{
	int c, string_pos=0;

	while ((c=my_getc(file))!=EOF)
	{
		if (c=='\n' || c=='\r')
			break;
		string[string_pos++] = c;
	}
	if (string_pos==0 && c==EOF)
		return EOF;

	string[string_pos] = '\0';
	return 0;
}
/************************************************************************/
void subst_environ(AU *au, char *string)
{
	char var[300];
	char *varPtr;
	char newString[300];
	char *newPtr = newString;
	char *ptr = string;
	BYTE normal;

	while (*ptr != '\0')
	{
		if (*ptr == '%')
		{
			ptr++;
			if (*ptr == '%')
			{
				*newPtr++ = '%';
				ptr++;
				continue;
			}
			varPtr = var;
			normal = TRUE;
			while (*ptr != '%')
			{
				*varPtr++ = *ptr;
				if (*ptr == '\0' || isspace(*ptr))
				{
					normal = FALSE;
					break;
				}
				ptr++;
			}
			*varPtr = '\0';
			if (!normal || strlen(var) < 2)
			{
				strcpy(newPtr, "%");
				newPtr++;
				strcpy(newPtr, var);
				newPtr += strlen(var);
				if (normal)
				{
					strcpy(newPtr, "%");
					newPtr++;
				}
			}
			else
			{
				strupr(var);

				if (getenv(var) != NULL)
				{
					strcpy(newPtr, getenv(var));
					newPtr += strlen(getenv(var));
				}
				else
					au_printf_error(au, "Environment variable \"%s\" not found", var);
			}
		}
		else
			*newPtr++ = *ptr;
		if (*ptr != '\0')
			ptr++;
	}
	*newPtr = '\0';       /* NULL terminate the string */
	strcpy(string, newString);
	return;
}
/************************************************************************/
int get_file_line(AU *au, HANDLE file, char *string)
											  /* get a line of text from a file */
											  /* trim the spaces on the left */
											  /* and remove comments */
{
	int ret_code;
	char *pos;

	ret_code = get_file_line2(file, string);

	pos = strchr(string, ';');     /* Remove comment */
	if (pos != NULL)
		*pos = '\0';

	subst_environ(au, string);

	if (string[0] == '\0' && ret_code == EOF)
		return EOF;

	ltrim(string);
	return 0;
}
/************************************************************************/
int get_file_word(HANDLE file,char *string)   /* get a word of text from a file */
											  /* trim the spaces on the left */
											  /* and remove comments */
{
	int c, string_pos=0;

	while ((c=my_getc(file))!=EOF)
	{
		if (!isspace(c))
			break;
		string[string_pos++] = c;
	}
	if (c==EOF)
		return EOF;
	string[string_pos++] = c;
	while ((c=my_getc(file))!=EOF)
	{
		if (isspace(c))
			break;
		string[string_pos++] = c;
	}

	string[string_pos] = '\0';
	return 0;
}

