#include "..\au.hpp"

#define MAX_HOLD 50

static char hold_before[MAX_HOLD][FILE_SIZE], hold_after[MAX_HOLD][FILE_SIZE];
static char hold_found[MAX_HOLD];
static int count=0;

/**/
static int is_date(char *string)
{
	if (!(string[0] == ' ' || isdigit(string[0])) || !isdigit(string[1]) ||
		!isdigit(string[3]) || !isdigit(string[4]) ||
		!isdigit(string[6]) || !isdigit(string[7]) ||
		string[2]!='-' || string[5]!='-')
	{
		return FALSE;
	}
	else
		return TRUE;
}
/**/
void add_to_flist(AU *au, char *string, int append)
{
	for (int i=0 ; i < au->flist_pos ; i++)
	{
		if (stricmp(au->flist[i], string)==0) // see if not already in the list
			return;
	}
	if (au->flist_pos == MAX_FLISTS)
	{
		au_printf_error(au, "\nToo Many File Lists Specified");
		exit(1);
	}
	au->append_flist[au->flist_pos] = append;
	strcat(au->flist[au->flist_pos++], string);
	return;
}
/**/
static int desc_file_find(AU *au, char *arc_file_name, char *actual_name)
{
	ARC_FILE arcFile;
	ARC_RECORD record;
	int found = FALSE;
	int retCode;

	arc_file_init(au, &arcFile, arc_file_name);
	if (arcFile.type > 0)
	{
		for (;;)
		{
			retCode = get_record(au, &arcFile, &record);
			if (retCode == EOF)
				break;
			else if (retCode == -2)
			{
				add_to_bad_list(au, au->source_directory, arc_file_name, 0);
				break;
			}
			if (wildcard_compare(au, record.name, au->desc_file))
			{
				strcpy(actual_name, record.name);
				found = TRUE;
				break;
			}
		}
	}
	arc_file_deinit(au, &arcFile);
	return found;
}
/**/
static int get_file_description(AU *au, char *arc_file_name, char *description)
{
	char partial_save[FLENGTH];
	char actual_name[FLENGTH];
	HANDLE file;
	int retCode = FALSE;

	if (desc_file_find(au, arc_file_name, actual_name))
	{
		mkdir(TEMP_DIR);

		strcpy(partial_save, au->partial);
		strcpy(au->partial, actual_name);
		unarc(au, arc_file_name, TEMP_DIR, NULL, 0, FALSE);
		strcpy(au->partial, partial_save);

		if (access(actual_name, 0x00) == 0)
		{
			cd(au, TEMP_DIR);
			file = au_open(au, actual_name, O_RDONLY|O_TEXT);
			memset(description, '\0', DESC_SIZE);
			read(file, description, DESC_SIZE-1);
			string_replace(description, "\n", " ");
			string_replace(description, "\r", " ");
			close(file);
			unlink(actual_name);
			cd(au, "..");
			retCode = TRUE;
		}

		rmdir(TEMP_DIR);
	}

	return retCode;
}
/**/
static int write_description(AU *au, HANDLE file, char *arc_file_name)
{
	char description[DESC_SIZE];

	if (au->desc_file[0] != '\0')
	{
		if (get_file_description(au, arc_file_name, description))
		{
			my_write(file, description);
			my_write(file, "\n");
			return 0;
		}
	}

	my_write(file, au->description);
	my_write(file, "\n");
	return 0;
}
/**/
static int file_exists(char *file_name, char *flf_name)
{
	char temp[80], path[80], file[80];
	struct ffblk ffblk;

	if (findfirst(file_name, &ffblk, 0) != 0)
	{
		/* Peel the path out of the file list file name and check there too */
		strcpy(temp, flf_name);
		split_file(temp, path, file);
		if (path[0] == '\0')
			return FALSE;
		strcat(path, file_name);
		return (findfirst(path, &ffblk, 0) == 0);
	}
	return TRUE;
}
/**/
static void search_file(AU *au, HANDLE file, char *file_name, int fpos)
{
	int  style;
	long pos,pos2;
	int  len;
	long size;
	char size_string[12];
	char date_string[9];
	char string[250];	   /* Should be big enough for most descriptions */
	char string2[FLENGTH];
	char string3[200];
	DATE date;
	int  i;
	struct ffblk ffblk;

	/* Just in case files.bbs is completely empty, set the style */
	if (au->force_mode > 0)
		style = au->force_mode;
	else
		style = OPUS;

	pos2=0;
	for(EVER)			/* While not EOF */
	{
		pos = pos2;
		lseek(file, pos2, SEEK_SET);	// make darn sure we know where we are
		reset_buffer_pos();
		if (get_file_line2(file, string) == EOF)
			break;
		len = strlen(string);
		ltrim(string);
		pos+=len-strlen(string);
		pos2 = pos+strlen(string)+2;   // start of next line
		if (string[0]=='-')            // Ignore comments
			continue;

 /* Determine style of file */
		if (au->force_mode > 0)
			style = au->force_mode;
		else if (is_date(string+17))
			style = GT;
		else if (is_date(string+23))
			style = RBBS;
		else
			style = OPUS;

		i=0;						  /* peel filename out */
		while (string[i] > ' ')
		{
			string2[i] = string[i];
			i++;
		}
		string2[i] = '\0';

		for (int k=0; k<count; k++)
		{
			char *before = hold_before[k];
			char *after  = hold_after[k];
			int  match	 = FALSE;

			if (stricmp(string2, before) == 0)
				match = TRUE;
			else			   /* See if the extension is different */
			{
				char *ptr1, *ptr2;

				/* but make sure the file doesn't exist first */
				if (!file_exists(string2, file_name))
				{
					ptr1 = strchr(string2, '.');
					ptr2 = strchr(before, '.');
					if (ptr1 != NULL && ptr2 != NULL &&
						ptr1-string2 == ptr2-before  &&
						strnicmp(string2, before, ptr1-string2)==0)
					{
						match = TRUE;
						if (strchr(file_name, ':') || strchr(file_name, '\\'))
							sprintf(string3, "Replaced: %-15s with %-15s in %s",
									 string2, after, file_name);
						else
						{
							sprintf(string3, "Replaced: %-15s with %-15s in %s",
									 string2, after, au->source_directory);
							build_fname(string3, string3, file_name);
						}
						my_write(au->flist_log_file, string3);
						my_write(au->flist_log_file, "\n");
					}
				}
			}

			if (match)		 /* fix string, then write it back out */
			{
				int i=0,j;

				/* Don't do anything if the file is missing */
				if (findfirst(after, &ffblk, 0))
					return;

				size = ffblk.ff_fsize;
				fdate_to_date(&date, &ffblk);
				strcpy(date_string, date_to_string(&date));

/* put the new filename in the string */
				while (after[i] > ' ')
				{
					string[i] = toupper(after[i]);
					i++;
				}
				while (i < strlen(before))
					string[i++] = ' ';

				if (style == GT || style == RBBS)
				{
					if (style == GT)
						strcpy(size_string, left_pad(my_ltoa(size/1024) ,3));
					else
						strcpy(size_string, left_pad(my_ltoa(size), 8));

					j=13; i=0;
					while (size_string[i]!='\0')
						string[j++] = size_string[i++];

					if (style == GT)
					{
						j = 17;
						if (date_string[0] == '0')
							date_string[0] = ' ';
					}
					else
					{
						j = 23;
						if (date_string[0] == ' ')
							date_string[0] = '0';
					}
					i=0;
					while (date_string[i]!='\0')
						string[j++] = date_string[i++];
				}
				lseek(file, pos, SEEK_SET);
				my_write(file, string);
				hold_found[k] = TRUE;
				break;
			}
		}
	}
	if (au->append_flist[fpos]==TRUE)
	{
		for (i=0; i<count; i++)
		{
			if (!hold_found[i])
			{
				findfirst(hold_after[i], &ffblk, 0);
				size = ffblk.ff_fsize;
				date.year = (((ffblk.ff_fdate & 0xFE00) >> 9) + 1980) % 100;
				date.month = (ffblk.ff_fdate & 0x01E0) >> 5;
				date.day = ffblk.ff_fdate & 0x001F;
				strcpy(date_string, date_to_string(&date));

				lseek(file, 0, SEEK_END);
				my_write(file, right_pad(hold_after[i],13));
				if (style == GT)
				{
					my_write(file, left_pad(my_ltoa(size/1024), 3));
					my_write(file, " ");
					if (date_string[0] == '0')
						date_string[0] = ' ';
					my_write(file, date_string);
					my_write(file," ");
				}
				else if (style == RBBS)
				{
					my_write(file,left_pad(my_ltoa(size), 8));
					my_write(file,"  ");
					if (date_string[0] == ' ')
						date_string[0] = '0';
					my_write(file, date_string);
					my_write(file,"  ");
				}

				write_description(au, file, hold_after[i]);

				if (strchr(file_name, ':') || strchr(file_name, '\\'))
					sprintf(string3, "Added: %-15s to %s", hold_after[i], file_name);
				else
				{
					sprintf(string3, "Added: %-15s to %s", hold_after[i],
							au->source_directory);
					build_fname(string3, string3, file_name);
				}
				my_write(au->flist_log_file, string3);
				my_write(au->flist_log_file, "\n");
			}
		}
	}
	return;
}
/**/
////////////////////////////////////////////////////////////////////
//				0		  1 		2		  3
//				0123456789012345678901234567890123456
//				-------------------------------------
//	Opus		FILENAME.EXT  Description
//	RBBS		FILENAME.EXT 99999999  12-31-99  Description
//	GT-Power	FILENAME.EXT 999 12-31-99 Description  (front 0 stripped on date)
////////////////////////////////////////////////////////////////////
void fix_flist(AU *au, char *before, char *after)
{
	HANDLE file;
	long pos,pos2;
	int  c,d,i;

	if (before != NULL)
	{
		strcpy(hold_before[count], before);
		strcpy(hold_after[count], after);
		hold_found[count] = FALSE;
		count++;

		if (count < MAX_HOLD)
			return;
	}
	else if (count == 0)
		return;

	if (au->flist_log_file == -1 && au->flist_log[0] != '\0')
	{
		au->flist_log_file = au_open(au, au->flist_log, O_CREAT|O_WRONLY|O_TEXT);
		lseek(au->flist_log_file, 0, SEEK_END);
	}


/**********************************************************************/
	for (int fpos = 0 ; fpos < au->flist_pos; fpos++)
	{
		char *file_name = au->flist[fpos];

		if (file_name[0] == '\0')
			continue;

		file = au_open(au, file_name, O_RDWR|O_TEXT);

		if (file == -1)
		{
			au_printf_error(au, "\nFile Listing File '%s' not found", file_name);
			au->flist[fpos][0] = '\0';     // One warning is enough
			continue;
		}
		search_file(au, file, file_name, fpos);
		close(file);
	}
	count = 0;
	return;
}
/**/
/* Get the next file name from a files.bbs file */
int get_next_file_name(AU *au, HANDLE file, char *ret_string, int *area)
{
	char string[256];
	char string2[256];
	int  good, i;

	Unused(au);
	for (;;)
	{
		if (get_file_line2(file, string)==EOF)
			return EOF;

		/* ignore headers and such */
		if (string[0] == '-' || string[0] == ' ')
			continue;

		/* Check for a space within the first 13 characters */
		good = TRUE;
		for (i=0; i< FILE_SIZE; i++)
		{
			if (string[i] == '\0')
				break;

			if (string[i] == ' ' || string[i] == '\t')
			{
				while (i < FILE_SIZE)
				{
					if (string[i] == '\0')
						break;

					if (string[i] != ' ' && string[i] != '\t')
					{
						good = FALSE;
						break;
					}
					i++;
				}
				break;
			}
			if (string[i] < ' ' || string[i] == '?' || string[i] == '*') // string[i] > 127)
			{
				good = FALSE;
				break;
			}
		}
		if (!good)
			continue;

		split_string(string, string2);
		if (stricmp(string2, "area") == 0 && area != NULL)
		{
			*area = atol(string);
		}

		if (strlen(string2) > FILE_SIZE ||
			string2[0] == '.' || !is_dos_name(string2) ||
			(string2[0] >= 'a' && string2[0] <= 'z'))
		{
			continue;
		}
		strcpy(ret_string, string2);
		return 0;
	}
}

