#include "..\au.hpp"
/***************************************************************/

#define LAST_BYTE 18000 /* For speed purposed, don't check beyond this point */

struct CHECK
{
	int search_pos;
	char *match;
	int start_pos;
	char is_self;
	ARC_TYPE type;
	int version;		 // Version code to at least start with
} check[] =
{
	0,	   "PK\003",       0,     0,     ZIP, 4,    /* Pkzip */
	0,	   "ZOO",          0,     0,     ZOO, 10,   /* Zoo */
	0,	   "`",           0,     0,     ARJ, 8,    /* ARJ */
	0,	   "\x1A\x14\x00", 0,     0,     ARC7,52,   /* ARC 7.x */
	0,	   "HLSQZ1",       0,     0,     SQZ, 63,   /* SQZ 1.08 */
	0,	   "\x1aHP%",      0,     0,     HYP, 73,   /* Hyper 2.5 */
	0,	   "\x1aST%",      0,     0,     HYP, 73,   /* Hyper 2.5 */
	0,	   "HA",           0,     0,     HA,  74,   /* HA 0.98 */
	0,	   "HPAK",         0,     0,     HPK, 75,   /* Hpack 0.75c */
	0,	   "\x91" "3HF",   0,     0,     HAP, 76,   /* HAP 3.0 */
	0,	   "MDmd",         0,     0,     MD,  77,   /* MD 1.0 */
	2,	   "-lh",          0,     0,     LZH, 2,    /* LHA 1.x/2.x */
	2,	   "-lz",          0,     0,     LZS, 1,    /* Larc 3.33 */
	1262,  "-lh",          1260,  1,     LZH, 19,   /* LHARC .COM 1.12 file */
	1265,  "-lh",          1263,  1,     LZH, 14,   /* LHARC .COM 1.13 file */
	1292,  "-lh",          1290,  1,     LZH, 12,   /* LHARC .COM 1.0 */
	1294,  "-lh",          1292,  1,     LZH, 21,   /* LHARC .EXE 1.12S */
	1297,  "-lh",          1295,  1,     LZH, 16,   /* LHARC .EXE 1.13S */
	1324,  "-lh",          1322,  1,     LZH, 13,   /* LHARC .EXE 1.0 */
	1637,  "-lh",          1635,  1,     LZH, 17,   /* LHARC .EXE 2.05 */
	1638,  "-lh",          1636,  1,     LZH, 18,   /* LHARC .EXE 2.06 */
	1872,  "-lh",          1870,  1,     LZH, 15,   /* LHARC .EXE 1.13L */
	1873,  "-lh",          1871,  1,     LZH, 20,   /* LHARC .EXE 1.12L */
	2492,  "ZOO",          2535,  1,     ZOO, 59,   /* Sez (Zoo) 2.30 */
	4694,  "NoGate",       6674,  1,     PAK, 25,   /* PAK   .EXE 1.5x */
	4764,  "NoGate",       6744,  1,     PAK, 26,   /* PAK   .EXE 1.6x */
	4887,  "NoGate",       6867,  1,     PAK, 28,   /* PAK   .EXE 2.5x */
	5313,  "`",           5313,  1,     ARJ, 55,   /* ARJ   .EXE 2.30B JR */
	5329,  "`",           5329,  1,     ARJ, 58,   /* ARJ   .EXE 2.30 JR */
	5345,  "`",           5345,  1,     ARJ, 39,   /* ARJ   .EXE 2.10 JR */
	5377,  "`",           5377,  1,     ARJ, 41,   /* ARJ   .EXE 2.20 JR */
	5393,  "`",           5393,  1,     ARJ, 56,   /* ARJ   .EXE 2.22 JR */
	5473,  "`",           5473,  1,     ARJ, 68,   /* ARJ   .EXE 2.39A JR */
	5763,  "`",           5763,  1,     ARJ, 70,   /* ARJ   .EXE 2.39F JR */
	5779,  "`",           5779,  1,     ARJ, 72,   /* ARJ   .EXE 2.41 JR */
	5947,  "`",           5947,  1,     ARJ, 33,   /* ARJ   .EXE 1.0 JR */
	6159,  "`",           6159,  1,     ARJ, 35,   /* ARJ   .EXE 1.10 JR */
	6160,  "`",           6160,  1,     ARJ, 37,   /* ARJ   .EXE 2.00 JR */
	6679,  "NoGate",       8601,  1,     PAK, 27,   /* PAK   .EXE 2.0x - 2.1x */
	6834,  "Buerg",        7746,  1,     ARC, 42,   /* ARC   .EXE 6.00 */
	6836,  "Buerg",        7716,  1,     ARC, 43,   /* ARC   .EXE 6.02 */
	8929,  "PKWARE",       9758,  1,     ARC, 29,   /* PKARC .EXE 3.5 */
	9774,  "PKWARE",       13138, 1,     ARC, 31,   /* PKARC .EXE 3.61 */
	9790,  "PKWARE",       13160, 1,     ARC, 30,   /* PKARC .EXE 3.6 */
	12784, "PK\003",       12784, 1,     ZIP, 24,   /* PKZIP .EXE 1.10 */
	13989, "`",           13989, 1,     ARJ, 32,   /* ARJ   .EXE 1.00 */
	14039, "`",           14039, 1,     ARJ, 34,   /* ARJ   .EXE 1.10 */
	14060, "`",           14060, 1,     ARJ, 36,   /* ARJ   .EXE 2.00 */
	14666, "`",           14666, 1,     ARJ, 38,   /* ARJ   .EXE 2.10 */
	14778, "`",           14778, 1,     ARJ, 40,   /* ARJ   .EXE 2.20 */
	14810, "`",           14810, 1,     ARJ, 54,   /* ARJ   .EXE 2.30B */
	14858, "`",           14858, 1,     ARJ, 57,   /* ARJ   .EXE 2.30  */
	15104, "`",           15104, 1,     ARJ, 67,   /* ARJ   .EXE 2.39A */
	15106, "`",           15106, 1,     ARJ, 71,   /* ARJ   .EXE 2.41 */
	15122, "`",           15122, 1,     ARJ, 69,   /* ARJ   .EXE 2.39F */
	15198, "PK\003",       15198, 1,     ZIP, 22,   /* PKZIP .EXE 0.92 */
	15512, "PK\003",       15512, 1,     ZIP, 23,   /* PKZIP .EXE 1.02 */
	15563, "PK\003",       15563, 1,     ZIP, 64,   /* PKZIP .EXE 2.00 */
};

/**/
static void set_trailer_pos(AU *au, ARC_FILE *arcFile)
{
	ARC_RECORD record;
	long pos;
	int  retCode;

	arcFile->trailer_pos = -1;		  /* No trailer by default */
	pos = arcFile->pos;

	while ((retCode = get_record(au, arcFile, &record)) >= 0)
	{
		if (retCode == -2)
			goto Error0;
	}

	if (my_getc_1(arcFile->file) == 254)
		arcFile->trailer_pos = lseek(arcFile->file, 0, SEEK_CUR);

Error0:
	arcFile->pos = pos;
	arcFile->isFirst = TRUE;
	arcFile->rec_number = 0;
	return;
}

/**/
static char pos_check(char *buffer, int num_chars, int pos, char *search)
{
	int len;

	len = strlen(search);
	if (num_chars < pos+len)
		return FALSE;

	if (memcmp(search, buffer+pos, len) == 0)
		return TRUE;
	else
		return FALSE;
}
/**/
ARC_TYPE get_format(AU *au, char *file_name, ARC_FILE *arcFile)
{
	int 	 c,d,e;
	int 	 num_chars;
	int 	 i;
	ARC_TYPE retCode;
	char	*buffer;

	buffer = (char *)au_malloc(au, LAST_BYTE);
	lseek(arcFile->file, 0, SEEK_SET);
	num_chars = read(arcFile->file, buffer, LAST_BYTE);

	arcFile->is_self = FALSE;
	arcFile->version = 0;	   /* Unknown */
	arcFile->pos = 0;

	for (i=0; i<sizeof(check)/sizeof(struct CHECK); i++)
	{
		if (pos_check(buffer, num_chars, check[i].search_pos, check[i].match))
		{
			if (check[i].is_self)
			{
				if (!au->self_extracts)
					break;
				if (strstr(file_name, ".COM") == NULL &&
					strstr(file_name, ".EXE") == NULL)
				{
					break;
				}
			}
			arcFile->pos = (long)check[i].start_pos;
			arcFile->version = check[i].version;
			arcFile->is_self = check[i].is_self;
			retCode = check[i].type;
			goto Error0;
		}
	}

/* Arj is pretty flakey about changing every darn version.	there lite
   self extractors seem to work in the 5000 to 6500 range, the regular
   from 13500 to 18000 */

	if (num_chars > 5000)
	{
		c = 6500;
		if (c > num_chars)
			c = num_chars;
		c--;
		for (i=5000; i<c; i++)
		{
			if (buffer[i] == '\x60' && buffer[i+1] == '\xEA' &&
				(long)buffer[i+3]*256 + buffer[i+2] < 2600)
			{
				arcFile->pos = i;
				arcFile->version = 65;
				arcFile->is_self = TRUE;
				retCode = ARJ;
				goto Error0;
			}
		}
	}

	if (num_chars > 13500)
	{
		c = 18000;
		if (c > num_chars)
			c = num_chars;
		c--;
		for (i=13500; i<c; i++)
		{
			if (buffer[i] == '\x60' && buffer[i+1] == '\xEA' &&
				(long)buffer[i+3]*256 + buffer[i+2] < 2600)
			{
				arcFile->pos = i;
				arcFile->version = 66;
				arcFile->is_self = TRUE;
				retCode = ARJ;
				goto Error0;
			}
		}
	}

/* now try for the more obsure ones *************************/

	lseek(arcFile->file, 0, SEEK_SET);
	c=my_getc_1(arcFile->file);
	d=my_getc_1(arcFile->file);

	if (c == 26 && d > 0 && d < 12)
	{
		lseek(arcFile->file, -2, SEEK_END); 	  /* 2 from the end */
		i=-3;
		while ((c=my_getc_1(arcFile->file))=='\0' && i>-129)  /* for Xmodem transfers */
		{
		   lseek(arcFile->file,i, SEEK_END);
		   i--;
		}
		lseek(arcFile->file, 0, SEEK_SET);
		if (c==26)
		{
			arcFile->version = 47;
			retCode = ARC;
			goto Error0;
		}
		else
		{
			arcFile->version = 48;
			retCode = PAK;
			goto Error0;
		}
	}

	if (c == 0x00 && d == 0x20)
	{
		if (my_getc_1(arcFile->file) == 0x20)
		{
			lseek(arcFile->file, 10, SEEK_SET);
			c=my_getc_1(arcFile->file);
			d=my_getc_1(arcFile->file);
			e=my_getc_1(arcFile->file);
			if (c==0x20 && d==0x20 && e==0x00)
			{
				arcFile->version = 61;
				retCode = LBR;
				goto Error0;
			}
		}
	}

	lseek(arcFile->file, -3, SEEK_END);
	i=-4;
	while ((c=my_getc_1(arcFile->file))=='\0' && i>-129)  /* for Xmodem transfers */
	{
		lseek(arcFile->file,-2, SEEK_CUR);
		i--;
	}
	d=my_getc_1(arcFile->file);
	e=my_getc_1(arcFile->file);

	if (c=='D' && d=='W' && e=='C')
	{
		arcFile->version = 11;
		retCode = DWC;
		goto Error0;
	}

	retCode = (ARC_TYPE)0;				 /* Not an archive */

Error0:
	free(buffer);

	/* Set the trailer information pointer if .PAK */
	if (retCode == PAK && au->unarc_paths == ON)
	{
		set_trailer_pos(au, arcFile);
		return PAK;
	}
	if (retCode == ARC)
	{
		set_trailer_pos(au, arcFile);
		if (arcFile->trailer_pos == -1)
			return ARC;
		else
		{
			if (au->unarc_paths != ON)
				arcFile->trailer_pos = -1;
			arcFile->version = 48;
			return PAK;
		}
	}
	return retCode;
}


