#include "..\au.hpp"

/**************************************************************************/
void au_invalid_option(AU *au, char *program, char option)
{
	au_printf_error(au, "Invalid Command Line Option '%c'", option);
	au_printf(au, "Type @?2AU@?6 %s @?3-?@?H for help\n", program);
	exit(0);
}
/**************************************************************************/
void au_syntax_message(AU *au, char *action)
{
	au_printf(au, "@?5Syntax:@?H\n   @?2AU@?6 %s@?H ", action);
}
/**************************************************************************/
void au_opt_filespec_message(AU *au)
{
	au_printf(au, "[@?3options@?H] [@?1filespec(s)@?H]\n\n");
}
/**************************************************************************/
void au_filespec_message(AU *au)
{
	au_printf(au, "[@?1filespec(s)@?H]\n\n");
}
/***************************************************************************/
void au_param_heading(AU *au)
{
	au_printf(au, PARAM_HEADING);
}
/****************************************************************************/
void au_standard_opt_header(AU *au, char *action, char *options)
{
	au_syntax_message(au, action);
	if (options != NULL && options[0] != '\0')
	{
		au_opt_filespec_message(au);
		au_param_heading(au);
		au_printf(au, options);
	}
	else
		au_filespec_message(au);
}
/*****************************************************************************/
void au_invalid_cfg_option(AU *au, char *option, char *file, int line)
{
	au_printf_error(au, "Unknown command \"%s\" in %s at line %d",
					option, file, line);
	exit(0);
}
