#include "..\au.hpp"
/*****************************************************************************/
BYTE archive_is_old(int version)
{
	switch (version)
	{
		case 1: case 2: case 4: case 5: case 6: case 7: case 10:
		case 12: case 13: case 14: case 15: case 16: case 19: case 20: case 21:
		case 22: case 23: case 24: case 25: case 26: case 27: case 32: case 33:
		case 34: case 35: case 36: case 37: case 38: case 39: case 40: case 41:
		case 42: case 43: case 56: case 62: case 29:
			return TRUE;
		default:
			return FALSE;
	}
}
/*****************************************************************************/
BYTE file_is_not_optimal(int method)
{
	switch (method)
	{
		case 2:  case 3:  case 4:  case 5:
		case 7:  case 9:  case 11: case 12: case 13: case 14: case 15:
		case 17: case 18: case 19: case 20: case 22: case 23: case 26:
		case 28: case 29: case 35:
			return TRUE;
		default:
			return FALSE;
	}
}
/*****************************************************************************/
BYTE file_is_stored(int method)
{
	if (method == 1)
		return TRUE;
	else
		return FALSE;
}
/*****************************************************************************/
BYTE archive_is_optimal(AU *au, char *file_name, ARC_FILE *arcFile)
{
	ARC_RECORD record;
	int ret_code;
	BYTE optimal = TRUE;

	for (;;)
	{
		ret_code = get_record(au, arcFile, &record);
		if (ret_code == EOF)
			break;
		else if (ret_code == -2)
		{
			add_to_bad_list(au, au->source_directory, file_name, 0);
			return -1;
		}
		else if (ret_code == -3)
			return -1;

		if (file_is_not_optimal(record.method) &&
			!file_is_stored(record.method))
		{
			optimal = FALSE;
		}
	}
	return optimal;
}
