// WHATIS.CPP								 1		  1    6666
// Dave Harris								11		 11   6
// Compiled using Borland C++ ver 3.1	   1 1		1 1   6666
// 03-03-94 								 1	 ..   1   6   6
//										   11111 .. 11111  666
////////////////////////////////////////////////////////////////////////

#include "au.hpp"      // Globally used defines

/*********************************************************************/
/* Define Statements */
/*********************/

#define PROGRAM "WHATIS"  // Name of module

/*********************************************************************/
/* Structures */
/**************/

typedef struct TYPE
{
	char *desc;
	int  errorlevel;	  // errorlevel to return
	BYTE color;
	char nocase;
	unsigned char action[100];
} TYPE;

#define START	  255	 // Goto byte
#define END 	  254	 // Goto byte from end
#define MATCH1	  253	 // match a byte
#define MATCH2	  252	 // match a word

/*********************************************************************/
/* Global Variables */
/********************/

/* Command line/Config options */

typedef struct
{
	TYPE *type;
	int type_number;	 // current element of type being added to
	int action_pos;
	int errorlevel;
} WHATIS_INFO;

/**/
static int whatis(AU *au, char *file_name)
{
	HANDLE file;
	int i,pos;
	WHATIS_INFO *in = (WHATIS_INFO *)au->info;

	au->number_processed++;
	file = au_open(au, file_name);
	for (i=0; i<=in->type_number; i++)
	{
		pos = 0;
		for(EVER)
		{
			switch(in->type[i].action[pos++])
			{
			case 0:
				au_printf_c(au, in->type[i].color, "%-*s  %s\n", FILE_SIZE,
							file_name, in->type[i].desc, in->type[i].desc);
				in->errorlevel = in->type[i].errorlevel;
				close(file);
				return 0;
			case START:
				lseek(file, *(long *)(in->type[i].action+pos), SEEK_SET);
				pos+=4;
				break;
			case END:
				lseek(file, *(long *)(in->type[i].action+pos), SEEK_END);
				pos+=4;
				break;
			case MATCH1:
			{
				char ch1 = my_getc_1(file);
				char ch2 = in->type[i].action[pos++];
				if (in->type[i].nocase)
				{
					ch1 = toupper(ch1);
					ch2 = toupper(ch2);
				}
				if (ch1 != ch2)
					goto around;
				break;
			}
			case MATCH2:
				break;
			}
		}
around: ;
	}
	close(file);
	au_printf_c(au, 7, "%-*s  other\n", FILE_SIZE, file_name);
	return 0;
}
/**/
static long read_number(AU *au, char *string, char *cfg_file, int cfg_line)
{
	long number=0;
	int  pos=0;
	int  negate = FALSE;
	int  i;

	if (string[0]=='-')
	{
		negate = TRUE;
		pos = 1;
	}
	if (string[pos]=='0')
	{
		if (toupper(string[pos+1]) == 'X')    // Hex
		{
			for (i=pos+2; i<strlen(string); i++)
			{
				string[i] = toupper(string[i]);
				number*=16;
				if (string[i]>='A' && string[i]<='F')
					number+=string[i]-'A'+10;
				else if (string[i]>='0' && string[i]<='9')
					number+=string[i]-'0';
				else
				{
					au_printf_error(au, "Bad hex constant in file %s: line %d",
						   cfg_file, cfg_line);
					exit(0);
				}
			}
		}
		else										 // Octal
		{
			for (i=pos+1; i<strlen(string); i++)
			{
				number*=8;
				if (string[i]>='0' && string[i]<='7')
					number+=string[i]-'0';
				else
				{
					au_printf_error(au, "Bad octal constant in line %d", cfg_line);
					exit(0);
				}
			}
		}
	}
	else											// Decimal
	{
		for (i=pos; i<strlen(string); i++)
		{
			number*=10;
			if (string[i]>='0' && string[i]<='9')
				number+=string[i]-'0';
			else
			{
				au_printf_error(au, "Bad Decimal constant in line %d", cfg_line);
				exit(0);
			}
		}
	}
	if (negate)
		return -number;
	else
		return number;
}
/**/
static void ReadCFGInfo(AU *au, HANDLE file, char *cfg_file, int *cfg_line)
{
   char string[200],
		string2[200],
		string3[200];

   int len;
   int i;
   WHATIS_INFO *in = (WHATIS_INFO *)au->info;

   for(EVER)
   {

	  if (get_file_line(au, file, string)==EOF)
		 break;
	  (*cfg_line)++;

/////////////////////////////////////////
around:
	  ltrim(string);
	  if (string[0] == '\0')
		 continue;

	  if (string[0] == '\"')
	  {
		 len = strlen(string);
		 string[0] = ' ';
		 for (i=1; i<len; i++)
		 {
			if (string[i]=='\"')
			{
			   string[i] = ' ';
			   goto around;
			}
			in->type[in->type_number].action[in->action_pos++] = MATCH1;
			in->type[in->type_number].action[in->action_pos++] = string[i];
			string[i] = ' ';  // so ltrim will hack it off
		 }
		 au_printf_error(au, "\" missing in line %d", *cfg_line);
		 exit(0);
	  }

	  split_string(string, string2);
	  switch (toupper(string2[1]) << 8 | toupper(string2[0]))
	  {
		 case 'BE':                                          // Begin
			return;
		 case 'TY':                                          // Type
		 {
			int len,i;

			in->type_number++;
			in->action_pos = 0;
			in->type[in->type_number].color = 7;
			if (string[0]!='\"')
			{
			   au_printf_error(au, "\" missing in line %d", *cfg_line);
			   exit(0);
			}
			string[0]=' ';
			len=strlen(string);
			for (i=1 ; i<len ; i++)
			{
			   if (string[i]=='\"')
			   {
				  string[i] = ' ';
				  goto bp1;
			   }
			   string2[i-1] = string[i];
			   string[i] = ' ';
			}
			au_printf_error(au, "\" missing in line %d", *cfg_line);
			exit(0);
bp1:
			string2[i-1] = '\0';
			in->type[in->type_number].desc =
					  (char *)au_malloc(au, strlen(string2)+1);
			strcpy(in->type[in->type_number].desc,string2);
			goto around;
		 }
		 case 'ST':
			split_string(string, string2);
			in->type[in->type_number].action[in->action_pos++] = START;
			*(long *)(in->type[in->type_number].action+in->action_pos) =
				read_number(au, string2, cfg_file, *cfg_line);
			in->action_pos+=4;
			goto around;
		 case 'EN':
			split_string(string, string2);
			in->type[in->type_number].action[in->action_pos++] = END;
			*(long *)(in->type[in->type_number].action+in->action_pos) =
				read_number(au, string2, cfg_file, *cfg_line);
			in->action_pos+=4;
			goto around;
		 case 'ER':
			split_string(string, string2);
			in->type[in->type_number].errorlevel =
				read_number(au, string2, cfg_file, *cfg_line);
			goto around;
		 case 'CO':
			split_string(string, string2);
			in->type[in->type_number].color =
				read_number(au, string2, cfg_file, *cfg_line) % 16;
			goto around;
		 case 'NO':
			in->type[in->type_number].nocase = TRUE;
			goto around;
		 default:				 /* number of some sort probably */
		 {
			long number;

			number = read_number(au, string2, cfg_file, *cfg_line);
			if (number <= 255)
			{
			   in->type[in->type_number].action[in->action_pos++] = MATCH1;
			   in->type[in->type_number].action[in->action_pos++] = number;
			}
			else
			{
			   in->type[in->type_number].action[in->action_pos++] = MATCH2;
			   *(int *)(in->type[in->type_number].action[in->action_pos+=2]) = number;
			}
			goto around;
		 }		   /* End Default */
	  } 		/* End Switch */
   }		 /* End For */
}
/**/
static BYTE parse_comm_line(AU *au, char option, char *cur_argv,
							PARSE_TYPE type)
{
	Unused(cur_argv);

	switch (type)
	{
	case PARSE_PARAM_OPTION:
		switch (option)
		{
		case '?':
			au_standard_opt_header(au, "Whatis", NULL);
			exit (0);
		default:
			au_invalid_option(au, PROGRAM, option);
		}
		return TRUE;
	}
	return FALSE;
}
/**/
int main_whatis(AU *au, int argc, char *argv[])
{
	int retCode;
	WHATIS_INFO *in;

	in = (WHATIS_INFO *)au_malloc(au, sizeof(WHATIS_INFO));
	memset(in, '\0', sizeof(WHATIS_INFO));
	au->info = in;

	in->type = (TYPE *)au_malloc(au, sizeof(TYPE)*200);
	if (in->type == NULL)
	{
		au_printf_error(au, "Out of Memory\n");
		exit(1);
	}
	in->type_number = -1;

	ReadGlobalCFGInfo(au, au->cfg_file, PROGRAM, ReadCFGInfo);
	generic_parse_comm_line(au, argc, argv, parse_comm_line);
	process_files(au, whatis);

	if (!au->no_extra)
	{
		au_printf_c(au, 15, "\nFiles Processed = %d\n", au->number_processed);
		au_printf_c(au, 15, "Exiting with errorlevel %d\n", in->errorlevel);
	}

	retCode = in->errorlevel;
	free(in->type);
	return retCode;
}

