procedure SortLengths(var tree: sf_tree);
   {Sort the Bit Lengths in ascending order, while retaining the order
    of the original lengths stored in the file}
var
   x:       integer;
   gap:     integer;
   t:       sf_entry;
   noswaps: boolean;
   a,b:     integer;
 
begin
   gap := tree.entries div 2;
 
   repeat
      repeat
         noswaps := true;
         for x := 0 to (tree.entries-1)-gap do
         begin
            a := tree.entry[x].BitLength;
            b := tree.entry[x+gap].BitLength;
            if (a > b) or
               ((a = b) and (tree.entry[x].Value > tree.entry[x+gap].Value)) then
            begin
               t := tree.entry[x];
               tree.entry[x] := tree.entry[x+gap];
               tree.entry[x+gap] := t;
               noswaps := false;
            end;
         end;
      until noswaps;
 
      gap := gap div 2;
   until gap < 1;
end;
