
{$I LZDefine.inc}

unit ChfTypes;
{type definitions for the ChiefLZ package}

interface

{$ifdef Win32}
uses
  SysUtils;

Type
EChiefLZError    = class(Exception);
EChiefLZCompress = class(EChiefLZError);
EChiefLZArchive  = class(EChiefLZCompress);
Type
EChiefLZDLL      = class(EChiefLZError);
{$endif}

Type
TLZFileStr = String[12];
TLZExtStr  = {$ifdef Win32} string {$else} String[4]  {$endif};
TLZPathStr = {$ifdef Win32} string {$else} String[80] {$endif};
TLZSigStr  = String[18];
TLZVerStr  = String[8];

Type
TLZReportRec = packed Record
{any version information?}
   FileVersion: TLZVerStr;
{compressed sizes}
   Sizes: LongInt;
{uncompressed sizes}
   uSizes:LongInt;
{date/time stamps}
   Times: LongInt;
{file names}
   Names: TLZPathStr;
{is it a Directory?}
   IsDir: Boolean; {introduced this for LZ report and Question procedures}
end;

Type
TLZReportProc=Procedure(Const aName:TLZReportRec{String};Const aSize:LongInt);
{procedural type for status/progress information
            aName=file record information
            aSize=filesize (compressed)
}

Type
TLZReply = (LZNo, LZYes, LZQuit);
TLZQuestionFunc=Function(const aName: TLZReportRec;Const aExist:string): TLZReply;
{optionally used by the LZOBJ object;

procedural type to ask whether an existing file should
be overwritten - the filename is sent to your function
in "aName" - your function should return TRUE if you
want the file to be overwritten. If no function is pointed
to, the default is to overwrite existing files.
}

Type
TLZRenameFunc = function(var Name: string): boolean;
{
  Function type to determine whether to abort a file operation,
  or rename the file.
}

{header for ChiefLZ archives}
Const
MaxChiefLZArchiveSize =
{$ifndef Win32}
600; {max number of files in archives: absolute max for 16-bit is 606}
{$else Win32}
2048;{max number of files in archives - let's use more for Win32}
{$endif Win32}
Const
MaxChiefLZDirectories = (MaxChiefLZArchiveSize div 2);


Type
TLZFileRec= packed Record
{is it a directory?}
       IsDir: Boolean;
{its directory ID}
       DirID: Word;
{its parent directory ID}
       ParentDir: Word;
{any version information?}
       FileVersion : TLZVerStr;
{is it compressed?}
       Compressed:Boolean;
{compressed sizes}
       Sizes: LongInt;
{uncompressed sizes}
       uSizes:LongInt;
{date/time stamps}
       Times: LongInt;
{file names}
       Names: TLZFileStr;
end;

Type TLZCount = Word;
Type TLZRecurse = (LZNoRecurse, LZRecurseOnce, LZFullRecurse);

TLZArchiveHeader = packed Record
{Chief signature}
   Signature: TLZSigStr;
   Count:     TLZCount
end;

Type
PChiefLZArchiveHeader = ^TChiefLZArchiveHeader;
TChiefLZArchiveHeader = packed Record
   Count : TLZCount;
   Files : Array[1..MaxChiefLZArchiveSize] of TLZFileRec
end;

Type
{$ifDef Win32}
StrType=String;
{$else}
StrType=Array[0..255] of char;
{$endif}

implementation

end.

