/* CRUNCH.C -- Quick, easy data Compression *
 * (c) 1987 Andrew Binstock. July 1987      *
 * Use Freely but retain copyright notice.  *
 * From The C Gazette, December 1987.       *
 * *****************************************/

/* Validated for DeSmet, Microsoft 4.0 */

#define MSC 1               /* Boolean for Microsoft 4.0 */

#include <stdio.h>
#include <dos.h>

#if MSC
#include <fcntl.h>
#include <io.h>
_fmode = O_BINARY;          /* Everything done in binary */
#endif

#define TRIGGER 0xFE        /* Change here for a different trigger char */
#define BUFSIZE 1024        /* For bigger buffers, change here */

#if MSC 
#define READ    O_RDONLY|O_BINARY
#define ERR     (-1)
#define TRUE    (1)
#define FALSE   (0)
#endif

int infile, outfile;

main (argc, argv)
int  argc;
char *argv[];
{

    char buffer [BUFSIZE];
    int  eof = 0;

    char infile_name[80], outfile_name[80];

    unsigned char previous, count;
    int  bytes, i;
    int  first_time = TRUE;

    if (argc < 3)
        {
            puts ("Usage: crunch input-file output-file");
            exit(5);
        }

    strcpy (infile_name,  argv[1]);
    strcpy (outfile_name, argv[2]);
       
    if ((infile = (open (infile_name, READ))) == ERR)  /* Make Binary Open */
        {
            printf ("File %s cannot be found.\n", infile_name);
            exit (10);
        }

    outfile = (creat (outfile_name));

    while (eof != TRUE)
    {
        bytes = read (infile, buffer, BUFSIZE);   /* Binary mode */
        
        if (bytes == -1)
           {
               eof = TRUE;
               break;
           }

        if (first_time == TRUE)   /* Initialization for first read */
           {
               previous = buffer[0];
               count    = 1;
               i        = 1;
               first_time = FALSE;
           }
        else i = 0;

        for ( ; i < bytes; i++)
            {
                if (buffer[i] == previous)      /* A repetition */
                   {
                         ++count;
                         if (count == 255)      /* Don't overflow count */
                            {
                                write_code (TRIGGER, count, previous);
                                count = 0;
                            }                            
                         continue;
                   }
                 else
                   {
                         if (count < 3)         /* A new character */
                            {                   /* so clear old chars */
                              if (previous == TRIGGER)
                                 do {
                                       unsigned char zero_count = '\0';
                                       write (outfile, &previous, 1);
                                       write (outfile, &zero_count, 1);
                                    }
                                       while (--count);
                              else
                                do  {
                                       write (outfile, &previous, 1);
                                    }
                                       while (--count);
                            }
                          else
                            {
                              write_code (TRIGGER, count, previous);
                            }

                          previous = buffer [i];
                          count = 1;

                   }        /* end of character process */
            }               /* end of buffer process */

        if (bytes < BUFSIZE)            /* Was that the last buffer ? */
            eof = TRUE;
    }                       /* end of file */


    if (count > 2)                      /* Flush remaining characters */
        write_code (TRIGGER, count, previous);
    else
        while (count--)
              write (outfile, &previous, 1);

    close (infile);
    close (outfile);
}                           /* end of main () */

/****************************************
    Function to write the escape code
    with repeating char and counts.
*****************************************/
int write_code (esc, repeats, the_char)
unsigned char esc,                          /* The escape char */
              repeats,                      /* Repetitions     */
              the_char;                     /* Actual character */
{
    char code [3];
    
    code [0] = esc;                         /* Load up code sequence */
    code [1] = repeats;
    code [2] = the_char;
    write (outfile, &code[0], 3);           /* Write it out */
}
