/* UNCRUNCH.C -- Expands a crunched file *
 * see companion program: crunch.c       * 
 * (c) 1987 Copyright, Andrew Binstock   *
 * from The C Gazette, December, 1987    */

/* ver. 1.1. Contains correction to the  *
 * version in The C Gazette.             */

/* Validated for DeSmet, Microsoft */

#include <stdio.h>
#include <dos.h>

#define MSC 1                   /* Toggle for Microsoft 4.0 */

#define TRUE   1
#define ERR  (-1)

#if MSC
#include <fcntl.h>
_fmode = O_BINARY;
#endif

#define TRIGGER 0xFE
#define BUFSIZE 1024

FILE *infile, *outfile;

main (argc, argv)
int  argc;
char *argv[];
{
    unsigned char buffer [BUFSIZE];
    int  eof = 0;
    int  bytes, count, i;

    char infile_name[80], outfile_name[80];

    if (argc < 3)
       {
            puts ("Usage: uncrunch filename expanded-file-name\n");
            exit (5);
       }

    strcpy (infile_name,  argv[1]);
    strcpy (outfile_name, argv[2]);

    if ((infile = fopen (infile_name, "rb")) == NULL)
        {
            printf ("Could not find/open %s\n", infile_name);
            exit (10);
        }

    outfile = fopen (outfile_name, "wb");

    while (eof != TRUE)
    {
        bytes = fill_buffer (buffer);

        if (bytes == EOF)
           {
               eof = TRUE;
               break;
           }


        for (i = 0; i < bytes; i++)
            {
                if (buffer[i] != TRIGGER)      /* Regular Character */
                   {
                        putc (buffer[i], outfile);
                   }
                else
                   {                           /* Char is Trigger */
                        if (i == (bytes - 1))  /* Are we at end of buffer? */
                           {
                                bytes = fill_buffer (buffer);
                                i = -1;
                           }

                        if (buffer[++i] == 0)           /* No repeats */
                            putc (TRIGGER, outfile);
                        else
/* M */                    {        
/* O */                         count = buffer[i];
/* D */                         if (i == (bytes - 1))   /* End of Buffer? */
/* I */                            {
/* F */                                 bytes = fill_buffer (buffer);
/* I */                                 i = -1;
/* E */                            }
/* D */                         i++;
                                while (count--)         /* Do Repeats     */
                                       putc (buffer[i], outfile);
                           }
                   }
            }

        if (bytes < BUFSIZE)
            break;              /* We have already read final buffer */
    }

    close (infile);
    close (outfile);
    exit  (1);
}

int fill_buffer (buff)  /* Reads another buffer of data */
char buff [];
{
    return (fread (buff, 1, BUFSIZE, infile));
}
