/*	dohuf.c
 *
 *	Author:			J.F.R. "Frank" Slinkman
 *					Copyright 1993 -- All Rights Reserved!
 *	Compiler:		Pro-MC
 *	Libraries:		Slinkman Pro-MC Hi-Res graphics library
 *	Source:			"C Programming Column," Dr. Dobb's Journal, Feb. 1991.
 *					Note:  listings accompanying article contain bugs!
 *
 *	This program reorganizes the 640 x 240 TRS-80 hi-res screen into 19,200
 *	4 pixel by 2 pixel "squares."  Then, using the Huffman algorithm, it
 *	compresses that data, and writes the compressed data to the output.
 */

#include	<stdio.h>
#option	INLIB
#option	REDIRECT	OFF
#option	FIXBUFS	ON
#option	MAXFILES	1
#define	XREG	128
#define YREG	129
#define GFXDAT	130
#define TREE struct tree

void	loadHRfile(), get_counts(), buildtree(), dataout(), compress();
void	outbit();

FILE	*fp;
char	f_name1[15], f_name2[15], cant_open[15] = { "Can't open %s\n" };
TREE	{	char code;			/* code value				*/
			int  count;			/* code count				*/
			TREE *parent;		/* pointer to parent		*/
			TREE *rite;			/* pointer to right child	*/
			TREE *left;			/* pointer to left child	*/
		}	huftree[511];

/*=*=*=*=*=*=*/

main( argc, argv )
int argc; char **argv;
{
/*	check command line parameters  */

	if ( argc != 3 )
	{	puts( "usage: dohuf infile[/hr][:d] outfile[/huf][:d]" );
		exit(EOF);
	}

/*	build filenames from command line args  */

	addext( strcpy( f_name1, argv[1] ), "hr" );
	addext( strcpy( f_name2, argv[2] ), "huf" );

/*	null out huffman tree  */

	memset( huftree, 0, sizeof huftree );

/*	load /HR file into graphics board RAM  */

	loadHRfile( f_name1 );

/*	open /HUF file	*/

	if ( !( fp = fopen( f_name2, "w" ) ) )
	{	printf( cant_open, f_name2 );
		exit(EOF);
	}

	get_counts();
	buildtree();
	dataout();

	fclose( fp );
}

/*=*=*=*=*=*=*/

void loadHRfile( filename )
char	*filename;
{
	if ( !( fp = fopen( filename, "r" ) ) )
	{	printf( cant_open, filename );
		exit(EOF);
	}
	gfx_mode(1);
	gfx_cls();
	if ( getimage( fp ) == EOF )
	{	printf( "Can't read %s\n", filename );
		exit(EOF);
	}
	gfx_mode(0);
	fclose( fp );
}

/*=*=*=*=*=*=*/

void get_counts()
{
	static int	i, x, y;
	int			counts[256];

/*	initialize all counts to zero  */

	memset( counts, 0, sizeof counts );

/*	get the 19,200 pixel squares, and count how many of each  */

	for ( y = 0; y < 240; y += 2 )
		for ( x = 0; x < 160; x++ )
			++*(counts + get_square( x,y ) );

/*	write the 256 counts to the output file  */

	fwrite( counts, sizeof(int), 256, fp );

/*	assign code values and copy the counts
 *	to the first 256 huffman tree members  */

	for ( i = 0; i < 256; i++ )
	{	huftree[i].code = i;
		huftree[i].count = counts[i];
	}
}

/*=*=*=*=*=*=*/

int get_square( x, y )
int	x, y;
{
	static int	dat1, dat2;

/*	get upper of two vertically adjacent graphics RAM bytes  */

	outport( XREG, x >> 1 );
	outport( YREG, y );
	dat1 = inport( GFXDAT );

/*	get the lower byte	*/

	outport( YREG, y + 1 );
	dat2 = inport( GFXDAT );

	if ( x & 1 )

/*	if on right side, move right nibble of upper byte
	to left and mask out left nibble of lower byte  */

		return ( ( dat1 << 4 ) | ( dat2 & 0x0f ) ) & 0xff;

	else

/*	if on left side, mask out right nibble of upper
	byte and shift left nibble of lower byte to right  */

		return ( dat1 & 0xf0 ) | ( dat2 >> 4 );
}

/*=*=*=*=*=*=*/

void buildtree()
{
	static TREE		*ptr1, *ptr2, *temp, *limit;

	limit = huftree + 256;

	while ( TRUE )
	{
		temp = huftree;

		while ( temp->parent || !temp->count )
			++temp;
		ptr1 = temp++;

		while ( ( temp->parent || !temp->count ) && temp < limit )
			++temp;
		if ( ( ptr2 = temp ) == limit )
			break;

	/*	always keep lower count in ptr2  */

		if ( ptr1->count < ptr2->count )
		{	ptr2 = ptr1;
			ptr1 = temp;
		}

		while ( ++temp < limit )
			if ( !temp->parent && temp->count )
			{	if ( temp->count < ptr2->count )

		/*	if ptr1 >= ptr2 > new, then if ptr1 == ptr2 keep ptr1  */

				{	if ( ptr1->count > ptr2->count )
						ptr1 = ptr2;
					ptr2 = temp;
				}
				else if ( temp->count < ptr1->count )

			/*	if ptr1 > new > ptr2, put new in ptr1  */

					ptr1 = temp;
			}

		ptr1->parent = ptr2->parent = limit;
		limit->count = ptr1->count + ptr2->count;
		limit->rite = ptr1;
		limit->left = ptr2;
		++limit;
	}
}

/*=*=*=*=*=*=*/

void dataout()
{
	static int	x, y;

	for ( y = 0; y < 240; y += 2 )
		for ( x = 0; x < 160; x++ )
			compress( huftree + get_square( x,y ), NULL );
	outbit( EOF );
}

/*=*=*=*=*=*=*/

void compress( this, prior )
TREE	*this, *prior;
{
/*	recursive calls step from leaf to root of tree	*/

	if ( this->parent )
		compress( this->parent, this );

/*	recursive returns send TRUE (1) if left or FALSE (0) if right,
	and in reverse order (i.e., in order of root to leaf )	*/

	if ( prior )
		outbit( prior == this->left );
}

/*=*=*=*=*=*=*/

void outbit( bit )
int		bit;
{
	static int	byte = 0, ctr = 0;

	if ( bit == EOF )					/*	code to flush 8-bit buffer */
	{	if ( !ctr )
			return;						/*	do nothing if buffer empty	*/
		else
		{	byte <<= 8 - ctr;			/*	else move bits to extreme left	*/
			ctr = 8;					/*	and force write to file  */
		}
	}
	if ( ctr == 8 )
	{	if ( putc( byte, fp ) != byte )
		{	perror( "putc()" );
			exit(EOF);
		}
		ctr = byte = 0;
	}
	byte = ( byte << 1 ) | bit;
	++ctr;
}
