/*	unhuf.c
 *
 *	Author:			J.F.R. "Frank" Slinkman
 *					Copyright 1993 -- All Rights Reserved!
 *	Compiler:		Pro-MC
 *	Libraries:		Slinkman Pro-MC Hi-Res graphics library
 *	Source:			"C Programming Column", Dr. Dobbs Journal, Feb 1991.
 *					Note:  listings accompanying article contains bugs!
 *
 *	This program reads the Huffman-compressed files created by the companion
 *	program, "dohuf.c," decompresses the data, displays it on the hi-res
 *	graphics screen, then writes the uncompressed image data from screen to
 *	an /HR file.
 */

#include	<stdio.h>
#option	INLIB
#option	REDIRECT	OFF
#option	FIXBUFS	ON
#option	MAXFILES	1
#define	XREG	128
#define YREG	129
#define GFXDAT	130
#define TREE struct tree

void	get_counts(), buildtree(), decompress(), put_square(), writeHRfile();

FILE	*fp;
char	f_name1[15], f_name2[15], cant_open[15] = { "Can't open %s\n" };
TREE	{	char code;			/* code value				*/
			int  count;			/* code count				*/
			TREE *parent;		/* pointer to parent		*/
			TREE *rite;			/* pointer to right child	*/
			TREE *left;			/* pointer to left child	*/
		}	huftree[511], *root;

/*=*=*=*=*=*=*/

main( argc, argv )
int argc; char **argv;
{
/*	check command line parameters  */

	if ( argc != 3 )
	{	puts( "usage: unhuf infile[/huf][:d] outfile[/hr][:d]" );
		exit(EOF);
	}

/*	build filenames from command line args  */

	addext( strcpy( f_name1, argv[1] ), "huf" );
	addext( strcpy( f_name2, argv[2] ), "hr" );

/*	null out huffman tree  */

	memset( huftree, 0, sizeof huftree );

/*	open /HUF file	*/

	if ( !( fp = fopen( f_name1, "r" ) ) )
	{	printf( cant_open, f_name1 );
		exit(EOF);
	}

	get_counts();
	buildtree();
	decompress();

	fclose( fp );
	writeHRfile( f_name2 );
}

/*=*=*=*=*=*=*/

void get_counts()
{
	static int	i;
	int			counts[256];

/*	read counts array from input file  */

	if ( fread( counts, sizeof(int), 256, fp ) != 256 )
	{	perror( "fread()" );
		exit(EOF);
	}

/*	assign code values and copy the counts
 *	to the first 256 huffman tree members  */

	for ( i = 0; i < 256; i++ )
	{	huftree[i].code = i;
		huftree[i].count = counts[i];
	}
}

/*=*=*=*=*=*=*/

void buildtree()
{
	static TREE		*ptr1, *ptr2, *temp, *limit;

	limit = huftree + 256;

	while ( TRUE )
	{
		temp = huftree;

		while ( temp->parent || !temp->count )
			++temp;
		ptr1 = temp++;

		while ( ( temp->parent || !temp->count ) && temp < limit )
			++temp;
		if ( ( ptr2 = temp ) == limit )
		{	root = ptr1;
			break;
		}

	/*	always keep lower count in ptr2  */

		if ( ptr1->count < ptr2->count )
		{	ptr2 = ptr1;
			ptr1 = temp;
		}

		while ( ++temp < limit )
			if ( !temp->parent && temp->count )
			{	if ( temp->count < ptr2->count )

		/*	if ptr1 >= ptr2 > new, then if ptr1 == ptr2 keep ptr1  */

				{	if ( ptr1->count > ptr2->count )
						ptr1 = ptr2;
					ptr2 = temp;
				}
				else if ( temp->count < ptr1->count )

			/*	if ptr1 > new > ptr2, put new in ptr1  */

					ptr1 = temp;
			}

		ptr1->parent = ptr2->parent = limit;
		limit->count = ptr1->count + ptr2->count;
		limit->rite = ptr1;
		limit->left = ptr2;
		++limit;
	}
}

/*=*=*=*=*=*=*/

void decompress()
{
	static TREE *ptr;
	static int	bytectr = 19200;

	gfx_cls();
	gfx_mode(1);

	while ( bytectr-- )
	{	ptr = root;

/*	starting at "root," step through tree, using direction bits from /HUF
 *	file, until end leaf (i.e., an element with no children) is reached,
 *	and send it's code for screen display  */

		while ( ptr->rite )
			if ( inbit() )
				ptr = ptr->left;
			else
				ptr = ptr->rite;

		put_square( ptr->code );
	}

	gfx_mode(0);
}
/*=*=*=*=*=*=*/

int inbit()
{
	static int	byte, mask = 0;
	int	retval;

	if ( !mask )
	{	if ( ( byte = getc( fp ) ) == EOF )
		{	perror( "getc()" );
			exit(EOF);
		}
		mask = 0x80;
	}
	retval = byte & mask;
	mask >>= 1;
	return retval;
}

/*=*=*=*=*=*=*/

void put_square( code )
int	code;
{
	static int	x = 0, y = 0, dat1, dat2;

	if ( !( x & 1 ) )

/*	if on left side, mask out low nibble of "code" to init upper data byte,
 *	and shift low nibble of "code" to high nibble to init lower data byte  */

	{	dat1 = code & 0xf0;
		dat2 = code << 4;
	}

	else

/*	if on right side, OR high nibble of "code" with lower nibble of upper
 *	byte, and OR low nibble of "code" with lower nibble of lower byte  */

	{	dat1 |= code >> 4;
		dat2 |= code & 0x0f;

/*	write combined left and right squares to gfx board RAM	*/

		outport( XREG, x >> 1 );
		outport( YREG, y );
		outport( GFXDAT, dat1 );
		outport( YREG, y + 1 );
		outport( GFXDAT, dat2 );
	}

/*	Bump "x" for next call.  If at end of line, set up for next line  */

	if ( ++x == 160 )
	{	x = 0;
		y += 2;
	}
}

/*=*=*=*=*=*=*/

void writeHRfile( filename )
char	*filename;
{
	if ( !( fp = fopen( filename, "w" ) ) )
	{	printf( cant_open, filename );
		exit(EOF);
	}
	if ( putimage( fp ) == EOF )
	{	perror( "putimage()" );
		exit(EOF);
	}
	fclose( fp );
}
