;***********************************************
;	huf_.asm -- new static Huffman
;***********************************************
			page	0, 128
.model small
.286
;include	amscls.inc
;$_init	GEN

extrn	_error:proc

NC		=	(200h - 2)
CBIT	=	9

NP		=	14
NT		=	19
PBIT	=	4
TBIT	=	5
;NPT	=	080h

CGROUP	group	TEXT
DGROUP	group	DATA, BSS

TEXT	segment	public byte 'CODE'
extrn	_fillbuf:near
extrn	getbits_:near
extrn	_init_getbits:near
extrn	init_putbits_:near
extrn	make_table_:near
extrn	make_tree_:near
extrn	_putbits:near
extrn	_putcode:near
TEXT	ends

DATA	segment	public word 'DATA'
DATA	ends

BSS		segment	public word 'DATA'
buf_			dd		1 dup (?)
buf_limit_		dw		1 dup (?)
blocksize_		dw		1 dup (?)
output_pos_		dd		1 dup (?)
cpos_			dw		1 dup (?)
output_mask_	db		1 dup (?)
BSS		ends

extrn	c_freq_:word
extrn	p_freq_:word
extrn	t_freq_:word
extrn	left_:word
extrn	right_:word
extrn	c_table_:word
extrn	c_code_:word
extrn	pt_table_:word
extrn	pt_code_:word
extrn	c_len_:byte
extrn	pt_len_:byte

public	buf_
public	buf_limit_

extrn	bitbuf_:word
extrn	_unpackable:word

assume	cs:CGROUP, ds:DGROUP

TEXT	segment	public byte 'CODE'
;
;	static void count_t_freq(void)
;

;public	count_t_freq_
count_t_freq_	proc	near
	push	cx
	push	si
	push	di
	cld
	push	ds
	pop		es
	mov		cx, NT
	mov		di, offset DGROUP:t_freq_
	xor		ax, ax
	rep		stosw
	mov		cx, NC
	mov		di, offset DGROUP:c_len_[NC - 1]
	std
	repe	scasb
	cld
	inc		di
	mov		si, di
	mov		di, offset DGROUP:c_len_
$_100:
		mov		bl, [di]
		inc		di
;		$_if <or bl, bl>, Z
OR BL, BL
jZ $_103
jmp $_102else
$_103:
			mov		cx, -1
			repe	scasb
			dec		di
			not		cx
;			$_switch
;			$_case <cmp cx, 2>, BE
			cmp cx, 2
			jnbe nswitch1
				add		t_freq_[0 * 2], cx
;				$_break
				jmp short endswitch
;			$_case <cmp cx, 19>, BE
nswitch1:		cmp cx, 19
			jnbe nswitch2

;				$_if , E

jE $_105
jmp $_104
$_105:
					inc		t_freq_[0 * 2]
;				$_endif
$_104:
				inc		t_freq_[1 * 2]
;				$_break
				Jmp Short EndSwitch
nswitch2:
;			$_default
				inc		t_freq_[2 * 2]
;			$_endswitch
endSwitch:
		Jmp $_102
$_102else:
;		$_else
			xor		bh, bh
			shl		bx, 1
			inc		t_freq_[bx + 2 * 2]
;		$_endif
$_102:
;	$_until <cmp di, si>, A
;	$_until <cmp di, si>, A
CMP DI, SI
jA $_101
jmp $_100
$_101:
	pop		di
	pop		si
	pop		cx
	ret
count_t_freq_	endp

;
;	static void write_pt_len(short n, short nbit, short i_special)
;

;public	write_pt_len_
write_pt_len_	proc	near
	push	cx
	push	si
	push	di

	push	cx					; i_special
	push	bx					; nbit
	mov		si, offset DGROUP:pt_len_
	lea		di, [si - 1]
	add		di, ax
	mov		cx, ax
	inc		cx
	xor		al, al
	std
	repe	scasb
	cld
	mov		bx, cx
	pop		ax					; nbit
	call	_putbits
	inc		di
	pop		cx					; i_special
	add		cx, si
$_106:
		xor		bh, bh
		mov		bl, [si]
		inc		si
;		$_if <cmp bl, 6>, BE
		cmp bl,6
		jnbe $108els
;CMP BL, 6
;jbe $_109
;jmp $108els:
;$_109:
			mov		al, 3
			Jmp $_108
;		$_else
$108els:		mov		ax, bx
			sub		ax, 3
			mov		bx, 0fffeh
;		$_endif
$_108:
		call	_putbits
;		$_if <cmp si, cx>, E
CMP SI, CX
jE $_111
jmp $_110
$_111:
;			$_while <cmp si, offset DGROUP:pt_len_ + 6>, B, AND
;			$_c     <cmp byte ptr [si], 0>, E
;				inc		si
;			$_enddo
$WhlLop:		cmp si, offset DGROUP:pt_len_ + 6
			jnb $EndWhl
			cmp byte ptr [si], 0
			jne $EndWhl
				inc si
				Jmp $WhlLop
$EndWhl:


			mov		al, 2
			mov		bx, si
			sub		bx, offset DGROUP:pt_len_ + 3;
			call	_putbits
;		$_endif
$_110:
;	$_until <cmp si, di>, A
;	$_until <cmp si, di>, A
CMP SI, DI
jA $_107
jmp $_106
$_107:

	pop		di
	pop		si
	pop		cx
	ret
write_pt_len_	endp

;
;	static void write_c_len(void)
;

;public	write_c_len_
write_c_len_	proc	near
	push	cx
	push	si
	push	di
	mov		di, offset DGROUP:c_len_ + NC - 1
	mov		cx, NC + 1
	xor		al, al
	std
	repe	scasb
	cld
	inc		di
	mov		si, di
	mov		di, offset DGROUP:c_len_
	mov		bx, cx
	mov		al, CBIT
	call	_putbits
$_112:
		mov		bl, [di]
		inc		di
;		$_if <or bl, bl>, Z
OR BL, BL
jZ $_115
jmp $_114e
$_115:
			xor		al, al
			mov		cx, -1
			repe	scasb
			dec		di
			not		cx
;			$_switch
;			$_case <cmp cx, 2>, BE
			cmp cx,2
			jnbe _nsw1
$_116:
					mov		al, pt_len_[0]
					mov		bx, pt_code_[0 * 2]
					call	_putcode
;				$_until <LOOP>
;				$_until <LOOP>
LOOP $_116
;				$_break
				jmp esw
;			$_case <cmp cx, 19>, BE
_nsw1:			cmp cx, 19
			jnbe _nsw2
;				$_if , E

jE $_119
jmp $_118
$_119:
					mov		al, pt_len_[0]
					mov		bx, pt_code_[0 * 2]
					call	_putcode
					dec		cx
;				$_endif
$_118:
				mov		al, pt_len_[1]
				mov		bx, pt_code_[1 * 2]
				call	_putcode
				mov		al, 4
				mov		bx, cx
				sub		bx, 3
				call	_putbits
;				$_break
				jmp esw
;			$_default
_nsw2:
				mov		al, pt_len_[2]
				mov		bx, pt_code_[2 * 2]
				call	_putcode
				mov		al, CBIT
				mov		bx, cx
				sub		bx, 20
				call	_putbits
esw:;			$_endswitch
		Jmp $_114
;		$_else
$_114e:
			xor		bh, bh
			mov		al, pt_len_[bx + 2]
			shl		bx, 1
			mov		bx, pt_code_[bx + 4]
			call	_putcode
;		$_endif
$_114:
;	$_until <cmp di, si>, A
;	$_until <cmp di, si>, A
CMP DI, SI
jA $_113
jmp $_112
$_113:
	pop		di
	pop		si
	pop		cx
	ret
write_c_len_	endp

;
;	static void send_block(void)
;

;public	send_block_
send_block_	proc	near
	push	cx
	push	dx
	push	si
	push	di
	push	bp

	mov		ax, NC
	mov		bx, offset DGROUP:c_freq_
	mov		cx, offset DGROUP:c_len_
	mov		dx, offset DGROUP:c_code_
	call	make_tree_
	mov		bx, ax
	mov		cx, ax
	shl		bx, 1
	mov		bx, c_freq_[bx]
	mov		al, 16
	call	_putbits
;	$_if <cmp cx, NC>, AE
CMP CX, NC
jAE $_121
jmp $_120e
$_121:
		call	count_t_freq_
		mov		ax, NT
		mov		bx, offset DGROUP:t_freq_
		mov		cx, offset DGROUP:pt_len_
		mov		dx, offset DGROUP:pt_code_
		call	make_tree_
;		$_if <cmp ax, NT>, AE
CMP AX, NT
jAE $_123
jmp $_122e
$_123:
			mov		ax, NT
			mov		bx, TBIT
			mov		cx, 3
			call	write_pt_len_
			Jmp $_122
$_122e:;		$_else
if 1
			mov		bx, ax
			mov		al, TBIT * 2
			call	_putbits
else
			mov		cx, ax
			xor		bx, bx
			mov		al, TBIT
			call	_putbits
			mov		bx, cx
			mov		al, TBIT
			call	_putbits
endif
;		$_endif
$_122:
		call	write_c_len_
		Jmp $_120
$_120e:	;$_else
if 1
		xor		bx, bx
		mov		al, CBIT + TBIT
		call	_putbits
		mov		bx, cx
		mov		al, CBIT + TBIT
		call	_putbits
else
		xor		bx, bx
		mov		al, TBIT
		call	_putbits
		xor		bx, bx
		mov		al, TBIT
		call	_putbits
		xor		bx, bx
		mov		al, CBIT
		call	_putbits
		mov		bx, cx
		mov		al, CBIT
		call	_putbits
endif
;	$_endif
$_120:
	mov		ax, NP
	mov		bx, offset DGROUP:p_freq_
	mov		cx, offset DGROUP:pt_len_
	mov		dx, offset DGROUP:pt_code_
	call	make_tree_
;	$_if <cmp ax, NP>, AE
CMP AX, NP
jAE $_125
jmp $_124e
$_125:
		mov		ax, NP
		mov		bx, PBIT
		mov		cx, -1
		call	write_pt_len_
		Jmp $_124
$_124e:;	$_else
if 1
		mov		bx, ax
		mov		al, PBIT * 2
		call	_putbits
else
		mov		cx, ax
		mov		al, PBIT
		xor		bx, bx
		call	_putbits
		mov		al, PBIT
		mov		bx, cx
		call	_putbits
endif
;	$_endif
$_124:
	les		si, buf_
	xor		cx, cx
	mov		bp, word ptr output_pos_
$_126:
;		$_if <and cl, 07h>, Z
AND CL, 07H
jZ $_129
jmp $_128
$_129:
			lods	byte ptr es:[si]
			mov		ch, al
;		$_endif
$_128:
		xor		bh, bh
		lods	byte ptr es:[si]
		mov		bl, al
		add		ch, 80h
		rcl		bh, 1

;	static void encode_c(short c)
		mov		al, c_len_[bx]
		shl		bx, 1
		mov		bx, c_code_[bx]
		call	_putcode
;
;		$_if <shl ch, 1>, NC
SHL CH, 1
jNC $_131
jmp $_130
$_131:
			lods	word ptr es:[si]

;	static void encode_p(ushort p)
			mov		dx, ax
			and		ax, 0000fh
			mov		di, ax
			mov		al, pt_len_[di]
			shl		di, 1
			mov		bx, pt_code_[di]
			call	_putcode
			shr		di, 1
;			$_if <dec di>, G
DEC DI
jG $_133
jmp $_132
$_133:
				mov		ax, di
				mov		bx, dx
				and		bl, 0f0h
				call	_putcode
;			$_endif
$_132:
;

;		$_endif
$_130:
		inc		cx
;	$_until <cmp si, bp>, AE
;	$_until <cmp si, bp>, AE
CMP SI, BP
jAE $_127
jmp $_126
$_127:
	push	ds
	pop		es
	xor		ax, ax
	mov		cx, NC
	mov		di, offset DGROUP:c_freq_
	rep		stosw
	mov		cx, NP
	mov		di, offset DGROUP:p_freq_
	rep		stosw

	pop		bp
	pop		di
	pop		si
	pop		dx
	pop		cx
	ret
send_block_	endp

;
;	void output_st1(ushort c, ushort p)
;

public	output_st1_
output_st1_	proc	near
	push	di
	les		di, output_pos_
;	$_if <ror output_mask_, 1>, C
ROR OUTPUT_MASK_, 1
jC $_135
jmp $_134
$_135:
;		$_if <cmp di, buf_limit_>, AE
CMP DI, BUF_LIMIT_
jAE $_137
jmp $_136
$_137:
			push	ax
			push	bx
			push	es
			call	send_block_
			pop		es
			pop		bx
			pop		ax
			cmp		_unpackable, 0
			jne		os1_end
			xor		di, di
;		$_endif
$_136:
		mov		cpos_, di
		mov		byte ptr es:[di], 0
		inc		di
;	$_endif
$_134:
	stosb
	xchg	bx, ax
	shl		bx, 1
	inc		c_freq_[bx]
;	$_if <shr bh, 1>, NZ
SHR BH, 1
jNZ $_139
jmp $_138
$_139:

		xor		bx, bx
		shl		ax, 1
		jz		keta1
		shl		ax, 1
		shl		ax, 1
		mov		bx, 13 + 1
	keta0:
		dec		bx
		shl		ax, 1
		jc		keta1
		dec		bx
		shl		ax, 1
		jc		keta1
		dec		bx
		shl		ax, 1
		jc		keta1
		dec		bx
		shl		ax, 1
		jc		keta1
		dec		bx
		shl		ax, 1
		jnc		keta0
	keta1:

		or		ax, bx					; l߂̈ʒu + 
		stosw

		shl		bx, 1
		inc		p_freq_[bx]

		mov		al, output_mask_
		mov		bx, cpos_
		or		es:[bx], al
;	$_endif
$_138:
	mov		word ptr output_pos_, di
os1_end:
	pop		di
	ret
output_st1_	endp

if 0
;
;	void far *alloc_buf(void)
;

public	alloc_buf_
alloc_buf_	proc	near
	mov		bx, 0ffffh
	mov		ah, 48h
	int		21h
;	$_if <cmp bx, 256>, AE
CMP BX, 256
jAE $_141
jmp $_140
$_141:
		mov		ax, 1024
;		$_if <cmp bx, ax>, B
CMP BX, AX
jB $_143
jmp $_142
$_143:
			mov		ax, bx
;		$_endif
$_142:
		mov		bx, ax
		shl		ax, 1
		shl		ax, 1
		shl		ax, 1
		shl		ax, 1
		sub		ax, 24
		mov		buf_limit_, ax
		mov		ah, 48h
		int		21h
		mov		bx, ax
	$_else
		xor		bx, bx
;	$_endif
$_140:
	xor		ax, ax
	mov		word ptr buf_ + 2, bx
	mov		word ptr buf_, ax
	ret
alloc_buf_	endp
endif

;
;	void encode_start_st1(void)
;

public	encode_start_st1_
encode_start_st1_	proc	near
	push	cx
	push	di
	push	ds
	pop		es
	xor		ax, ax
	mov		cx, NC
	mov		di, offset DGROUP:c_freq_
	rep		stosw
	mov		cx, NP
	mov		di, offset DGROUP:p_freq_
	rep		stosw
	les		bx, buf_
	mov		word ptr output_pos_ + 2, es
	mov		word ptr output_pos_, bx
	mov		byte ptr es:[bx], 0
	mov		output_mask_, 01h
	call	init_putbits_
	pop		di
	pop		cx
	ret
encode_start_st1_	endp

;
;	void encode_end_st1(void)
;

public	encode_end_st1_
encode_end_st1_	proc	near
;	$_if <cmp _unpackable, 0>, E
CMP _unpackable, 0
jE $_145
jmp $_144
$_145:
		call	send_block_
		mov		ax, 7
		xor		bx, bx
		call	_putcode
;	$_endif
$_144:
	ret
encode_end_st1_	endp

;	/***** decoding *****/

;
;	static void read_pt_len(short nn, short nbit, short i_special)
;

;public	read_pt_len_
read_pt_len_	proc	near
	push	cx
	push	dx
	push	si
	push	di

	push	ax
	mov		si, ax
	mov		dx, bx
	mov		ax, bx
	call	getbits_
	cmp		ax, si
	ja		tbl_error

	mov		di, offset DGROUP:pt_len_
;	$_if <or ax, ax>, Z
	or ax,ax
	jne $_146e
;OR AX, AX
;jZ $_147
;jmp $_146e
;$_147:
		mov		di, offset DGROUP:pt_len_
		pop		cx
		rep		stosb
		mov		ax, dx
		call	getbits_
		mov		cx, 256
		mov		di, offset DGROUP:pt_table_
		rep		stosw
		Jmp short $_146
$_146e:;	$_else
		mov		dx, cx			; dl = i_special
		add		dx, di
		mov		si, di
		add		si, ax			; ax = n
$_148:
			mov		ax, 3
			call	getbits_
;			$_if <cmp al, 7>, E
			cmp al,7
			jne $_150
;CMP AL, 7
;jE $_151
;jmp $_150
;$_151:
				mov		bx, bitbuf_
;				$_while <shl bx, 1>, C
;					inc		ax
;				$_enddo
whll:				shl bx, 1
				jnc endwhl1
					inc ax
					Jmp short whll
endwhl1:

				push	ax
				sub		ax, 6
				call	_fillbuf
				pop		ax
;			$_endif
$_150:
			stosb
;			$_if <cmp di, dx>, E
CMP DI, DX
jE $_153
jmp $_152
$_153:
				mov		ax, 2
				call	getbits_
				mov		cx, ax
				xor		al, al
				rep		stosb
;			$_endif
$_152:
;		$_until <cmp di, si>, AE
;		$_until <cmp di, si>, AE
CMP DI, SI
jAE $_149
jmp $_148
$_149:
		pop		cx						; nn
		mov		si, cx
		add		cx, offset DGROUP:pt_len_
		sub		cx, di
		jb		tbl_error
		xor		al, al
		rep		stosb
		mov		ax, si
		mov		bx, offset DGROUP:pt_len_
		mov		cx, 8
		mov		dx, offset DGROUP:pt_table_
		call	make_table_
;	$_endif
$_146:

	pop		di
	pop		si
	pop		dx
	pop		cx
	ret
read_pt_len_	endp

extrn	_BROKENARC:byte

tbl_error	proc	near
	mov		ax, offset DGROUP:_BROKENARC
	xor		bx, bx
	jmp		_error
tbl_error	endp

;
;	static void read_c_len(void)
;

;public	read_c_len_
read_c_len_	proc	near
	push	cx
	push	dx
	push	di

	mov		ax, CBIT
	call	getbits_
	cmp		ax, NC
	ja		tbl_error

	mov		di, offset DGROUP:c_len_
;	$_if <or ax, ax>, Z
OR AX, AX
jZ $_155
jmp $_154e
$_155:
		mov		cx, NC
		rep		stosb
		mov		ax, CBIT
		call	getbits_
		mov		cx, 4096
		mov		di, offset DGROUP:c_table_
		rep		stosw
		Jmp $_154
$_154e:;	$_else
		mov		dx, di
		add		dx, ax			; ax = n
$_156:
			mov		ax, bitbuf_
			mov		bl, ah
			xor		bh, bh
			shl		bx, 1
			mov		bx, pt_table_[bx]
whl3:;			$_while <cmp bx, NT>, AE
			cmp bx, NT
			Jnae EndWhl3
;				$_if <shl al, 1>, C
				shl al, 1
				Jnc $_158e
;SHL AL, 1
;jC $_159
;jmp $_158
;$_159:
					mov		bx, right_[bx]
;				$_else
				Jmp short $_158
$_158e:;
					mov		bx, left_[bx]
;				$_endif
$_158:
			Jmp short Whl3
EndWhl3:;			$_enddo
			push	bx
			mov		al, pt_len_[bx]
			call	_fillbuf
			pop		ax
;			$_if <sub ax, 2>, BE
			sub ax, 2
			jnbe $_160e
;SUB AX, 2
;jBE $_161
;jmp $_160
;$_161:
;				$_if , Z
			Jnz $_162e
;jZ $_163
;jmp $_162e
;$_163:
					mov		ax, CBIT
					call	getbits_
					add		ax, 20
					mov		cx, ax
				Jmp short $_162
$_162e:;				$_else
;					$_if <inc ax>, Z
INC AX
jZ $_165
jmp short $_164e
$_165:
						mov		ax, 4
						call	getbits_
						add		ax, 3
						mov		cx, ax
						Jmp short $_164
$_164e:;					$_else
						mov		cx, 1
;					$_endif
$_164:
;				$_endif
$_162:
				xor		al, al
				rep		stosb
				Jmp short $_160
$_160e:;			$_else
				stosb
;			$_endif
$_160:
;		$_until <cmp di, dx>, AE
;		$_until <cmp di, dx>, AE
CMP DI, DX
jAE $_157
jmp $_156
$_157:
		mov		cx, offset DGROUP:c_len_ + NC
		sub		cx, di
;		jb		tbl_error
		Jnb	NoTblErr
		Jmp tbl_error
NoTblErr:	xor		al, al
		rep		stosb
		mov		ax, NC
		mov		bx, offset DGROUP:c_len_
		mov		cx, 12
		mov		dx, offset DGROUP:c_table_
		call	make_table_
;	$_endif
$_154:
	pop		di
	pop		dx
	pop		cx
	ret
read_c_len_	endp

;
;	ushort decode_c_st1(void)
;

decode_c	proc	near
;	not entry here
decode_c_st1_2:
	push	ax
	push	bx
	push	cx
	mov		ax, 16
	call	getbits_
	dec		ax
	mov		blocksize_, ax
	mov		ax, NT
	mov		bx, TBIT
	mov		cx, 3
	call	read_pt_len_
	call	read_c_len_
	mov		ax, NP
	mov		bx, PBIT
	mov		cx, -1
	call	read_pt_len_
	pop		cx
	pop		bx
	pop		ax
	jmp		decode_c_st1_3
;
;	entry here
;
public	decode_c_st1_
decode_c_st1_:
	push	cx
	sub		blocksize_, 1
	jc		decode_c_st1_2
decode_c_st1_3:
	mov		bx, bitbuf_
	mov		cl, 4
	shr		bx, cl
	shl		bx, 1
	mov		bx, c_table_[bx]
;	$_if	<cmp bx, NC>, B
CMP BX, NC
jB $_167
jmp $_166
$_167:
decode_c_st1_1:
		push	bx
		mov		al, c_len_[bx]
		call	_fillbuf
		pop		ax
		pop		cx
		ret
;	$_endif
$_166:
	mov		ax, bitbuf_
	shl		al, cl
$_168:
;		$_if <shl al, 1>, C
		shl al,1
		jnc $_170e
;SHL AL, 1
;jC $_171
;jmp $_170
;$_171:
			mov		bx, right_[bx]
			Jmp short $_170
$_170e:;	$_else
			mov		bx, left_[bx]
;		$_endif
$_170:
;	$_until <cmp bx, NC>, B
;	$_until <cmp bx, NC>, B
CMP BX, NC
jB $_169
jmp $_168
$_169:
	jmp		decode_c_st1_1
decode_c	endp

;
;	ushort decode_p_st1(void)
;

public	decode_p_st1_
decode_p_st1_	proc	near
	push	cx
	xor		bh, bh
	mov		bl, byte ptr bitbuf_ + 1
	shl		bx, 1
	mov		bx, pt_table_[bx]
;	$_if	<cmp bx, NP>, B
CMP BX, NP
jB $_173
jmp $_172
$_173:
decode_p_st1_1:
		push	bx
		mov		al, pt_len_[bx]
		call	_fillbuf
		pop		ax
;		$_if <or ax, ax>, NZ
OR AX, AX
jNZ $_175
jmp $_174
$_175:
			dec		ax
			mov		cx, ax
			call	getbits_
			mov		bx, 1
			shl		bx, cl
			or		ax, bx
;		$_endif
$_174:
		pop		cx
		ret
;	$_endif
$_172:
	mov		al, byte ptr bitbuf_
$_176:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_179
jmp $_178e
$_179:
			mov		bx, right_[bx]
			Jmp short $_178
$_178e:;		$_else
			mov		bx, left_[bx]
;		$_endif
$_178:
;	$_until <cmp bx, NP>, B
;	$_until <cmp bx, NP>, B
CMP BX, NP
jB $_177
jmp $_176
$_177:
	jmp		decode_p_st1_1
decode_p_st1_	endp

;
;	void decode_start_st1(void)
;

public	decode_start_st1_
decode_start_st1_	proc	near
	mov		blocksize_, 0
	jmp		_init_getbits
decode_start_st1_	endp

TEXT	ends
		end
