{----------------------------------------------------------------------*
 *                                                                      
 *	W L H A . P A S -       Dipl. Ing. Bernd Herd
 *				Niederstr. 36
 *				64285 Darmstadt
 *				Germany
 *				Tel: 06151 / 664717
 *				Fax: 06151 / 664740
 *	(C) 1994-95 Bernd Herd
 *
 * WLHA.DLL Dynamic Link Library for Microsoft Windows 3.1
 * makes it possible to extract Files from and add Files to LHA-Archives
 * without using LHA.EXE
 *
 * This is the Interface-Unit for pascal-Programs.
 *
  ---------------------------------------------------------------}

unit WLha;

interface

uses OWindows, WinTypes, WinProcs, Win31, WinAPI, WinDOs;


type MFILE = THandle;                   { This is our special Kind of File I/O-Handle supported by WLHA,
                                          it's basically a GlobalAlloc-Handle }

{ ----------- Options ------------------------------------------------ }

  { ----------- Expand-Options --------------------------------- }
  const  LHA_OVERWRITE=    $0001;        {  Codes for Options-Parameter }
  const  LHA_ATTRIB=       $0010;        {  Set/Get File Attributes }

  { ----------- Append-Options --------------------------------- }
  const  LHA_CREATEARCHIV=  $0100;       {  Generate a New Archiv, even if there is one already }
  const  LHA_SHORTNAMES=    $0200;	{  Filenames in Archiv without Path }

{ ----------- Callback Routine Messages ------------------------------ }
const  LHM_PEEK=           1;             {  Nothing special }
const  LHM_NEXTFILE=       2;             {  Start processing next File }

{ ------------- Error Codes ------------------------------------------- }
{  The Errorcode are selected to be between 2000 and 2100, so it's easier }
{  to store the error text in an Resource File }

type LHERR = Integer;                             { Return Type definition }

const  LHE_OK=                       0;           {  No Error }
const  LHE_ARCHIVNOTFOUND=        2020;           {  Archiv File not Found }
const  LHE_BROKEN=                2021;           {  Broken Archiv }
const  LHE_METHOD=                2022;           {  Compression Method not supported }
const  LHE_WRITE=                 2023;           {  Error creating/writing File }
const  LHE_CRC=                   2024;           {  CRC error }
const  LHE_CALLBACK=              2025;           {  Callbackroutine returned LHAN_STOP }
const  LHE_INSTANCE=              2026;           {  Instanz-Handling-Fehler }
const  LHE_INFILENOTFOUND=        2027;           {  Input File not found }
const  LHE_STOPPED=               2028;           {  Stopped by Callbac-Routine }

{ ------------- Callback-Notification-Codes ----- }
const  LHN_OK=                    0;              {  Nothing special }
{ #define LHN_IGNOREFILE                 1              // Used with LHAM_NEXTFILE : Irgnore this File }
const  LHN_STOP=                  2;              {  Used with LHAM_PEEK     : Stop Decompression of Archive immediatly }


type datetimerecord = record
        time : Word;
        date : Word;
        End;

     LPLHHEAD = ^LHHEAD;
     LHHEAD = record
	headersize  : Integer;
        method      : array[0..5] of char;
        PackedSize  : LongInt;                    { Packed FIle Size }
        Skip        : LongInt;
        OriginalSize: LongInt;                    { Original File Size }

        dostime     : DateTimeRecord;             { Parameter like GetFTime }

	utc         : LongInt;                    { Another Time Format... }
        attr        : Integer;                    { File Attribute (Archiv,System,Hidden...) }
        level       : Integer;                    { Header Level }

        filecrc     : Word;                       { File CRC }
        headcrc     : Word;                       { Header CRC (Method depends on level) }

        dos         : Integer;

        pathname    : PChar;
        filename    : PChar;                      { Filename, when extracting! }

        dirnlen     : Integer;                    { Directory name Length }
        filenlen    : Integer;                    { File Name Length }

        info        : Integer;
        currentpos  : LongInt;                    { Position of currently used Header in the File }

        crcpos      : PChar;
        End;



{ Typedefintion for Callback cannot be adopted to Pascal :-( }

{ typedef LHERR (CALLBACK* LHCALLBACK)(int, LPLHHEAD);      Type declaration Callback-Function }
type LHCALLBACK = Pointer;


{ ----------- High-Level-Routines ----------------------------- }

function LHExpand( ArchivName : PChar;          {  Extract Files from Archiv }
		   PathName   : PChar;
		   Wildcards  : PChar;		{  Wildcards (i.e. "*.TXT") or NULL }
		   Options    : Integer ) : LHERR; far;

function LHAppend( ArchivName : PChar;          {  Append File or Create Archiv }
		   PathName   : PChar;
		   Options    : Integer ) : LHERR; far;


function LHInit(   Instance   : THandle) : LHERR; far; {  Initialize for next Archiv Operation(s) }
function LHEnd (   Instance   : THandle) : LHERR; far; {  End of Archiv Operation(s) }

procedure LHMessage( eId : LHERR ); far;        {  Show Error Message Box }

function LHSetCallback(   TheCallback : LHCALLBACK) : LHERR; far; {  Set Callback-Routine }
function LHDefCallbck( msg : Integer; p : LPLHHEAD) : LHERR; far; {  Default-Callback-Routine }

procedure LHErrMsgBox( eId : LHERR ); far;        {  Show Error Message Box with Description }


{ ----------- Medium-Level-Routines --------------------------- }

function LHAppendNext(  marc : MFILE;                {  File Handle Archiv }
			minp : MFILE;                {  File Handle Input File }
			FileName : PChar;            {  FileName Inside Archiv }
			Options  : Integer): LHERR; far; {  Archiving Options }


function LHExpandNext(  marc    : MFILE;                 {  File Handle of input-Archiv }
                        Wildcards  : PChar;		{  Wildcards (i.e. "*.TXT") or NULL }
			Options : Integer) : LHERR; far; {  Decompression Options }



implementation

function LHExpand( ArchivName : PChar;          {  Extract Files from Archiv }
		   PathName   : PChar;
		   Wildcards  : PChar;		{  Wildcards (i.e. "*.TXT") or NULL }
		   Options    : Integer ) : LHERR; external 'WLHA';

function LHAppend( ArchivName : PChar;          {  Append File or Create Archiv }
		   PathName   : PChar;
		   Options    : Integer ) : LHERR; external 'WLHA';


function LHInit(   Instance   : THandle) : LHERR; external 'WLHA'; {  Initialize for next Archiv Operation(s) }
function LHEnd (   Instance   : THandle) : LHERR; external 'WLHA'; {  End of Archiv Operation(s) }

procedure LHMessage( eId : LHERR ); external 'WLHA';        {  Show Error Message Box }

function LHSetCallback(   TheCallback : LHCALLBACK) : LHERR; external 'WLHA'; {  Set Callback-Routine }
function LHDefCallbck( msg : Integer; p : LPLHHEAD) : LHERR; external 'WLHA'; {  Default-Callback-Routine }

procedure LHErrMsgBox( eId : LHERR ); external 'WLHA';        {  Show Error Message Box with Description }


{ ----------- Medium-Level-Routines --------------------------- }

function LHAppendNext(  marc : MFILE;                {  File Handle Archiv }
                        minp : MFILE;                {  File Handle Input File }
                        FileName : PChar;            {  FileName Inside Archiv }
                        Options  : Integer): LHERR; external 'WLHA'; {  Archiving Options }


function LHExpandNext(  marc     : MFILE;               {  File Handle of input-Archiv }
			Wildcards: PChar;		{  Wildcards (i.e. "*.TXT") or NULL }
			Options  : Integer) : LHERR; external 'WLHA'; {  Decompression Options }

End.
