/* LZDIB.CPP ---------------------------------------------------*
 * L Z D I B --- Implementation OWL 2.x - Support for          	*
 *		 LHA-Compressed Bitmaps				*
 * (C) 1995 Dipl. Ing. Bernd herd Dipl. Ing. Herald Nuding	*
 * Heidelberger Landstr. 316 D-64297 Darmstadt, 0049-6151-591216*
 *--------------------------------------------------------------*/
#define STRICT

#include <owl\owlpch.h>
#pragma hdrstop

#include "lzdib.h"


/* IMPLEMENTS:
   TLZDib		derived from TDib
   TLZBitmap                         TBitmap
*/


/* -------------------------------------------------------------*
 * Constructors for TLZDib					*
 *--------------------------------------------------------------*/

/* TLZDib is a Class derived from TDib that brings with it new construtors:

   TLZDib(HINSTANCE instance, TResID resID, const char *NameInArchiv=NULL);

      A TLZDib-Object constructed with this constructor will load
      a LZH-Compressed BMP-File from the Archiv.

   TLZDib(LPLZHEAD SourcePtr, const char *NameInArchiv=NULL);

      A TLZDib-Object constructed with this constructor will decompress
      the memory-Block "SourcePtr" and create a TDib-Object for it
*/




// ---- TLZDib from Resource -----------------------------

TLZDib::TLZDib(HINSTANCE Instance, TResId resID, const char *NameInArchiv)
	:TDib( GimmeADibHandle( Instance, resID, NameInArchiv ), AutoDelete )
//	:TDib ( LoadLZHResource(instance, resID, NameInArchiv, sizeof(BITMAPFILEHEADER) ), AutoDelete )
{ // that's all - Folks!
}



// ---- TLZDib from Memory Block -------------------------

TLZDib::TLZDib(LPLZHEAD SourcePtr, const char *NameInArchiv)
	:TDib ( DecompressLZH(SourcePtr, NameInArchiv, sizeof(BITMAPFILEHEADER) ), AutoDelete )
{ // that's all - Folks!
}



// ---- Get a Handle, depending if Archiv is found -------
HGLOBAL TLZDib::GimmeADibHandle(HINSTANCE Instance, TResId resID, const char *NameInArchiv)
{ HGLOBAL returnvalue;

  // ---- First test if we have a LZH-Archiv ---------------
  returnvalue = LoadLZHResource(Instance, resID, NameInArchiv, sizeof(BITMAPFILEHEADER) );

  // ---- If this did not work, try the normal BITMAP type--
  if (!returnvalue) {
    HRSRC   hfnd;
    HGLOBAL hres,   hdest;
    LPSTR   source,  dest;
    DWORD   Size;

    if ( NULL != (hfnd  = FindResource( Instance, resID , RT_BITMAP )) &&
	 0L   != (Size  = SizeofResource( Instance, hfnd)) &&
	 NULL != (hdest = GlobalAlloc( GHND, Size ) ) &&
	 NULL != (hres  = ::LoadResource( Instance, hfnd )) &&
	 NULL != (source= (LPSTR) LockResource( hres )) &&
	 NULL != (dest  = (LPSTR) GlobalLock( hdest )) ) {

	 hmemcpy(dest, source, Size);

	 GlobalUnlock(hdest);
	 UnlockResource(hres);
	 returnvalue = hdest;
    }
  }

  return returnvalue;
}






/* -------------------------------------------------------------*
 * Constructors for TLZBitmap					*
 *--------------------------------------------------------------*/

/* TLZBitmap is a Class derived from TBitmap that brings with it new construtors:

   TLZBitmap(HINSTANCE instance, TResID resID, const char *NameInArchiv=NULL);

      A TLZBitmap-Object constructed with this constructor will load
      a LZH-Compressed BMP-File from the Archiv.

   TLZBitmap(LPLZHEAD SourcePtr, const char *NameInArchiv=NULL);

      A TLZBitmap-Object constructed with this constructor will decompress
      the memory-Block "SourcePtr" and create a TBitmap-Object for it
*/




// ---- TLZBitmap from Resource -----------------------------

TLZBitmap::TLZBitmap(HINSTANCE Instance, TResId resID, const char *NameInArchiv)
	:TBitmap( GimmeABitmapHandle( Instance, resID, NameInArchiv ), AutoDelete )
//	:TBitmap ( LoadLZHResource(instance, resID, NameInArchiv, sizeof(BITMAPFILEHEADER) ), AutoDelete )
{ // that's all - Folks!
}



// ---- TLZBitmap from Memory Block -------------------------

TLZBitmap::TLZBitmap(LPLZHEAD SourcePtr, const char *NameInArchiv)
	:TBitmap ( TLZDib(SourcePtr, NameInArchiv) )
{ // that's all - Folks!
}



// ---- Get a Handle, depending if Archiv is found -------
HBITMAP TLZBitmap::GimmeABitmapHandle(HINSTANCE Instance, TResId resID, const char *NameInArchiv)
{ HBITMAP returnvalue;

  // ---- First test if we have a LZH-Archiv ---------------
  returnvalue = LoadLZHBitmap(Instance, resID, NameInArchiv );

  // ---- If this did not work, try the normal BITMAP type--
  if (!returnvalue)
    returnvalue = ::LoadBitmap( Instance, resID);

  return returnvalue;
}






