

#include <windows.h>
#include <stdio.h>
#include <string.h>
#ifdef __BORLANDC__
# include <alloc.h>
#else
# include <malloc.h>
#endif

#if !defined(__BORLANDC__) && defined(WIN32)
# define _export
#endif


#include "lzapi.h"		   // Needed for any Program that uses LZAPI

static int wdth=0, run=0;

int FAR PASCAL _export ExampleCallback(int msg, LPLACTL Ctl)
{ switch (msg) {
    case LAM_NEXTFILE:     printf("\nFile: %-20s ", Ctl->lpstrProcessedFile);
			   wdth = 0;
			   break;	

    case LAM_MAPNAME:	   if (!lstrcmpi(Ctl->lpstrProcessedFile, "WIN.INI"))
				lstrcpy ((LPSTR) Ctl->lpstrProcessedFile, "EIEIEI.EIE");
			   break;

    case LAM_PERCENTOFFILE: {
		    int nwdth = Ctl->uPercentOfFile * 40 / 100,
			diff  = nwdth - wdth;
			wdth = nwdth;

		    while (diff--)
		       printf("o");
		    break;
/*    case LAM_PEEK:  printf("%c\x8", "-\|/-\|/"[(run++)%8]);
		    break;*/
    }
  }
  return 0;
}


main()
{ LACTL    Ctl;			   // LZAPI Control-Structure.
  char     TempDir[130],	   // File-Name for a File in the Temp Directory
	   TempFile[130],
	   WindowsDirectory[50];   // Directory-Name of the Windows-Directory with the INI-Files
  LAERR    err;			   // Errorcode Return-Variable from LZAPI-Function Call
  DWORD	   StartTime;

  // ------ Increase Handle-Usability for TEST-Purposes ----
/* { int DummyCount;
   OFSTRUCT dummy;
   SetHandleCount(50);
   for (DummyCount=0; DummyCount<40; ++DummyCount)
	_lopen("C:\\AUTOEXEC.BAT", OF_READ | OF_SHARE_DENY_NONE);
 } */

  // ------ LACTL-Size -------------------------------------
  printf("sizeof(LACTL) = %d\n", sizeof(LACTL));

  // ------ Get Windows Directory --------------------------
  GetWindowsDirectory( WindowsDirectory, sizeof(WindowsDirectory) );

  // ----- Get Temp-Directory ------------------------------
# ifdef WIN32
  GetTempPath(sizeof(TempDir), TempDir);
# else
  GetTempFileName(0, "LZH", 0, TempDir);
  OpenFile( TempDir, &dummy, OF_DELETE);
  strrchr(TempDir, '\\')[1] = 0;
# endif

//  strcat (strcpy(TempFile, TempDir), "INIS.LZH");
//  strcat (strcpy(TempFile, TempDir), "INIS.ARC");
//  strcat (strcpy(TempFile, TempDir), "INIS.ZOO");
  strcat (strcpy(TempFile, TempDir), "INIS.ZIP");
//  strcat (strcpy(TempFile, TempDir), "INIS.ARC");
// strcpy(TempFile, "A:\\TEST.LZH");

  // -------- Initialize Control Structure -----------------
  memset(&Ctl, 0, sizeof(Ctl) );
  Ctl.lStructSize = sizeof(Ctl);
  Ctl.hwndOwner   = NULL;		// This Parameter is Recommended to hold
					// Your applications main Window
  Ctl.lpfnCallback= ExampleCallback;

  // -------- Tell it, what to do --------------------------
  Ctl.lpstrArchivFile = TempFile;	 // For example C:\\TMP\INIS.LZH
  Ctl.lpstrPath       = WindowsDirectory;// For example C:\\WINDOWS
  Ctl.lpstrWildcards  = "*.INI *.BAK";	 // All INI-Files
  Ctl.Flags	      = LAF_SHORTNAMES;  // Recommended Option

/*  Ctl.lpstrPath      = "H:\\LOGISDBF";
  Ctl.lpstrWildcards = "*.DB*"; */
//  strcpy(TempFile, "H:\LANGERDATEINAME.ZIP");


  // -------- Inform user what we are going to do ----------
  printf("SIMPLE.C ---- Simple C-Code example for LZAPI\n"
	 "I'm going to Archive %Fs\\%Fs into Archiv %Fs\n",
	 Ctl.lpstrPath,
	 Ctl.lpstrWildcards,
	 Ctl.lpstrArchivFile);

  // -------- Perform Actions ------------------------------
  StartTime = GetCurrentTime();
//  err = ZIPAppend( &Ctl );
//  err = LZHAppend( &Ctl );
  err = LAAppend( &Ctl );
//  err = ZOOAppend( &Ctl );
  if (err != LAE_OK)
	   { LAErrMsg(err, &Ctl );
	     return 5;			// Cancel immediatly
	   }
      else { printf("Needed %ld Milliseconds", GetCurrentTime()-StartTime);
	     MessageBox( 0, "Hi, this was your Success for Today ;-)", "SIMPLE.C", MB_OK | MB_ICONINFORMATION);
	   }

  printf("I'm going to list the Archiv %Fs\n", Ctl.lpstrArchivFile);

  // -------- Let's show what we have done -----------------
#ifdef NEIN
//  strcpy(TempFile, "C:\\AWORK\\PSUPP\\LZAPI\\TEST.ZOO");
  Ctl.lpstrArchivFile = TempFile;	 // Leave unchanged
  Ctl.lpstrWildcards  = NULL;            // Show all Files
  Ctl.lpstrListing    = (char *) malloc(10000U); // Buffer for Listing
//  err = LAList( &Ctl );
//  err = LZHList( &Ctl );
  err = LAList( &Ctl );
//  err = ZIPList( &Ctl );
//  err = ZOOList( &Ctl );
  if (err != LAE_OK)
	   { LAErrMsg(err, &Ctl );
	     return 5;			// Cancel immediatly
	   }
      else MessageBox( 0, "Listing buffer has Successfully been filled", "SIMPLE.C", MB_OK | MB_ICONINFORMATION);

  printf("Archiv Listing: \n"
	 "%Fs\n",
	 Ctl.lpstrListing);

  free(Ctl.lpstrListing);
#endif
  printf("I'm going to decompress Archiv %Fs\n", Ctl.lpstrArchivFile);

  if (TempDir[lstrlen(TempDir)-1]=='\\')
      TempDir[lstrlen(TempDir)-1]=0;

  Ctl.lpstrPath      = TempDir;
  Ctl.lpstrWildcards = "*.*";	 // All INI-Files

  StartTime = GetCurrentTime();
//  err = ZIPExtract( &Ctl );
  err = LAExtract( &Ctl );
//  err = ZIPExtract( &Ctl );
  if (err != LAE_OK)
	   { LAErrMsg(err, &Ctl );
	     return 5;			// Cancel immediatly
	   }
      else { printf("Needed %ld Milliseconds", GetCurrentTime()-StartTime);
	     MessageBox( 0, "Decompression has been performed Successfully", "SIMPLE.C", MB_OK | MB_ICONINFORMATION);
	   }

  // --------- End Program ---------------------------------
  return 0;

//  ARCAppend(&Ctl);
}

