#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <lzw.h>

char mask[13] = "*.*";

void main(int,char **);

void main(int argc, char **argv)
{

   char lzw_pathfile[80];
   int i;
   unsigned long options = 1L;     // EXTRACT ALWAYS

   argc--;
   argv++;
   if (!argc){
     puts("USAGE: lzwin <lzw_pathfile> [mask] [-c -n] ");
     puts("       Where -c = Create saved directories and");
     puts("             -n = DO NOT overwrite existing files.");
     exit(1);
   }
   strcpy(lzw_pathfile,*argv);

   argc--;
   argv++;
   for (i=0 ; i < argc ; i++)
     switch(argv[i][0]){
       case '-': if (tolower(argv[i][1]) == 'c')
		   options |= CREATEDIRS;
		 else if (tolower(argv[i][1]) == 'n')
		   options |= NOOVERWRITE;
                 break;
        default: strcpy(mask,argv[i]);
     }

   //  INITIALIZATION
   //
   puts("Initialization...");
   lzw_init();

   puts("Decoding...");
   if (unlzw(lzw_pathfile,options,mask)){
     puts("Decoding error.");
     exit(1);
   }
   printf("End decoding...\n");

   //  DEINITIALIZATION
   //
   printf("Deinitialization.");
   lzw_deinit();

   exit(0);
}

