typedef unsigned char   UCHAR;
typedef char far *      PCHAR;
typedef unsigned        USHORT;
typedef short           SHORT;
typedef unsigned long   ULONG;
typedef unsigned long far * PULONG;
typedef void far *      PVOID;
typedef int             HFILE;

#ifdef INCLUDE_HUFFSTUFF        /* Just for huffman routines    */

#define N       4096            /* buffer size */
#define F       60              /* lookahead buffer size */
#define THRESHOLD   2
#define NIL     N               /* leaf of tree */


#define N_CHAR      (256 - THRESHOLD + F)
                /* kinds of characters (character code = 0..N_CHAR-1) */
#define T       (N_CHAR * 2 - 1) /* size of table */
#define R       (T - 1)          /* position of root */
#define MAX_FREQ    0x8000       /* updates tree when the */
                                 /* root frequency comes to this value. */

struct _HuffStuff{
    SHORT    sType;
    
    HFILE    hInput;
    PVOID    pInput;
    SHORT    (*fGetNextChar)(struct _HuffStuff far *);
    ULONG    ulMaxInput;

    HFILE    hOutput;
    PVOID    pOutput;
    SHORT    (*fPutNextChar)(struct _HuffStuff far *, USHORT);
    ULONG    ulMaxOutput;

    ULONG    textsize;
    ULONG    codesize;
    
    UCHAR    text_buf[N + F - 1];
    
    SHORT    match_position;
    SHORT    match_length;
    SHORT    lson[N + 1];
    SHORT    rson[N + 257];
    SHORT    dad[N + 1];
    
    USHORT   freq[T + 1];        /* frequency table */
    
    SHORT    prnt[T + N_CHAR];   /* pointers to parent nodes, except for the */
                                 /* elements [T..T + N_CHAR - 1] which are used to get */
                                 /* the positions of leaves corresponding to the codes. */
    
    SHORT    son[T];             /* pointers to child nodes (son[], son[] + 1) */
    
    USHORT   getbuf;
    UCHAR    getlen;
    USHORT   putbuf;
    UCHAR    putlen;
    USHORT   code;
	 USHORT   len;
	 };
typedef struct _HuffStuff far * PHUFFSTUFF;
#endif

#define HUFFMAN_FILE_TO_FILE         0x0001
#define HUFFMAN_FILE_TO_BUFFER       0x0002
#define HUFFMAN_BUFFER_TO_FILE       0x0004
#define HUFFMAN_BUFFER_TO_BUFFER     0x0008

#define HUFFMAN_NO_ERROR             0
#define HUFFMAN_FILE_WRITE_ERROR     100
#define HUFFMAN_FILE_LENGTH_ERROR    101
#define HUFFMAN_MEMORY_ERROR         102
#define HUFFMAN_FILE_READ_ERROR      103


/*
*   HUFFMAN1
*/
SHORT FAR PASCAL CompressFileToFile(HFILE , HFILE );
SHORT FAR PASCAL ExpandFileToFile(HFILE , HFILE );
SHORT FAR PASCAL CompressFileToBuffer(HFILE , PCHAR, ULONG, PULONG);
SHORT FAR PASCAL ExpandFileToBuffer(HFILE , PCHAR, ULONG, PULONG);
SHORT FAR PASCAL CompressBufferToFile( PCHAR, ULONG, HFILE);
SHORT FAR PASCAL ExpandBufferToFile( PCHAR, ULONG, HFILE);
/*
*   HUFFMAN5
*/
SHORT FAR PASCAL CompressBufferToBuffer(PCHAR, ULONG, PCHAR, ULONG, PULONG);
SHORT FAR PASCAL ExpandBufferToBuffer(PCHAR, ULONG, PCHAR, ULONG, PULONG);
/*
*   HUFFMAN1
*/
#ifdef INCLUDE_HUFFSTUFF        /* Just for huffman routines    */
SHORT GetNextFileChar(PHUFFSTUFF);
SHORT PutNextFileChar(PHUFFSTUFF, USHORT);
/*
*   HUFFMAN2
*/
SHORT Expand(PHUFFSTUFF);
SHORT ExpandChar(PHUFFSTUFF);
SHORT ExpandPosition(PHUFFSTUFF);
SHORT PutCode(PHUFFSTUFF, SHORT, USHORT);
/*
*   HUFFMAN3
*/
SHORT Compress(PHUFFSTUFF);
SHORT CompressChar(PHUFFSTUFF, USHORT);
SHORT CompressPosition(PHUFFSTUFF, USHORT);
SHORT CompressEnd(PHUFFSTUFF);
SHORT GetBit(PHUFFSTUFF);
SHORT GetByte(PHUFFSTUFF);
/*
*   HUFFMAN4
*/
PHUFFSTUFF StartHuff(void);
void EndHuff(PHUFFSTUFF);
void ReConstructTree(PHUFFSTUFF);
void UpdateTree(PHUFFSTUFF, SHORT);
void InitTree(PHUFFSTUFF);
void InsertNode(PHUFFSTUFF, SHORT);
void DeleteNode(PHUFFSTUFF, SHORT);
/*
*   HUFFMAN5
*/			  
SHORT GetNextBufferChar(PHUFFSTUFF);
SHORT PutNextBufferChar(PHUFFSTUFF, USHORT);
#endif
