#include <stdlib.h>
#include <limits.h>
#include <crbinc/inc.h>

typedef struct exclusionStruct
	{
	int numChars;
	uword counter;
	uword * table;
	} exclusion;

exclusion * newExclusion(int numChars);
void clearExclusion(exclusion * E);
void setExclude(exclusion * E,int sym);
bool isExcluded(exclusion * E,int sym);
void freeExclusion(exclusion * E);

exclusion * newExclusion(int numChars)
{
exclusion * E;
E = new(exclusion);
if ( E == NULL ) return(NULL);
if ( (E->table = malloc(sizeof(uword)*numChars)) == NULL )
	{ free(E); return(NULL); }
E->numChars = numChars;
resetExclusion(E);
return(E);
}

void resetExclusion(exclusion * E)
{
int i;
for(i=0;i<E->numChars;i++) E->table[i] = 0;
E->counter = 1;
}

extern void freeExclusion(exclusion * E)
{
free(E->table);
free(E);
}

void clearExclusion(exclusion * E)
{
if ( E->counter == UWORD_MAX )
	resetExclusion(E);
E->counter ++;
}

void setExclude(exclusion * E,int sym)
{
E->table[sym] = E->counter;
}

bool isExcluded(exclusion * E,int sym)
{
return( (bool) ( E->table[sym] == E->counter ) );
}
 
