
//#define DEBUG_RANGE
#define RANGE_STEP 1
#define RANGE_LOW  136200
#define RANGE_HIGH 136201

// #define FINGERPRINT

#define PROGRESSQUANTUM 0x3FF

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <crbinc/inc.h>
#include <crbinc/memutil.h>
#include <crbinc/bbitio.h>
#include <crbinc/arithc.h>
#include "ppmcoder.h"

#define NUMSEEDS  0     /* rawarray is pre-padded, so it's safe to read backwards */
#define MIN_INPUT_LEN 8

long PPMcoder_EncodeArray(ubyte * RawArray,ubyte * ArithArray,ulong RawArrayLen,
  PPM_WriteFunc PPM_Write,PPM_InitFunc PPM_Init,
  ubyte * PreArray,ulong PreArrayLen,bool DoLRU)
{
ubyte *CurRawArrayPtr,*tp;
long CurRawFileLen,i,OutFileLen;
ulong Context,Context2;
struct PPMcoderInfo * PPMCI;
struct BitIOInfo * BII;
struct FAI * FAI;

if ( RawArrayLen < MIN_INPUT_LEN )
  {
  MemCpy(ArithArray,RawArray,RawArrayLen);
  return((long)RawArrayLen);
  }

CurRawArrayPtr = RawArray;
CurRawFileLen = 0;

/*seed with some chars to make the context valid*/
for(i=0;i<NUMSEEDS;i++)
  {
  *ArithArray++ = *CurRawArrayPtr++;
  CurRawFileLen ++;
  }

if ( (BII = BitIO_Init(ArithArray) ) == NULL )
	{ errputs("\nBitIO_Init failed!!\n\n"); return(0); }

if ( (FAI = FastArithInit(BII)) == NULL )
  {errputs("\nFastArithInit failed!!\n\n"); BitIO_CleanUp(BII); return(0); }

FastArithEncodeCInit(FAI);

if ( (PPMCI = PPM_WriteInit(FAI,256,DoLRU)) == NULL )
  { errputs("\nPPM Allocation failed!!\n\n"); FastArithCleanUp(FAI); BitIO_CleanUp(BII); return(0); }

if ( ! (*PPM_Init)(PPMCI) )
  { errputs("\nPPM_Init failed!!\n\n"); FastArithCleanUp(FAI); BitIO_CleanUp(BII); return(0); }

if ( PreArray && PreArrayLen > 8 )
  {
  PreArray += 8; PreArrayLen -= 8;

  fprintf(stderr,"Precondition: %ld to go\r",PreArrayLen); fflush(stderr);

  while(PreArrayLen--)
    {
    tp = PreArray - 8;
    Context2 = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];
    tp = PreArray - 4;
    Context  = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];
  
    PPMcoder_UpdateC(PPMCI,*PreArray,Context,Context2);

    PreArray++;

	  if ( (PreArrayLen&PROGRESSQUANTUM)==0 )
	    { fprintf(stderr,"Precondition: %ld to go\r",PreArrayLen); fflush(stderr); }
    }

  fprintf(stderr,"Precondition: done           \n");
  }

  if ( (CurRawFileLen&PROGRESSQUANTUM)==0 ) 
    { fprintf(stderr,"%ld/%ld\r",CurRawFileLen,RawArrayLen); fflush(stderr);
#ifdef FINGERPRINT
		printf("%ld/%ld :",CurRawFileLen,RawArrayLen); PPM_ShowFingerPrint(PPMCI); 
#endif
		}

while( CurRawFileLen < RawArrayLen )
  {
  tp = CurRawArrayPtr - 8;
  Context2 = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];
  tp = CurRawArrayPtr - 4;
  Context  = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];

  (*PPM_Write)(PPMCI,*CurRawArrayPtr,Context,Context2,CurRawArrayPtr-5);

#ifdef DEBUG_RANGE
	if ( CurRawFileLen >= RANGE_LOW && CurRawFileLen <= RANGE_HIGH )
		if ( (CurRawFileLen-RANGE_LOW)%RANGE_STEP == 0 )
			{ printf("%ld/%ld :",CurRawFileLen,RawArrayLen); PPM_ShowFingerPrint(PPMCI); }
#endif

  CurRawArrayPtr++;
  CurRawFileLen ++;

  if ( (CurRawFileLen&PROGRESSQUANTUM)==0 ) 
    { fprintf(stderr,"%ld/%ld\r",CurRawFileLen,RawArrayLen); fflush(stderr);
#ifdef FINGERPRINT
		printf("%ld/%ld :",CurRawFileLen,RawArrayLen);
			PPM_ShowFingerPrint(PPMCI); 
#endif
    if ( !PPM_CheckErr(PPMCI) ) { getchar(); }
		}

  }

if ( ! PPM_WriteDone(PPMCI) )
  { FastArithCleanUp(FAI); BitIO_CleanUp(BII); return(0); }

FastArithEncodeCDone_Min(FAI); /* <> */
OutFileLen = BitIO_FlushWrite(BII);
OutFileLen += NUMSEEDS;

FastArithCleanUp(FAI);
BitIO_CleanUp(BII);

return(OutFileLen);
}

bool PPMcoder_DecodeArray(ubyte * RawArray,ubyte * ArithArray,ulong RawArrayLen,
  PPM_ReadFunc PPM_Read,PPM_InitFunc PPM_Init,
  ubyte * PreArray,ulong PreArrayLen,bool DoLRU)
{
ubyte *CurRawArrayPtr,*tp;
long CurRawFileLen,i;
ulong Context,Context2;
struct PPMcoderInfo * PPMCI;
struct BitIOInfo * BII;
struct FAI * FAI;

if ( RawArrayLen < MIN_INPUT_LEN )
  {
  MemCpy(RawArray,ArithArray,RawArrayLen);
  return(1);
  }

CurRawArrayPtr = RawArray;
CurRawFileLen = 0;

/*seed with some chars to make the context valid*/
for(i=0;i<NUMSEEDS;i++)
  {
  *CurRawArrayPtr++ = *ArithArray++;
  CurRawFileLen ++;
  }

if ( (BII = BitIO_Init(ArithArray) ) == NULL )
  { errputs("\nBitIO_Init failed!!\n\n"); return(0); }

if ( (FAI = FastArithInit(BII)) == NULL )
  { errputs("\nFastArithInit failed!!\n\n"); BitIO_CleanUp(BII); return(0); }

BitIO_InitRead(BII);

FastArithDecodeCInit(FAI);

if ( (PPMCI = PPM_ReadInit(FAI,256,DoLRU)) == NULL )
  { errputs("\nPPM_Allocation failed!!\n\n"); FastArithCleanUp(FAI); BitIO_CleanUp(BII); return(0); }

if ( ! (*PPM_Init)(PPMCI) )
  { errputs("\nPPM_Init failed!!\n\n"); FastArithCleanUp(FAI); BitIO_CleanUp(BII); return(0); }

if ( PreArray && PreArrayLen > 8 )
  {
  PreArray += 8; PreArrayLen -= 8;

  fprintf(stderr,"Precondition: %ld to go\r",PreArrayLen);
  fflush(stderr);

  while(PreArrayLen--)
    {
    tp = PreArray - 8;
    Context2 = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];
    tp = PreArray - 4;
    Context  = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];
  
    PPMcoder_UpdateC(PPMCI,*PreArray,Context,Context2);

    PreArray++;

	  if ( (PreArrayLen&PROGRESSQUANTUM)==0 )
	    { fprintf(stderr,"Precondition: %ld to go\r",PreArrayLen); fflush(stderr); }
    }

  fprintf(stderr,"Precondition: done           \n");
  }

  if ( (CurRawFileLen&PROGRESSQUANTUM)==0 ) 
    { fprintf(stderr,"%ld/%ld\r",CurRawFileLen,RawArrayLen); fflush(stderr);
#ifdef FINGERPRINT
		printf("%ld/%ld :",CurRawFileLen,RawArrayLen);
			PPM_ShowFingerPrint(PPMCI); 
#endif
		}

while( CurRawFileLen < RawArrayLen )
  {
  tp = CurRawArrayPtr - 8;
  Context2 = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];
  tp = CurRawArrayPtr - 4;
  Context  = (tp[0]<<24) + (tp[1]<<16) + (tp[2]<<8) + tp[3];

  *CurRawArrayPtr = (*PPM_Read)(PPMCI,Context,Context2,CurRawArrayPtr-5);

#ifdef DEBUG_RANGE
	if ( CurRawFileLen >= RANGE_LOW && CurRawFileLen <= RANGE_HIGH )
		if ( (CurRawFileLen-RANGE_LOW)%RANGE_STEP == 0 )
			{ printf("%ld/%ld :",CurRawFileLen,RawArrayLen); PPM_ShowFingerPrint(PPMCI); }
#endif

  CurRawArrayPtr++;
  CurRawFileLen ++;

  if ( (CurRawFileLen&PROGRESSQUANTUM)==0 ) 
    { fprintf(stderr,"%ld/%ld\r",CurRawFileLen,RawArrayLen); fflush(stderr);
#ifdef FINGERPRINT
		printf("%ld/%ld :",CurRawFileLen,RawArrayLen);
		PPM_ShowFingerPrint(PPMCI); 
#endif
    if ( !PPM_CheckErr(PPMCI) ) { getchar(); }
    }
  }

if ( ! PPM_ReadDone(PPMCI) )
  { FastArithCleanUp(FAI); BitIO_CleanUp(BII); return(0); }

FastArithDecodeCDone(FAI);

FastArithCleanUp(FAI);
BitIO_CleanUp(BII);

return(1);
}
