

#define PERMIT_LRU

// #define LRU_INSANITYCHECK
#define LRU_INSANITY_QUANTUM 1024

#define DO_DT_AVERAGE
	/* DT_AVERAGE looks at all lower-index DT buckets; if any have higher probabilities,
			they are averaged in with the current one; attempts to minimize random fluctuations;
			helps by about 0.002 bpb, hurts speed */

/* #define STATS */ /* turn on for lots of info */

/* #define DO_MTF */ /* helps speed?  test ! */

/*******

we'd like all orders to share index structures, but that's a mess

----

LastC recency scaling doesn't seem to help at all.  Turning it on
has essentially no effect, though a reasonable number of characters
are LastC hits: about 1/8 of them.

  ( progc & bib might be showing improvement.
    supposedly obj2 benefits alot from this )

***************/

#include <crbinc/inc.h>
#include <crbinc/memutil.h>
#include <crbinc/mempool.h>
#include <crbinc/arithc.h>
#include <crbinc/crc32.h>

#include "exclude.h"

#ifdef STATS
#include <stdio.h>
#endif /* STATS */

/* config settings */

/** moved to ppmz_cfg for faster testing **/

#include "ppmz_cfg.h"

#define CharInc_Novel 1
#define CharInc       1     /** 2 for PPMD , 1 for PPMC **/
#define EscpInc       1

#define PPMHASHBITS 14

/****/

#define PPMZF_DT_ONE 1
#define PPMZF_DT_TWO 2
#define PPMZF_LRU    4

#define NUM_O1_CHARS      (1<<DTSX_BITS)
#define O1_MASK           (NUM_O1_CHARS - 1)
#define HIGH_DETERM_COUNT (DT_NUMCOUNTS-1)
#define DT_SIZE           (DT_NUMCOUNTS*NUM_O1_CHARS)

#define DT2SXHASH(x)    ( x & ((1<<DT2SX_BITS)-1) )
#define DT2CTHASH(t)    ( min((t-1),((1<<DT2CT_BITS)-1)) )

#define DT2_SIZE        (1<<(DT2CT_BITS+DT2SX_BITS))
#define DT2HASH(e,t,x)  ( (DT2CTHASH(t)<<DT2SX_BITS) + DT2SXHASH(x) )
#define DT2_NUM_O1_CHARS  (1<<DT2SX_BITS)
#define DT2_NUMCOUNTS     (1<<DT2CT_BITS)

#define PPMHASHMEMBERS (1<<PPMHASHBITS)
#define PPMHASH(x) ( ((x>>9)^x) & (PPMHASHMEMBERS-1))

/** context list operations macros **/

#define CONTEXT_ADDHEAD(CurContextInfo,CurIndex)	{																		\
CurContextInfo->Next = CurIndex->ContextList;																					\
CurContextInfo->Prev = (struct PPMZ_ContextInfo *)CurIndex;														\
if ( CurContextInfo->Next ) CurContextInfo->Next->Prev = CurContextInfo;							\
CurContextInfo->Prev->Next = CurContextInfo;		}					/***/

#define CONTEXT_CUT(CurContextInfo)		{																								\
CurContextInfo->Prev->Next = CurContextInfo->Next;																		\
if ( CurContextInfo->Next ) CurContextInfo->Next->Prev = CurContextInfo->Prev;	}	/***/

#ifdef DO_MTF

#define CONTEXT_MTF(CurContextInfo,CurIndex)                                  		  	\
if ( CurContextInfo == CurIndex->ContextList ) { } else                								\
 { CONTEXT_CUT(CurContextInfo); CONTEXT_ADDHEAD(CurContextInfo,CurIndex); }       /***/

#else

#define CONTEXT_MTF(CurContextInfo,CurIndex)

#endif /* DO_MTF */

/****/

struct PPMZ_Node
  {
  struct PPMZ_Node * Next;
  uword Count;
  uword Char;
  };

struct PPMZ_ContextIndex
  {
  struct PPMZ_ContextIndex * Next;

  struct PPMZ_ContextInfo * ContextList;
  
  ulong Context;
  };

struct PPMZ_ContextInfo
  {
  struct PPMZ_Node * Nodes; 		/* must be in same place as Node->Next */

  struct PPMZ_ContextInfo *Next; /* must be in same place as Index->List */
	struct PPMZ_ContextInfo *Prev;

  ulong HOContext;
  uword TotCount,EscapeCount;

	struct PPMZ_ContextInfo *LRU_Next,*LRU_Prev;
  };

struct PPMZ_MemPools
  {
  MemPool * NodePool;
  MemPool * ContextPool;
  MemPool * IndexPool;
	struct PPMZ_ContextInfo * LRU_Base;
  };

struct PPMZInfo
  {
  long Error; /* if it's not 0, you're fucked */

  /* copied in from users */
  struct FAI * FAI;

  /* state save between DecodeC and DecodeGotC */
  uword * PPMZ_WriteC_Ptr;

  struct PPMZ_MemPools * MyPools;
  MemPool * NodePool;
  MemPool * ContextPool;
  MemPool * IndexPool;
	struct PPMZ_ContextInfo *LRU_Base;

  bool DoDT,DoDT2,DoLRU;

  uword * DT_EscCounts;
  uword * DT_TotCounts;

  uword * DT2_EscCounts;
  uword * DT2_TotCounts;

#ifdef STATS
  long Stats_NumSeen;
  long Stats_NumGot;
  long Stats_NumEscaped;
  long Stats_NumDeterm;
  long Stats_NumDetMaxCnt;
  long Stats_NumDeterm2;
  long Stats_NumElse;
#endif /* STATS */

  struct PPMZ_ContextIndex * ContextIndeces[PPMHASHMEMBERS];
  };

/*** ****/

void PPMZ_CleanUp(struct PPMZInfo * PPMI);
void PPMZ_FreePools(struct PPMZ_MemPools * Pools);

/*** ****/

struct PPMZ_MemPools * PPMZ_AllocPools(void)
{
struct PPMZ_MemPools * Ret;

if ( (Ret = AllocMem(sizeof(struct PPMZ_MemPools),MEMF_ANY|MEMF_CLEAR)) == NULL )
  return(NULL);

if ( (Ret->NodePool = AllocPool(sizeof(struct PPMZ_Node),1024,1024)) == NULL )
  { PPMZ_FreePools(Ret); return(NULL); }

if ( (Ret->ContextPool = AllocPool(sizeof(struct PPMZ_ContextInfo),1024,1024)) == NULL )
  { PPMZ_FreePools(Ret); return(NULL); }

if ( (Ret->IndexPool = AllocPool(sizeof(struct PPMZ_ContextIndex),1024,1024)) == NULL )
  { PPMZ_FreePools(Ret); return(NULL); }

if ( (Ret->LRU_Base = GetPoolHunk(Ret->ContextPool,0)) == NULL )
  { PPMZ_FreePools(Ret); return(NULL); }

Ret->LRU_Base->LRU_Next = Ret->LRU_Base;
Ret->LRU_Base->LRU_Prev = Ret->LRU_Base;	

return(Ret);
}

void PPMZ_FreePools(struct PPMZ_MemPools * Pools)
{
if (!Pools) return;

if ( Pools->NodePool )    FreePool(Pools->NodePool);
if ( Pools->ContextPool ) FreePool(Pools->ContextPool);
if ( Pools->IndexPool )   FreePool(Pools->IndexPool);

}

struct PPMZInfo * PPMZ_Init(struct FAI * FAI,int Flags,struct PPMZ_MemPools * Pools)
{
struct PPMZInfo * PPMI;
int i,j,k;

if ( (PPMI = AllocMem(sizeof(struct PPMZInfo),MEMF_ANY|MEMF_CLEAR)) == NULL )
  return(NULL);

if ( Pools )
  {
  PPMI->MyPools = NULL;
	}
else
	{
	if ( (Pools = PPMZ_AllocPools()) == NULL )
		{ free(PPMI); return(NULL); }
	PPMI->MyPools = Pools;
	}

PPMI->NodePool    = Pools->NodePool;
PPMI->ContextPool = Pools->ContextPool;
PPMI->IndexPool   = Pools->IndexPool;
PPMI->LRU_Base    = Pools->LRU_Base;

if ( Flags & PPMZF_DT_TWO ) { PPMI->DoDT = PPMI->DoDT2 = 1; }
if ( Flags & PPMZF_DT_ONE ) PPMI->DoDT = 1;
if ( Flags & PPMZF_LRU    ) PPMI->DoLRU = 1;

if ( PPMI->DoDT )
  {
  if ( (PPMI->DT_EscCounts = AllocMem(sizeof(uword)*DT_SIZE,MEMF_ANY)) == NULL )
    { PPMZ_CleanUp(PPMI); return(NULL); }
  if ( (PPMI->DT_TotCounts = AllocMem(sizeof(uword)*DT_SIZE,MEMF_ANY)) == NULL )
    { PPMZ_CleanUp(PPMI); return(NULL); }
  
  for(j=0;j<NUM_O1_CHARS;j++)
    {
    PPMI->DT_EscCounts[j] = 1;
    PPMI->DT_TotCounts[j] = 2;
    for(i=1;i<DT_NUMCOUNTS;i++)
      {
      k = (i<<DTSX_BITS) + j;

      PPMI->DT_EscCounts[k] = 1;

      if ( i == 1 )
        PPMI->DT_TotCounts[k] = 2;
      else if ( i == 2 )
        PPMI->DT_TotCounts[k] = 7;
      else if ( i == 3 )
        PPMI->DT_TotCounts[k] = 20;
      else
        PPMI->DT_TotCounts[k] = 61;
      }
    }
  }

if ( PPMI->DoDT2 )
  {
  if ( (PPMI->DT2_EscCounts = AllocMem(sizeof(uword)*DT2_SIZE,MEMF_ANY)) == NULL )
    { PPMZ_CleanUp(PPMI); return(NULL); }
  if ( (PPMI->DT2_TotCounts = AllocMem(sizeof(uword)*DT2_SIZE,MEMF_ANY)) == NULL )
    { PPMZ_CleanUp(PPMI); return(NULL); }

  for(i=0;i<DT2_SIZE;i++)
    {
    PPMI->DT2_EscCounts[i] = 1;
    PPMI->DT2_TotCounts[i] = 2 + (i>>DT2SX_BITS);
    }
  }

PPMI->FAI = FAI;
PPMI->Error = 0;

return(PPMI);
}


void PPMZ_Scale(struct PPMZInfo * PPMI,struct PPMZ_ContextInfo * CurContextInfo)
{
struct PPMZ_Node *CurNode,*PrevNode;
long TotProb;

CurContextInfo->EscapeCount >>= 1;
CurContextInfo->EscapeCount += EscpInc;
TotProb = CurContextInfo->EscapeCount;
CurNode = CurContextInfo->Nodes;
PrevNode = (struct PPMZ_Node *) CurContextInfo;
while(CurNode)
  {
  if ( CurNode->Count <= CharInc )
    {
    PrevNode->Next = CurNode->Next;

    if ( ! FreePoolHunk(PPMI->NodePool,CurNode) )
      PPMI->Error = 9;

    CurNode = PrevNode->Next;
    }
  else
    {
    CurNode->Count >>= 1;
    TotProb += CurNode->Count;

    PrevNode = CurNode;
    CurNode = CurNode->Next;
    }
  }

CurContextInfo->TotCount = TotProb;

}

#define PPMZ_CutLRU(CI) { \
if ( CI->LRU_Next ) CI->LRU_Next->LRU_Prev = CI->LRU_Prev; \
if ( CI->LRU_Prev ) CI->LRU_Prev->LRU_Next = CI->LRU_Next; \
CI->LRU_Next = NULL; CI->LRU_Prev = NULL; } \
/* */

/* move CI to LRU_Head */
#define PPMZ_UpdateLRU(PPMI,CI) { PPMZ_CutLRU(CI); \
CI->LRU_Next = PPMI->LRU_Base->LRU_Next; CI->LRU_Prev = PPMI->LRU_Base; \
CI->LRU_Next->LRU_Prev = CI; CI->LRU_Prev->LRU_Next = CI; } \
/* */

#ifndef PERMIT_LRU
void PPMZ_CheckLRU(struct PPMZInfo * PPMI) { }
#else

#ifdef LRU_INSANITYCHECK
#include <stdio.h>
static int LRU_InsanityCounter = 0;
#endif /* LRU_INSANITYCHECK */

void PPMZ_CheckLRU(struct PPMZInfo * PPMI)
{
struct PPMZ_ContextInfo * LRU_Tail;

if ( PPMI->NodePool->NumItemsActive < LRU_MaxNumNodes ) return;

#ifdef LRU_INSANITYCHECK
if ( ++LRU_InsanityCounter == LRU_INSANITY_QUANTUM )
	{
	struct PPMZ_ContextInfo *Base = PPMI->LRU_Base;
	int MaxSteps = PPMI->ContextPool->NumItemsActive;
	struct PPMZ_ContextInfo *N;
	int Steps;

	LRU_InsanityCounter = 0;

	N = Base->LRU_Next;
	Steps = 1;

	while(N != Base)
		{
		if ( N->LRU_Prev->LRU_Next != N )
			{
			errputs("\nLRU insane : Node->LRU_Prev->LRU_Next != Node\n");
			getchar();
			return;
			}
		N = N->LRU_Next;
		Steps++;
		if ( Steps > MaxSteps )
			{
			errputs("\nLRU insane : Steps > MaxSteps : Looping LRU\n");
			getchar();
			return;
			}
		}
	}
#endif

LRU_Tail = PPMI->LRU_Base->LRU_Prev;

if ( LRU_Tail == PPMI->LRU_Base ) return;

CONTEXT_CUT(LRU_Tail);
PPMZ_CutLRU(LRU_Tail);

/* free nodes */
	{
	struct PPMZ_Node *CurNode,*NextNode;

	CurNode = LRU_Tail->Nodes;
	while(CurNode)
	  {
		NextNode = CurNode->Next;
	  if ( ! FreePoolHunk(PPMI->NodePool,CurNode) ) PPMI->Error = 9;
	  CurNode = NextNode;
	  }
	}

if ( ! FreePoolHunk(PPMI->ContextPool,LRU_Tail) ) PPMI->Error = 9;

}
#endif /* PERMIT_LRU */

void PPMZ_WriteEsc(struct PPMZInfo * PPMI,long EscP,long TotP,long NumC,ulong Context,bool DoEsc)
{

if ( TotP == EscP || NumC == 0 )
  {
  if ( ! DoEsc ) PPMI->Error = 1;
  return;
  }
if ( EscP == 0 )
  {
  if ( DoEsc ) PPMI->Error = 2;
  return;
  }

if ( PPMI->DoDT2 && NumC <= 2 )
  {
  int I;
  I = DT2HASH(EscP,TotP,Context);

#ifdef STATS
  PPMI->Stats_NumDeterm2++;
#endif

  if ( PPMI->DT2_TotCounts[I] > DT2_MINCNT )
    {

    EscP = PPMI->DT2_EscCounts[I];
    TotP = PPMI->DT2_TotCounts[I];

    if ( TotP > PPMI->FAI->FastArithCumProbMaxSafe )
      {
			EscP >>= 1; TotP >>= 1;
			if ( TotP == EscP || EscP == 0 )
				{
				EscP++; TotP += 2;
				}
	  	PPMI->DT2_EscCounts[I] = EscP;
  	  PPMI->DT2_TotCounts[I] = TotP;
			}
  
    if ( DoEsc )
      {
      FastArithEncodeRange(PPMI->FAI,0,EscP,TotP);
      PPMI->DT2_EscCounts[I] += DT2_INC_E;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    else
      {
      FastArithEncodeRange(PPMI->FAI,EscP,TotP,TotP);
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    }
  else
    {
    if ( DoEsc )
      {
      FastArithEncodeRange(PPMI->FAI,0,EscP,TotP);
      PPMI->DT2_EscCounts[I] += DT2_INC_E;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    else
      {
      FastArithEncodeRange(PPMI->FAI,EscP,TotP,TotP);
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    }

  return;
  }

#ifdef STATS
PPMI->Stats_NumElse++;
#endif

if ( DoEsc )
  {
  FastArithEncodeRange(PPMI->FAI,0,EscP,TotP);
  }
else
  {
  FastArithEncodeRange(PPMI->FAI,EscP,TotP,TotP);
  }

}

bool PPMZ_ReadEsc(struct PPMZInfo * PPMI,long EscP,long TotP,long NumC,ulong Context)
{
bool GotEsc;
long Target;

if ( TotP == EscP || NumC == 0 ) return(1);
if ( EscP == 0 ) return(0);

if ( PPMI->DoDT2 && NumC <= 2 )
  {
  int I;
  I = DT2HASH(EscP,TotP,Context);

  if ( PPMI->DT2_TotCounts[I] > DT2_MINCNT )
    {

		TotP = PPMI->DT2_TotCounts[I];
    EscP = PPMI->DT2_EscCounts[I];

    if ( TotP > PPMI->FAI->FastArithCumProbMaxSafe )
      {
			EscP >>= 1; TotP >>= 1;
			if ( TotP == EscP || EscP == 0 )
				{
				EscP++; TotP += 2;
				}
	  	PPMI->DT2_EscCounts[I] = EscP;
  	  PPMI->DT2_TotCounts[I] = TotP;
			}
  
    FastArithDecodeRange(PPMI->FAI,&Target,TotP);
  
    if ( Target < EscP )
      {
      FastArithDecodeRangeRemove(PPMI->FAI,0,EscP,TotP);
      GotEsc = 1;
      PPMI->DT2_EscCounts[I] += DT2_INC_E;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    else
      {
      FastArithDecodeRangeRemove(PPMI->FAI,EscP,TotP,TotP);
      GotEsc = 0;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    
    }
  else
    {
    FastArithDecodeRange(PPMI->FAI,&Target,TotP);
    
    if ( Target < EscP )
      {
      FastArithDecodeRangeRemove(PPMI->FAI,0,EscP,TotP);
      GotEsc = 1;
      PPMI->DT2_EscCounts[I] += DT2_INC_E;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    else
      {
      FastArithDecodeRangeRemove(PPMI->FAI,EscP,TotP,TotP);
      GotEsc = 0;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    }

  return(GotEsc);
  }

FastArithDecodeRange(PPMI->FAI,&Target,TotP);

if ( Target < EscP )
  {
  FastArithDecodeRangeRemove(PPMI->FAI,0,EscP,TotP);
  GotEsc = 1;
  }
else
  {
  FastArithDecodeRangeRemove(PPMI->FAI,EscP,TotP,TotP);
  GotEsc = 0;
  }

return(GotEsc);
}

/*
 * return-value indicates whether char was written with
 *  current order or not.  If not, you MUST write it with
 *  some other model.
 *
 */
bool PPMZ_EncodeC(struct PPMZInfo * PPMI,long Symbol,ulong Context,ulong HOContext,exclusion * Exclusion)
{
struct PPMZ_ContextIndex *CurIndex,*PrevIndex;
struct PPMZ_ContextInfo *CurContextInfo;
struct PPMZ_Node *CurNode;
long Hash;

#ifdef STATS
PPMI->Stats_NumSeen++;
#endif /* STATS */

if ( PPMI->DoLRU ) PPMZ_CheckLRU(PPMI);

Hash = PPMHASH(Context);

/** find a context index **/

PrevIndex = NULL;
CurIndex = PPMI->ContextIndeces[Hash];
while(CurIndex)
  {
  if ( CurIndex->Context == Context )
    {
#ifdef DO_MTF
    if ( PrevIndex )
      {
      /* MTF */
      PrevIndex->Next = CurIndex->Next;
      CurIndex->Next = PPMI->ContextIndeces[Hash];
      PPMI->ContextIndeces[Hash] = CurIndex;
      }
#endif
    goto PPMZ_Encode_FoundCurIndex;
    }
  PrevIndex = CurIndex;
  CurIndex = CurIndex->Next;
  }

/* index not found */
if ( (CurIndex = GetPoolHunk(PPMI->IndexPool,1)) == NULL )
  { PPMI->Error = 9; return(0); }
CurIndex->Context = Context;
CurIndex->Next = PPMI->ContextIndeces[Hash];
PPMI->ContextIndeces[Hash] = CurIndex;
CurIndex->ContextList = NULL;

/***/
  PPMZ_Encode_FoundCurIndex:
/***/

CurContextInfo = CurIndex->ContextList;
while(CurContextInfo)
  {
  if ( CurContextInfo->HOContext == HOContext )
    {
    long TotProb,NumCs;

    /*** got context ***/

		CONTEXT_MTF(CurContextInfo,CurIndex);
		PPMZ_UpdateLRU(PPMI,CurContextInfo);

    CurNode = CurContextInfo->Nodes;

    if ( PPMI->DoDT && CurNode && CurNode->Next == NULL )
      {  /* deterministic context */
      long TableIndex;
      long EscapeCount;

#ifdef STATS
PPMI->Stats_NumDeterm++;
if ( CurNode->Count >= HIGH_DETERM_COUNT )
  PPMI->Stats_NumDetMaxCnt++;
#endif

      TableIndex = min(CurNode->Count,HIGH_DETERM_COUNT);
      TableIndex <<= DTSX_BITS;
      TableIndex += (Context&O1_MASK);

      if ( PPMI->DT_TotCounts[TableIndex] > PPMI->FAI->FastArithCumProbMaxSafe )
        {
        PPMI->DT_TotCounts[TableIndex] >>= 1;
        PPMI->DT_EscCounts[TableIndex] >>= 1;
        if ( ! PPMI->DT_EscCounts[TableIndex] )
          {
          PPMI->DT_EscCounts[TableIndex] ++;
          PPMI->DT_TotCounts[TableIndex] ++;
          }
        }

      EscapeCount = PPMI->DT_EscCounts[TableIndex];
      TotProb     = PPMI->DT_TotCounts[TableIndex];

      if ( TotProb < DT_MINCNT )
        { EscapeCount = 1; TotProb = 1 + CurNode->Count; }

#ifdef DO_DT_AVERAGE
			{
      long i,j;

      for(i=((TableIndex>>DTSX_BITS)-1);i>=1;i--)
        {
        j = (i<<DTSX_BITS)+(Context&O1_MASK);
        if ( PPMI->DT_TotCounts[j] > DT_MINCNT )
          {
          if ( (PPMI->DT_TotCounts[j]/PPMI->DT_EscCounts[j]) > 
                (TotProb/EscapeCount) )
            {
            TotProb += PPMI->DT_TotCounts[j];
            EscapeCount += PPMI->DT_EscCounts[j];
            }
          }
        }
			}
#endif /* DO_DT_AVERAGE */

      while ( TotProb >= PPMI->FAI->FastArithCumProbMax )
        {
				TotProb >>= 1; EscapeCount >>= 1;
				if ( ! EscapeCount ) { EscapeCount++; TotProb++; }
        }
			if ( CurContextInfo->TotCount > PPMI->FAI->FastArithCumProbMaxSafe )
				{
				CurNode->Count >>= 1;
				CurContextInfo->TotCount = CurNode->Count + 1;
				}

      if ( CurNode->Char == Symbol )
        {
        FastArithEncodeRange(PPMI->FAI,EscapeCount,TotProb,TotProb);

        CurNode->Count            += CharInc;
        CurContextInfo->TotCount  += CharInc;

        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;

#ifdef STATS
PPMI->Stats_NumGot++;
#endif /* STATS */

        return(1);
        }
      else
        {

        if ( ! isExcluded(Exclusion,CurNode->Char) )
          {
#ifdef STATS
PPMI->Stats_NumEscaped++;
#endif /* STATS */
          FastArithEncodeRange(PPMI->FAI,0,EscapeCount,TotProb);
	        setExcluded(Exclusion,CurNode->Char);
          }
        
        CurContextInfo->EscapeCount += EscpInc;
        CurContextInfo->TotCount    += EscpInc;

        PPMI->DT_EscCounts[TableIndex] += DT_INC_E;
        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;

        if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
          { PPMI->Error = 9; return(0); }
    
        CurContextInfo->TotCount += CharInc_Novel;
    
        CurNode->Char = Symbol;
        CurNode->Count = CharInc_Novel;
        CurNode->Next = CurContextInfo->Nodes;
        CurContextInfo->Nodes = CurNode;

        return(0);
        }
      }
    
    NumCs=0;
    TotProb = CurContextInfo->EscapeCount;
    while(CurNode)
      {
      if ( CurNode->Char == Symbol )
        {
        struct PPMZ_Node *GotNode;
        long LowProb,HighProb;
  
        NumCs++;  
        LowProb = TotProb;
        TotProb = HighProb = TotProb + CurNode->Count;
        GotNode = CurNode;

        CurNode = CurNode->Next;
        while(CurNode)
          {
          if ( !isExcluded(Exclusion,CurNode->Char) )
            { NumCs++; TotProb += CurNode->Count; }
          CurNode = CurNode->Next;
          }
        CurNode = GotNode;
  
        PPMZ_WriteEsc(PPMI,CurContextInfo->EscapeCount,TotProb,NumCs,Context,0);
        LowProb -= CurContextInfo->EscapeCount;
        HighProb -= CurContextInfo->EscapeCount;
        TotProb -= CurContextInfo->EscapeCount;

        FastArithEncodeRange(PPMI->FAI,LowProb,HighProb,TotProb);

        if ( CurNode->Count == CharInc_Novel && CurContextInfo->EscapeCount > EscpInc )
          {
          CurContextInfo->EscapeCount -= EscpInc;
          CurContextInfo->TotCount -= EscpInc;
          }
  
        CurNode->Count += CharInc;
        CurContextInfo->TotCount += CharInc;

        if ( CurContextInfo->TotCount >= PPMI->FAI->FastArithCumProbMax )
          PPMZ_Scale(PPMI,CurContextInfo);
  
#ifdef STATS
PPMI->Stats_NumGot++;
#endif /* STATS */

        return(1);
        }
      if ( !isExcluded(Exclusion,CurNode->Char) )
        { NumCs++; TotProb += CurNode->Count; }
      CurNode = CurNode->Next;
      }

#ifdef STATS
PPMI->Stats_NumEscaped++;
#endif /* STATS */

    /** char not found in list **/

    CurNode = CurContextInfo->Nodes;
    while(CurNode)
      {
			setExcluded(Exclusion,CurNode->Char);
      CurNode = CurNode->Next;
      }

    PPMZ_WriteEsc(PPMI,CurContextInfo->EscapeCount,TotProb,NumCs,Context,1);
  
    CurContextInfo->EscapeCount += EscpInc;
    CurContextInfo->TotCount += EscpInc;
  
    if ( CurContextInfo->TotCount >= PPMI->FAI->FastArithCumProbMax )
      {
      PPMZ_Scale(PPMI,CurContextInfo);
      }
  
    if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
      { PPMI->Error = 9; return(0); }
  
    CurContextInfo->TotCount += CharInc_Novel;
  
    CurNode->Char = Symbol;
    CurNode->Count = CharInc_Novel;
    CurNode->Next = CurContextInfo->Nodes;
    CurContextInfo->Nodes = CurNode;
  
    return(0);
    }
  CurContextInfo = CurContextInfo->Next;
  }

/** context not found **/

if ( (CurContextInfo = GetPoolHunk(PPMI->ContextPool,1)) == NULL )
  { PPMI->Error = 9; return(0); }
if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
  { PPMI->Error = 9; return(0); }

CurNode->Char = Symbol;
CurNode->Count = CharInc_Novel;
CurNode->Next = NULL;

CurContextInfo->HOContext = HOContext;
CurContextInfo->TotCount = CharInc_Novel + EscpInc;
CurContextInfo->EscapeCount = EscpInc;
CurContextInfo->Nodes = CurNode;
CurContextInfo->Next = CurContextInfo->Prev = CurContextInfo->LRU_Next = CurContextInfo->LRU_Prev = NULL;

CONTEXT_ADDHEAD(CurContextInfo,CurIndex);
PPMZ_UpdateLRU(PPMI,CurContextInfo);

return(0);
}


/*
 * return-value indicates whether an escape was read or not
 *  If so, you MUST read it with some other model.
 *    and then call DecodeGotC
 *  If not, don't call DecodeGotC
 *
 */
bool PPMZ_DecodeC(struct PPMZInfo * PPMI,long * SymbolPtr,ulong Context,ulong HOContext,exclusion * Exclusion)
{
struct PPMZ_ContextIndex *CurIndex,*PrevIndex;
struct PPMZ_ContextInfo *CurContextInfo;
struct PPMZ_Node *CurNode;
long Hash;

if ( PPMI->DoLRU ) PPMZ_CheckLRU(PPMI);

Hash = PPMHASH(Context);

CurIndex = PPMI->ContextIndeces[Hash];
PrevIndex = NULL;
while(CurIndex)
  {
  if ( CurIndex->Context == Context )
    {
#ifdef DO_MTF
    if ( PrevIndex )
      {
      /* MTF */
      PrevIndex->Next = CurIndex->Next;
      CurIndex->Next = PPMI->ContextIndeces[Hash];
      PPMI->ContextIndeces[Hash] = CurIndex;
      }
#endif
    goto PPMZ_Decode_FoundCurIndex;
    }
  PrevIndex = CurIndex;
  CurIndex = CurIndex->Next;
  }

/* index not found */
if ( (CurIndex = GetPoolHunk(PPMI->IndexPool,1)) == NULL )
  { PPMI->Error = 9; return(0); }
CurIndex->Context = Context;
CurIndex->Next = PPMI->ContextIndeces[Hash];
PPMI->ContextIndeces[Hash] = CurIndex;
CurIndex->ContextList = NULL;

/***/
  PPMZ_Decode_FoundCurIndex:
/***/

CurContextInfo = CurIndex->ContextList;
while(CurContextInfo)
  {
  if ( CurContextInfo->HOContext == HOContext )
    {
    long TargetProb;
    long LowProb,HighProb;
    long TotProb,NumCs;

    /* got context */

		CONTEXT_MTF(CurContextInfo,CurIndex);
		PPMZ_UpdateLRU(PPMI,CurContextInfo);

    CurNode = CurContextInfo->Nodes;

    if ( PPMI->DoDT && CurNode && CurNode->Next == NULL )
      { /* deterministic context */
      long TableIndex;
      long EscapeCount;

      TableIndex = min(CurNode->Count,HIGH_DETERM_COUNT);
      TableIndex <<= DTSX_BITS;
      TableIndex += (Context&O1_MASK);

      if ( PPMI->DT_TotCounts[TableIndex] > PPMI->FAI->FastArithCumProbMaxSafe )
        {
        PPMI->DT_TotCounts[TableIndex] >>= 1;
        PPMI->DT_EscCounts[TableIndex] >>= 1;
        if ( ! PPMI->DT_EscCounts[TableIndex] )
          {
          PPMI->DT_EscCounts[TableIndex] ++;
          PPMI->DT_TotCounts[TableIndex] ++;
          }
        }

      EscapeCount = PPMI->DT_EscCounts[TableIndex];
      TotProb     = PPMI->DT_TotCounts[TableIndex];

      if ( TotProb < DT_MINCNT )
        { EscapeCount = 1; TotProb = 1 + CurNode->Count; }


#ifdef DO_DT_AVERAGE
			{
      long i,j;

      for(i=((TableIndex>>DTSX_BITS)-1);i>=1;i--)
        {
        j = (i<<DTSX_BITS)+(Context&O1_MASK);
        if ( PPMI->DT_TotCounts[j] > DT_MINCNT )
          {
          if ( (PPMI->DT_TotCounts[j]/PPMI->DT_EscCounts[j]) > 
                (TotProb/EscapeCount) )
            {
            TotProb += PPMI->DT_TotCounts[j];
            EscapeCount += PPMI->DT_EscCounts[j];
            }
          }
        }
			}
#endif /* DO_DT_AVERAGE */

      while ( TotProb >= PPMI->FAI->FastArithCumProbMax )
        {
				TotProb >>= 1; EscapeCount >>= 1;
				if ( ! EscapeCount ) { EscapeCount++; TotProb++; }
        }
			if ( CurContextInfo->TotCount > PPMI->FAI->FastArithCumProbMaxSafe )
				{
				CurNode->Count >>= 1;
				CurContextInfo->TotCount = CurNode->Count + 1;
				}

      if ( isExcluded(Exclusion,CurNode->Char) )
        {
        CurContextInfo->EscapeCount += EscpInc;
        CurContextInfo->TotCount += EscpInc;

        if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
          { PPMI->Error = 9; return(0); }
    
        CurContextInfo->TotCount += CharInc_Novel;
  
        PPMI->PPMZ_WriteC_Ptr = & ( CurNode->Char );  
  
        CurNode->Count = CharInc_Novel;
        CurNode->Next = CurContextInfo->Nodes;
        CurContextInfo->Nodes = CurNode;

        PPMI->DT_EscCounts[TableIndex] += DT_INC_E;
        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;
    
        return(0);
        }

      /* deterministic context. handle as a special case */

      FastArithDecodeRange(PPMI->FAI,&TargetProb,TotProb);

      if ( TargetProb < EscapeCount )
        {
        FastArithDecodeRangeRemove(PPMI->FAI,0,EscapeCount,TotProb);
        setExcluded(Exclusion,CurNode->Char);
        
        CurContextInfo->EscapeCount += EscpInc;
        CurContextInfo->TotCount += EscpInc;

        if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
          { PPMI->Error = 9; return(0); }
    
        CurContextInfo->TotCount += CharInc_Novel;
  
        PPMI->PPMZ_WriteC_Ptr = & ( CurNode->Char );  
  
        CurNode->Count = CharInc_Novel;
        CurNode->Next = CurContextInfo->Nodes;
        CurContextInfo->Nodes = CurNode;

        PPMI->DT_EscCounts[TableIndex] += DT_INC_E;
        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;
    
        return(0);
        }
      else
        {
        FastArithDecodeRangeRemove(PPMI->FAI,EscapeCount,TotProb,TotProb);

        CurNode->Count += CharInc;
        CurContextInfo->TotCount += CharInc;

        *SymbolPtr = CurNode->Char;

        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;

        return(1);
        }
      }

    TotProb = CurContextInfo->EscapeCount;
    NumCs = 0;
    while(CurNode)
      {
      if ( !isExcluded(Exclusion,CurNode->Char) ) { NumCs++; TotProb += CurNode->Count; }
      CurNode = CurNode->Next;
      }

    if ( PPMZ_ReadEsc(PPMI,CurContextInfo->EscapeCount,TotProb,NumCs,Context) )
      {
      CurNode = CurContextInfo->Nodes;
      while(CurNode)
        {
        if ( !isExcluded(Exclusion,CurNode->Char) )
					setExcluded(Exclusion,CurNode->Char);
        CurNode = CurNode->Next;
        }

      CurContextInfo->EscapeCount += EscpInc;
      CurContextInfo->TotCount += EscpInc;
    
      if ( CurContextInfo->TotCount >= PPMI->FAI->FastArithCumProbMax )
        {
        PPMZ_Scale(PPMI,CurContextInfo);
        }
    
      if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
        { PPMI->Error = 9; return(0); }
    
      CurContextInfo->TotCount += CharInc_Novel;
    
      PPMI->PPMZ_WriteC_Ptr = & ( CurNode->Char );  
  
      CurNode->Count = CharInc_Novel;
      CurNode->Next = CurContextInfo->Nodes;
      CurContextInfo->Nodes = CurNode;
    
      return(0);
      }
    else
      {
      TotProb -= CurContextInfo->EscapeCount;

      FastArithDecodeRange(PPMI->FAI,&TargetProb,TotProb);

      LowProb = 0;

      CurNode = CurContextInfo->Nodes;
      while(CurNode)
        {
        if ( !isExcluded(Exclusion,CurNode->Char) )
          {
          TargetProb -= CurNode->Count;
          if ( TargetProb < 0 )
            {
            HighProb = LowProb + CurNode->Count;
            FastArithDecodeRangeRemove(PPMI->FAI,LowProb,HighProb,TotProb);

            if ( CurNode->Count == CharInc_Novel && CurContextInfo->EscapeCount > EscpInc )
              {
              CurContextInfo->EscapeCount-= EscpInc; CurContextInfo->TotCount-= EscpInc;
              }
    
            CurNode->Count += CharInc;
            CurContextInfo->TotCount += CharInc;

            if ( CurContextInfo->TotCount >= PPMI->FAI->FastArithCumProbMax )
              {
              PPMZ_Scale(PPMI,CurContextInfo);
              }

            *SymbolPtr = CurNode->Char;

            return(1);
            }
          LowProb += CurNode->Count;
          }
        CurNode = CurNode->Next;
        }

      *SymbolPtr = 0x10000;
      PPMI->Error = 3;
      return(1);
      }
    }
  CurContextInfo = CurContextInfo->Next;
  }

if ( (CurContextInfo = GetPoolHunk(PPMI->ContextPool,1)) == NULL )
  { PPMI->Error = 9; return(0); }
if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
  { PPMI->Error = 9; return(0); }

PPMI->PPMZ_WriteC_Ptr = & ( CurNode->Char );  
CurNode->Count = CharInc_Novel;
CurNode->Next = NULL;

CurContextInfo->HOContext = HOContext;
CurContextInfo->TotCount = CharInc_Novel + EscpInc;
CurContextInfo->EscapeCount = EscpInc;
CurContextInfo->Nodes = CurNode;

CurContextInfo->Next=CurContextInfo->Prev=CurContextInfo->LRU_Next=CurContextInfo->LRU_Prev=NULL;

CONTEXT_ADDHEAD(CurContextInfo,CurIndex);
PPMZ_UpdateLRU(PPMI,CurContextInfo);

return(0);
}

void PPMZ_DecodeGotC(struct PPMZInfo * PPMI,uword GotC)
{

if ( PPMI->PPMZ_WriteC_Ptr == NULL )
  {
  PPMI->Error = 4;
  return;
  }

*(PPMI->PPMZ_WriteC_Ptr) = GotC;

PPMI->PPMZ_WriteC_Ptr = NULL;

}

void PPMZ_CleanUp(struct PPMZInfo * PPMI)
{
if (! PPMI ) return;

if ( PPMI->MyPools ) PPMZ_FreePools(PPMI->MyPools);

#ifdef STATS
if ( PPMI->Stats_NumSeen )
  {
  printf("--------------------------\n");
  if ( PPMI->Stats_NumDeterm )
    {
    printf("N:Seen:%6ld Coded:%6ld Got:%6ld Esc:%6ld Det:%ld D2:%ld Else:%ld DMC:%ld\n",
      PPMI->Stats_NumSeen,PPMI->Stats_NumGot+PPMI->Stats_NumEscaped,
       PPMI->Stats_NumGot,PPMI->Stats_NumEscaped,PPMI->Stats_NumDeterm,
        PPMI->Stats_NumDeterm2,PPMI->Stats_NumElse,PPMI->Stats_NumDetMaxCnt);
  
    if ( PPMI->Stats_NumDeterm > 0 )
      {
      long * DetAvg;
      int i,j,k;
      
      if ( DetAvg = malloc(sizeof(long)*DT_NUMCOUNTS) )
        {
  
        for(i=1;i<DT_NUMCOUNTS;i++)
          DetAvg[i] = 0;
        
        for(j=0;j<NUM_O1_CHARS;j++)
          {
          for(i=1;i<DT_NUMCOUNTS;i++)
            {
            k = (i<<DTSX_BITS) + j;
            DetAvg[i] += PPMI->DT_TotCounts[k] * 2 / PPMI->DT_EscCounts[k];
            }
          }
        
        printf(" DetVals: ");
        for(i=1;i<DT_NUMCOUNTS;i++)
          {
          DetAvg[i] /= NUM_O1_CHARS*2;
          printf("%d,",DetAvg[i]);
          }
        printf("\n");

        }
      
      }

    if ( PPMI->Stats_NumDeterm2 > 0 )
      {
      long * DetAvg;
      int i,j,k;

      if ( DetAvg = malloc(sizeof(long)*DT2_NUMCOUNTS) )
        {
        for(i=0;i<DT2_NUMCOUNTS;i++)
          DetAvg[i] = 0;
        
        for(j=0;j<DT2_NUM_O1_CHARS;j++)
          {
          for(i=0;i<DT2_NUMCOUNTS;i++)
            {
            k = (i<<DT2SX_BITS) + j;
            DetAvg[i] += PPMI->DT2_TotCounts[k] * 2 / PPMI->DT2_EscCounts[k];
            }
          }
        
        printf(" DT2Vals: ");
        for(i=0;i<DT2_NUMCOUNTS;i++)
          {
          DetAvg[i] /= DT2_NUM_O1_CHARS*2;
          printf("%d,",DetAvg[i]);
          }
        printf("\n");
        }     
      }

    }
  else
    {
    printf("N:Seen:%6ld Coded:%6ld Got:%6ld Esc:%6ld\n",
      PPMI->Stats_NumSeen,PPMI->Stats_NumGot+PPMI->Stats_NumEscaped,
        PPMI->Stats_NumGot,PPMI->Stats_NumEscaped);
    }
  }
#endif /* STATS */

smartfree(PPMI->DT_EscCounts);
smartfree(PPMI->DT_TotCounts);
smartfree(PPMI->DT2_EscCounts);
smartfree(PPMI->DT2_TotCounts);

free(PPMI);
}


void PPMZ_UpdateEsc(struct PPMZInfo * PPMI,long EscP,long TotP,long NumC,ulong Context,bool DoEsc)
{

if ( TotP == EscP || NumC == 0 )
  {
  if ( ! DoEsc ) PPMI->Error = 1;
  return;
  }
if ( EscP == 0 )
  {
  if ( DoEsc ) PPMI->Error = 2;
  return;
  }

if ( PPMI->DoDT2 && NumC <= 2 )
  {
  int I;
  I = DT2HASH(EscP,TotP,Context);

#ifdef STATS
  PPMI->Stats_NumDeterm2++;
#endif

  if ( PPMI->DT2_TotCounts[I] > DT2_MINCNT )
    {
    if ( PPMI->DT2_TotCounts[I] > PPMI->FAI->FastArithCumProbMaxSafe )
      { PPMI->DT2_EscCounts[I] >>= 1; PPMI->DT2_TotCounts[I] >>= 1; }
  
    if ( PPMI->DT2_EscCounts[I] == 0 || PPMI->DT2_TotCounts[I] <= PPMI->DT2_EscCounts[I] )
      { PPMI->DT2_EscCounts[I] ++; PPMI->DT2_TotCounts[I] += 2; }
  
    EscP = PPMI->DT2_EscCounts[I];
    TotP = PPMI->DT2_TotCounts[I];

    if ( DoEsc )
      {
      PPMI->DT2_EscCounts[I] += DT2_INC_E;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    else
      {
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    }
  else
    {
    if ( DoEsc )
      {
      PPMI->DT2_EscCounts[I] += DT2_INC_E;
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    else
      {
      PPMI->DT2_TotCounts[I] += DT2_INC_T;
      }
    }

  return;
  }

#ifdef STATS
PPMI->Stats_NumElse++;
#endif

}

bool PPMZ_UpdateC(struct PPMZInfo * PPMI,long Symbol,ulong Context,ulong HOContext)
{
struct PPMZ_ContextIndex *CurIndex,*PrevIndex;
struct PPMZ_ContextInfo *CurContextInfo;
struct PPMZ_Node *CurNode;
long Hash;

#ifdef STATS
PPMI->Stats_NumSeen++;
#endif /* STATS */

if ( PPMI->DoLRU ) PPMZ_CheckLRU(PPMI);

Hash = PPMHASH(Context);

/** find a context index **/

PrevIndex = NULL;
CurIndex = PPMI->ContextIndeces[Hash];
while(CurIndex)
  {
  if ( CurIndex->Context == Context )
    {
#ifdef DO_MTF
    if ( PrevIndex )
      {
      /* MTF */
      PrevIndex->Next = CurIndex->Next;
      CurIndex->Next = PPMI->ContextIndeces[Hash];
      PPMI->ContextIndeces[Hash] = CurIndex;
      }
#endif
    goto PPMZ_Encode_FoundCurIndex;
    }
  PrevIndex = CurIndex;
  CurIndex = CurIndex->Next;
  }

/* index not found */
if ( (CurIndex = GetPoolHunk(PPMI->IndexPool,1)) == NULL )
  { PPMI->Error = 9; return(0); }
CurIndex->Context = Context;
CurIndex->Next = PPMI->ContextIndeces[Hash];
PPMI->ContextIndeces[Hash] = CurIndex;
CurIndex->ContextList = NULL;

/***/
  PPMZ_Encode_FoundCurIndex:
/***/

CurContextInfo = CurIndex->ContextList;
while(CurContextInfo)
  {
  if ( CurContextInfo->HOContext == HOContext )
    {
    long TotProb,NumCs;
 
    /*** got context ***/

		CONTEXT_MTF(CurContextInfo,CurIndex);
		PPMZ_UpdateLRU(PPMI,CurContextInfo);

    CurNode = CurContextInfo->Nodes;

    if ( PPMI->DoDT && CurNode && CurNode->Next == NULL )
      {  /* deterministic context */
      long TableIndex;
      long EscapeCount;

#ifdef STATS
PPMI->Stats_NumDeterm++;
if ( CurNode->Count >= HIGH_DETERM_COUNT )
  PPMI->Stats_NumDetMaxCnt++;
#endif

      TableIndex = min(CurNode->Count,HIGH_DETERM_COUNT);
      TableIndex <<= DTSX_BITS;
      TableIndex += (Context&O1_MASK);

      if ( PPMI->DT_TotCounts[TableIndex] > PPMI->FAI->FastArithCumProbMaxSafe )
        {
        PPMI->DT_TotCounts[TableIndex] >>= 1;
        PPMI->DT_EscCounts[TableIndex] >>= 1;
        if ( ! PPMI->DT_EscCounts[TableIndex] )
          {
          PPMI->DT_EscCounts[TableIndex] ++;
          PPMI->DT_TotCounts[TableIndex] ++;
          }
        }

      EscapeCount = PPMI->DT_EscCounts[TableIndex];
      TotProb     = PPMI->DT_TotCounts[TableIndex];

      if ( TotProb < DT_MINCNT )
        { EscapeCount = 1; TotProb = 1 + CurNode->Count; }

      if ( CurContextInfo->TotCount > PPMI->FAI->FastArithCumProbMaxSafe )
        {
        CurNode->Count            >>= 1;
        CurContextInfo->TotCount  >>= 1;
        }

      if ( CurNode->Char == Symbol )
        {
        CurNode->Count            += CharInc;
        CurContextInfo->TotCount  += CharInc;

        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;

#ifdef STATS
PPMI->Stats_NumGot++;
#endif /* STATS */

        return(1);
        }
      else
        {

#ifdef STATS
PPMI->Stats_NumEscaped++;
#endif /* STATS */
        
        CurContextInfo->EscapeCount += EscpInc;
        CurContextInfo->TotCount    += EscpInc;

        PPMI->DT_EscCounts[TableIndex] += DT_INC_E;
        PPMI->DT_TotCounts[TableIndex] += DT_INC_T;

        if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
          { PPMI->Error = 9; return(0); }
    
        CurContextInfo->TotCount += CharInc_Novel;
    
        CurNode->Char = Symbol;
        CurNode->Count = CharInc_Novel;
        CurNode->Next = CurContextInfo->Nodes;
        CurContextInfo->Nodes = CurNode;

        return(0);
        }
      }
    
    NumCs=0;
    TotProb = CurContextInfo->EscapeCount;
    while(CurNode)
      {
      if ( CurNode->Char == Symbol )
        {
        struct PPMZ_Node *GotNode;
        long LowProb,HighProb;
  
        NumCs++;  
        LowProb = TotProb;
        TotProb = HighProb = TotProb + CurNode->Count;
        GotNode = CurNode;

        CurNode = CurNode->Next;
        while(CurNode)
          {
          NumCs++; TotProb += CurNode->Count;
          CurNode = CurNode->Next;
          }
        CurNode = GotNode;
  
        PPMZ_UpdateEsc(PPMI,CurContextInfo->EscapeCount,TotProb,NumCs,Context,0);
        LowProb -= CurContextInfo->EscapeCount;
        HighProb -= CurContextInfo->EscapeCount;
        TotProb -= CurContextInfo->EscapeCount;

        if ( CurNode->Count == CharInc_Novel && CurContextInfo->EscapeCount > EscpInc )
          {
          CurContextInfo->EscapeCount -= EscpInc;
          CurContextInfo->TotCount -= EscpInc;
          }
  
        CurNode->Count += CharInc;
        CurContextInfo->TotCount += CharInc;

        if ( CurContextInfo->TotCount >= PPMI->FAI->FastArithCumProbMax )
          PPMZ_Scale(PPMI,CurContextInfo);
  
#ifdef STATS
PPMI->Stats_NumGot++;
#endif /* STATS */

        return(1);
        }
      NumCs++;
      TotProb += CurNode->Count;
      CurNode = CurNode->Next;
      }

#ifdef STATS
PPMI->Stats_NumEscaped++;
#endif /* STATS */

    /** char not found in list **/

    PPMZ_UpdateEsc(PPMI,CurContextInfo->EscapeCount,TotProb,NumCs,Context,1);
  
    CurContextInfo->EscapeCount += EscpInc;
    CurContextInfo->TotCount += EscpInc;
  
    if ( CurContextInfo->TotCount >= PPMI->FAI->FastArithCumProbMax )
      {
      PPMZ_Scale(PPMI,CurContextInfo);
      }
  
    if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
      { PPMI->Error = 9; return(0); }
  
    CurContextInfo->TotCount += CharInc_Novel;
  
    CurNode->Char = Symbol;
    CurNode->Count = CharInc_Novel;
    CurNode->Next = CurContextInfo->Nodes;
    CurContextInfo->Nodes = CurNode;
  
    return(0);
    }
  CurContextInfo = CurContextInfo->Next;
  }

/** context not found **/

if ( (CurContextInfo = GetPoolHunk(PPMI->ContextPool,1)) == NULL )
  { PPMI->Error = 9; return(0); }
if ( (CurNode = GetPoolHunk(PPMI->NodePool,1)) == NULL )
  { PPMI->Error = 9; return(0); }

CurNode->Char = Symbol;
CurNode->Count = CharInc_Novel;
CurNode->Next = NULL;

CurContextInfo->HOContext = HOContext;
CurContextInfo->TotCount = CharInc_Novel + EscpInc;
CurContextInfo->EscapeCount = EscpInc;
CurContextInfo->Nodes = CurNode;
CurContextInfo->Next = CurContextInfo->Prev = CurContextInfo->LRU_Next = CurContextInfo->LRU_Prev = NULL;

CONTEXT_ADDHEAD(CurContextInfo,CurIndex);
PPMZ_UpdateLRU(PPMI,CurContextInfo);

return(0);
}


#define ESC_SCALE (1<<12)

ulong PPMZ_TellEscP(struct PPMZInfo * PPMI,long EscP,long TotP,long NumC,ulong Context)
{

if ( PPMI->DoDT2 && NumC <= 2 )
  {
  int I;
  I = DT2HASH(EscP,TotP,Context);

  if ( PPMI->DT2_TotCounts[I] > DT2_MINCNT )
    {
    return( ((ulong) PPMI->DT2_EscCounts[I] * ESC_SCALE) /
      PPMI->DT2_TotCounts[I] );
    }
  }

return( ((ulong)ESC_SCALE*EscP)/TotP );
}

void PPMZ_GetInfo(struct PPMZInfo * PPMI,ulong Context,ulong HOContext,
  ulong * MPS_P_ptr,ulong * Esc_P_ptr)
{
struct PPMZ_ContextIndex *CurIndex,*PrevIndex;
struct PPMZ_ContextInfo *CurContextInfo;
struct PPMZ_Node *CurNode;
long Hash;
ulong MPS_P,Esc_P;

*MPS_P_ptr = ESC_SCALE/128;
*Esc_P_ptr = ESC_SCALE/2;

Hash = PPMHASH(Context);

/** find a context index **/

PrevIndex = NULL;
CurIndex = PPMI->ContextIndeces[Hash];
if ( !CurIndex) return;
while( CurIndex->Context != Context )
  {
  PrevIndex = CurIndex;
  CurIndex = CurIndex->Next;
  if ( !CurIndex) return;
  }

#ifdef DO_MTF
if ( PrevIndex )
  {
  /* MTF */
  PrevIndex->Next = CurIndex->Next;
  CurIndex->Next = PPMI->ContextIndeces[Hash];
  PPMI->ContextIndeces[Hash] = CurIndex;
  }
#endif

CurContextInfo = CurIndex->ContextList;
if ( !CurContextInfo ) return;
while(CurContextInfo->HOContext != HOContext)
  {
  CurContextInfo = CurContextInfo->Next;
  if ( !CurContextInfo ) return;
  }

CONTEXT_MTF(CurContextInfo,CurIndex);

CurNode = CurContextInfo->Nodes;

if ( PPMI->DoDT && CurNode && CurNode->Next == NULL )
  {
  long TableIndex;
  long EscapeCount,TotProb;

  TableIndex = min(CurNode->Count,HIGH_DETERM_COUNT);
  TableIndex <<= DTSX_BITS;
  TableIndex += (Context&O1_MASK);

  EscapeCount = PPMI->DT_EscCounts[TableIndex];
  TotProb     = PPMI->DT_TotCounts[TableIndex];

  if ( TotProb < DT_MINCNT )
    { EscapeCount = 1; TotProb = 1 + CurNode->Count; }

    {
    long i,j;
    
    for(i=((TableIndex>>DTSX_BITS)-1);i>=1;i--)
      {
      j = (i<<DTSX_BITS)+(Context&O1_MASK);
      if ( PPMI->DT_TotCounts[j] > DT_MINCNT )
        {
        if ( (PPMI->DT_TotCounts[j]/PPMI->DT_EscCounts[j]) > 
              (TotProb/EscapeCount) )
          {
          TotProb += PPMI->DT_TotCounts[j];
          EscapeCount += PPMI->DT_EscCounts[j];
          }
        }
      }
    }

  Esc_P = EscapeCount*ESC_SCALE/TotProb;
  MPS_P = ESC_SCALE;
  }
else
  {
  struct PPMZ_Node * MPS_Node;
  int NumCs=0;

  MPS_Node = CurNode;

  while(CurNode)
    {
    if ( CurNode->Count > MPS_Node->Count ) MPS_Node = CurNode;
    NumCs++;
    CurNode = CurNode->Next;
    }

  Esc_P = PPMZ_TellEscP(PPMI,CurContextInfo->EscapeCount,
    CurContextInfo->EscapeCount + CurContextInfo->TotCount,NumCs,Context);

  MPS_P = MPS_Node->Count*ESC_SCALE/CurContextInfo->TotCount;
  }

*MPS_P_ptr = MPS_P * ( ESC_SCALE - Esc_P ) / ESC_SCALE;
*Esc_P_ptr = Esc_P;

return;
}


/*********

	FingerPrint is a useful debugging tool.  It makes 32-bit CRC of the PPMZ data structure.
	After N bytes, the encoder and decoder should have the same fingerprint.

	Note that FingerPrint is quite slow because it had to walk all over in the data structure.

***********/

ulong PPMZ_FingerPrint(struct PPMZInfo * PPMI)
{
struct PPMZ_ContextIndex *CurIndex;
struct PPMZ_ContextInfo *CurInfo;
struct PPMZ_Node *CurNode;
long Hash;
ulong C;
ulong NumNodes=0,NumInfos=0,NumIndeces=0;

C = PPMI->NodePool->NumItemsActive; /* seed */

CRC_START(C);

for(Hash=0;Hash<PPMHASHMEMBERS;Hash++)
	{
	CurIndex = PPMI->ContextIndeces[Hash];
	while(CurIndex)
		{

		C = addcrcl(C,CurIndex->Context);

		CurInfo = CurIndex->ContextList;
		while(CurInfo)
			{

			C = addcrcl(C,CurInfo->HOContext);
			C = addcrcw(C,CurInfo->TotCount);
			C = addcrcw(C,CurInfo->EscapeCount);

			CurNode = CurInfo->Nodes;
			while(CurNode)
				{

				C = addcrcw(C,CurNode->Char);
				C = addcrcw(C,CurNode->Count);

				NumNodes++;
				CurNode = CurNode->Next;
				}
			NumInfos++;
			CurInfo = CurInfo->Next;
			}
		NumIndeces++;
		CurIndex = CurIndex->Next;
		}
	}

/* interesting debug info in Num#? */

C = addcrcl(C,NumIndeces);
C = addcrcl(C,NumInfos);
C = addcrcl(C,NumNodes);

CRC_FINISH(C);

return(C);
}

