/*
 * dezip3.c - sample code to deflate first file in a .zip archive
 *
 * This code demonstrates how to use zipio.h to read a zip file.
 */

#include <stdio.h>
#include <stdlib.h>

#ifdef BENCHMARK
#include <time.h>
#endif

#include "zipio.h"

int main(int argc, char **argv)
{
  ZFILE *inp;
  FILE  *out;

  int inpchr;

#ifdef BENCHMARK
  long total;
  clock_t t1, t2;
#endif
  
  /* check number of arguments */
  if (argc != 3)
  {
    fprintf(stderr, "Usage: dezip3 input.zip output.dat\n");
    return 1;
  }

  /* open the input file */
  inp = zopen(argv[1], "rb");

  if (!inp)
  {
    fprintf(stderr, "Error return from zopen(%s)\n", argv[1]);
    return 1;
  }

  /* open the output file */
  out = fopen(argv[2], "wb");

  if (!out)
  {
    fprintf(stderr, "Error return from fopen(%s)\n", argv[2]);
    return 1;
  }

#ifdef BENCHMARK  
  total = 0;
  t1 = clock();
#endif

  while((inpchr = zgetc(inp)) >= 0)
  {
#ifdef BENCHMARK
    total++;
#else
    if (putc(inpchr, out) < 0)
    {
      fprintf(stderr, "Error return from putc\n");
      return 1;
    }
#endif
  }

#ifdef BENCHMARK
  t2 = clock();
  printf("Transfer rate %ld bytes per second\n",total*((long) CLK_TCK)/(t2-t1));
#endif

  zclose(inp);
  fclose(out);

  return 0;
}
