/*
 * dezip4.c - sample code to get the names of all files in a zip file
 *
 * This code demonstrates how to use zipio.h to do this.
 */

#include <stdio.h>
#include <stdlib.h>

#include "zipio.h"

int main(int argc, char **argv)
{
  ZFILE *inp;
  char *name;

  /* check number of arguments */
  if (argc != 2)
  {
    fprintf(stderr, "Usage: dezip3 input.zip\n");
    return 1;
  }

  /* open the input file */
  inp = zopen(argv[1], "rb");

  if (!inp)
  {
    fprintf(stderr, "Error return from zopen(%s)\n", argv[1]);
    return 1;
  }

  while((name = zname(inp)) != NULL)
  {
    if (zerror(inp))
      fprintf(stderr, "%s (unsupported compression type)\n", name);
    else
      fprintf(stderr, "%s\n", name);

    znext(inp);
  }

  zclose(inp);

  return 0;
}
