#ifndef lint
static char rcsid[] = "$Header: /usr/people/sam/tiff/libtiff/RCS/tif_msdos.c,v 1.7 93/08/25 09:29:44 sam Exp $";
#endif

/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992 Sam Leffler
 * Copyright (c) 1991, 1992 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*
 * TIFF Library MSDOS-specific Routines.
 */

#include <windows.h>
#pragma hdrstop

#include <stdlib.h>

#include "tiffiop.h"
#include "zipio.h"

#define READSIZE 16384

/*
 * This structure is used to determine at run-time whether to
 * use the stdio routines or zipio routines.
 */

struct Handle {
  ZFILE *zh;
   FILE *fh;
};

#define ZH (((Handle *) handle)->zh)
#define FH (((Handle *) handle)->fh)

static tsize_t
_tiffReadProc(thandle_t handle, tdata_t buf, tsize_t size)
{
  tsize_t total;

  total = 0;

  while (total < size)
  {
    size_t ret, len;

    len = READSIZE;
    if (len > (size_t) (size-total))
        len = (size_t) (size-total);

    if (ZH)
      ret = zread(buf, 1,  len, ZH);
    else
      ret = fread(buf, 1,  len, FH);

    if (ret == 0) break;

    total += ret;
    buf = (tdata_t) (((tidata_t) buf) + ret);
  }

  return total;
}

static tsize_t
_tiffWriteProc(thandle_t handle, tdata_t buf, tsize_t size)
{
  tsize_t total;

  total = 0;

  while (total < size)
  {
    size_t ret, len;

    len = READSIZE;
    if (len > (size_t) (size-total))
        len = (size_t) (size-total);

    if (ZH)
      return 0; /* zwrite() not implemented yet */
    else
      ret = fwrite(buf, 1,  len, FH);

    if (ret == 0) break;

    total += ret;
    buf = (tdata_t) (((tidata_t) buf) + ret);
  }

  return total;
}

static toff_t
_tiffSeekProc(thandle_t handle, toff_t off, int whence)
{
  toff_t offset;

  if (ZH)
  {
    zseek(ZH, (long) off, whence);
    offset = (toff_t) ztell(ZH);
  }
  else
  {
    fseek(FH, (long) off, whence);
    offset = (toff_t) ftell(FH);
  }

  return offset;
}

static int
_tiffCloseProc(thandle_t handle)
{
  int ret;

  if (ZH)
    ret = zclose(ZH);
  else
    ret = fclose(FH);

  free((void *) handle);

  return ret;
}

static toff_t
_tiffSizeProc(thandle_t handle)
{
  long curr, size;

  if (ZH)
  {
    curr = ztell(ZH);
    zseek(ZH, 0, SEEK_END);
    size = ztell(ZH);
    zseek(ZH, curr, SEEK_SET);
  }
  else
  {
    curr = ftell(FH);
    fseek(FH, 0, SEEK_END);
    size = ftell(FH);
    fseek(FH, curr, SEEK_SET);
  }

  return (toff_t) size;
}

static int
_tiffMapProc(thandle_t fd, tdata_t* pbase, toff_t* psize)
{
  return (0);
}

static void
_tiffUnmapProc(thandle_t fd, tdata_t base, toff_t size)
{
}

/*
 * Open a TIFF file descriptor for read/writing.
 */

TIFF*
TIFFZopen(void *zh, const char* name, const char* mode)
{
  TIFF* tif;

  void *handle;

  handle = malloc(sizeof(Handle));
  if (!handle)
    return ((TIFF*)0);

  ZH = (ZFILE *) zh;
  FH = NULL;

  tif = TIFFClientOpen(name, mode,
                       handle,
                       _tiffReadProc, _tiffWriteProc, _tiffSeekProc,
                       _tiffCloseProc, _tiffSizeProc, _tiffMapProc,
                       _tiffUnmapProc);
  return (tif);
}

TIFF*
TIFFFopen(void *fh, const char* name, const char* mode)
{
  TIFF* tif;

  void *handle;

  handle = malloc(sizeof(Handle));
  if (!handle)
    return ((TIFF*)0);

  ZH = NULL;
  FH = (FILE *) fh;

  tif = TIFFClientOpen(name, mode,
                       handle,
                       _tiffReadProc, _tiffWriteProc, _tiffSeekProc,
                       _tiffCloseProc, _tiffSizeProc, _tiffMapProc,
                       _tiffUnmapProc);
  return (tif);
}

/*
 * Open a TIFF file for read/writing.
 */
TIFF*
TIFFOpen(const char* name, const char* mode)
{
  static const char module[] = "TIFFOpen";
  int m;

  ZFILE *zh;
   FILE *fh;

  m = _TIFFgetMode(mode, module);
  if (m == -1)
    return ((TIFF*)0);

  zh = NULL;
  fh = NULL;

  if (mode[0] == 'r')
  {
    zh = zopen(name, "rb");
  }
  else
  {
    fh = fopen(name, mode);
  }

  if (!zh && !fh) {
    TIFFError(module, "%s: Cannot open", name);
    return ((TIFF*)0);
  }

  if (zh)
    return (TIFFZopen((void *) zh, name, mode));
  else
    return (TIFFFopen((void *) fh, name, mode));
}

#ifdef __GNUC__
extern  char *malloc();
extern  char *realloc();
#else
#include <malloc.h>
#endif

void *
_TIFFmalloc(tsize_t s)
{
#if defined(__WIN32__)
  return (   malloc(s));
#else
  return (farmalloc(s));
#endif
}

void
_TIFFfree(void* p)
{
#if defined(__WIN32__)
  free(p);
#else
  farfree(p);
#endif
}

void *
_TIFFrealloc(void* p, tsize_t s)
{
#if defined(__WIN32__)
  return (   realloc(p, s));
#else
  return (farrealloc(p, s));
#endif
}
