/* buffer.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <ctype.h>
#include "buffer.h"

#define FALSE    0
#define TRUE     !FALSE
#define CR       13
#define LF       10
#define ONE_SEC  18

#define NBR_LINES   6
#define COL_WIDTH  55
#define NBR_CHANS  16

typedef struct ChanTag
{int Row;
 int Col;
 char *Line[NBR_LINES];
} ChanBufType;

static ChanBufType *ChanData[NBR_CHANS];
static NbrChannels = 0;

void BufferInit(int NbrChans)
{int i, n;
 char *Ptr;
 ChanBufType *ChanPtr;
 NbrChannels = NbrChans;
 for(i=0;i<NbrChans;i++)
   {/* allocate memory for channel */
    ChanPtr = (ChanBufType *) malloc(sizeof(struct ChanTag));
    if(Ptr==NULL)
      {puts("Cannot malloc (1)");
       exit(1);
      }
    ChanData[i] = ChanPtr;
    ChanPtr->Row = 0;
    ChanPtr->Col = 0;
    for(n=0;n<NBR_LINES;n++)
      {/* allocate memory */
       Ptr = (char *) malloc(1 + COL_WIDTH);
       if(Ptr==NULL)
         {puts("Cannot malloc (2)");
          exit(1);
         }
       ChanPtr->Line[n] = Ptr;
       *ChanPtr->Line[n] = '\0';
      }
   }
}

void BufferScroll(int Chan)
{int n;
 int Row;
 char *Ptr;
 ChanBufType *ChanPtr;
 ChanPtr = ChanData[Chan];
 Row = ChanPtr->Row;
 if(Row==0) return;
 Ptr = ChanPtr->Line[0];
 for(n=0;n<Row;n++)
   ChanPtr->Line[n] = ChanPtr->Line[n+1];
 ChanPtr->Line[Row] = Ptr;
 *Ptr = '\0';
 ChanPtr->Col = 0;
}

void BufferAppend(int Chan,char Chr)
{int Row;
 int Col;
 char *Ptr;
 ChanBufType *ChanPtr;
 ChanPtr = ChanData[Chan];
 Row = ChanPtr->Row;
 Col = ChanPtr->Col;
 if(Chr=='\n')
   {/* force new line */
    if(Row == NBR_LINES-1)
      {/* scroll ! */
       BufferScroll(Chan);
      }
    else Row++;
    Col = 0;
    Ptr = ChanPtr->Line[Row]+Col;
    *Ptr = '\0';
    ChanPtr->Col = Col;
    ChanPtr->Row = Row;
    return;
   }
 if(Col<COL_WIDTH-1)
   {/* append to end of current row */
    Ptr = ChanPtr->Line[Row]+Col;
    *Ptr++ = Chr;
    *Ptr++ = '\0';
    ChanPtr->Col = Col + 1;
    return;
   }
 /* next line */
 if(Row == NBR_LINES)
   {/* scroll ! */
    BufferScroll(Chan);
   }
 else Row++;
 /* place char at start of new row  */
 Col = 0;
 Ptr = ChanPtr->Line[Row]+Col;
 *Ptr++ = Chr;
 *Ptr = '\0';
 ChanPtr->Col = Col;
 ChanPtr->Row = Row;
 return;
}

char BufferChar(int Chan,int Row,int Col)
{ChanBufType *ChanPtr;
 /* return char at (Row,Col) */
 ChanPtr = ChanData[Chan];
 return *(ChanPtr->Line[Row]+Col);
}

char *BufferLine(int Chan,int Row)
{ChanBufType *ChanPtr;
 /* return pointer to Line[Row] */
 ChanPtr = ChanData[Chan];
 return ChanPtr->Line[Row];
}

int BufferRow(int Chan)
{ChanBufType *ChanPtr;
 /* return Row */
 ChanPtr = ChanData[Chan];
 return ChanPtr->Row;
}

int BufferCol(int Chan)
{ChanBufType *ChanPtr;
 /* return Row */
 ChanPtr = ChanData[Chan];
 return ChanPtr->Col;
}

void BufferBack(int Chan)
{int Col;
 char *Ptr;
 ChanBufType *ChanPtr;
 ChanPtr = ChanData[Chan];
 Col = ChanPtr->Col;
 if(Col>0)
   {/* back up one space */
    Ptr = ChanPtr->Line[ChanPtr->Row];
    ChanPtr->Col = Col - 1;
    Ptr[Col] = '\0';
   }
}

void BufferDump(int Chan)
{int i;
 ChanBufType *ChanPtr;
 ChanPtr = ChanData[Chan];
 printf("# Chan=%d, ChanPtr=%x:%x ",Chan,FP_SEG(ChanPtr),FP_OFF(ChanPtr));
 printf("# Row=%d, Col=%d\n",ChanPtr->Row,ChanPtr->Col);
 for(i=0;i<NBR_LINES;i++)
   printf("#  %d: [%s]\n", i, ChanPtr->Line[i]);
}
