/*  dir_io.c
**
**  Compiler and memory model independent implementation of
**  the the DOS "ChDir" command.
*/

#include <stdio.h>
#include <dos.h>

#include "dir_io.h"

#define FALSE 0
#define TRUE !FALSE

#define BYTE unsigned char
#define WORD unsigned int

int ChDir(char *FileSpec)
{union  REGS  reg;
 struct SREGS sreg;
 char far *Ptr;
 Ptr = (char far *)FileSpec;
 reg.x.dx = (WORD) FP_OFF(Ptr);
 sreg.ds  = (WORD) FP_SEG(Ptr);
 reg.h.ah = 0x3b;
 int86x(0x21, &reg, &reg, &sreg);
 if(reg.x.cflag) return FALSE;
 return TRUE;
}
