/*  find.c
**
**  Compiler and memory model independent implementation of
**  the DOS "FindFirst" and "FindNext" commands.
*/

#include <stdio.h>
#include <dos.h>
#include <string.h>

#include "find.h"

#define FALSE 0
#define TRUE !FALSE

#define BYTE unsigned char
#define WORD unsigned int

typedef struct DTAbufferType
{BYTE Reserved[21];
 BYTE Attribute;
 WORD Time;
 WORD Date;
 long Size;
 BYTE Name[13];
 BYTE Junk[85];
} DTAbufferType;

static DTAbufferType DTA1buffer;
static DTAbufferType DTA2buffer;

static DTAbufferType far *Ptr1 = &DTA1buffer;
static DTAbufferType far *Ptr2 = &DTA2buffer;

static void dosSetDTA(int which)
{union REGS reg;
 struct SREGS sreg;
 switch(which)
   {case 1:
      reg.x.dx = (WORD) FP_OFF(Ptr1);
      sreg.ds  = (WORD) FP_SEG(Ptr1);
      break;
    case 2:
      reg.x.dx = (WORD) FP_OFF(Ptr2);
      sreg.ds  = (WORD) FP_SEG(Ptr2);
      break;
   }
 reg.h.ah = 0x1A;
 int86x(0x21, &reg, &reg, &sreg);
}

static int dosFindFirst(char *FileSpec)
{union  REGS  reg;
 struct SREGS sreg;
 char far *Ptr;
 Ptr = (char far *)FileSpec;
 reg.x.dx = (WORD) FP_OFF(Ptr);
 sreg.ds  = (WORD) FP_SEG(Ptr);
 reg.h.ah = 0x4e;
 reg.x.cx = 0;
 int86x(0x21, &reg, &reg, &sreg);
 if(reg.x.cflag) return FALSE;
 return TRUE;
}

static int dosFindNext(void)
{union REGS reg;
 reg.h.ah = 0x4f;
 int86(0x21, &reg, &reg);
 if(reg.x.cflag) return FALSE;
 return TRUE;
}


int FindFirst(char *Specifier,char *Name,long *Size)
{dosSetDTA(1);
 if(dosFindFirst(Specifier))
   {if(Name) strncpy(Name,DTA1buffer.Name,13);
    if(Size) *Size = DTA1buffer.Size;
    return TRUE;
   }
 return FALSE;
}

int FindNext(char *Name,long *Size)
{dosSetDTA(1);
 if(dosFindNext())
   {strncpy(Name,DTA1buffer.Name,13);
    if(Size) *Size = DTA1buffer.Size;
    return TRUE;
   }
 return FALSE;
}

int FileSDT(char *Name,long *Size,WORD *Date,WORD *Time)
{dosSetDTA(2);
 if(dosFindFirst(Name))
   {*Size = DTA2buffer.Size;
    *Date = DTA2buffer.Date;
    *Time = DTA2buffer.Time;
    return TRUE;
   }
 return FALSE;
}
