/*

      bfile.h
      Btrieve class for Borland C++
      09/06/91

      Douglas J. Reilly
      Access Microsystems Inc.
      404 Midstreams Road
      Brick, New Jersey  08724
      (908) 892-2683
      CompuServe 74040,607

      Comments?  Questions?  Suggestions?
      Have a paying C/C++ programming job you need done?
      Give me a call.

      Released into the public domain.  Do with it as you see fit, but
      if you do anything really neat with it, let me know...

*/

#ifndef BFILE_H
#define BFILE_H
#include "btrieve.h"
extern "C" {
int BTRV(int ,char *,char *,int *,char *,int );
}

class bfile {
   char pos_blk[128];        // position block
   char fname[64];           // physical file name
   char logical_name[10];    // logical file name (not used yet)
   int  mode;                // open mode
   int  rec_len;             // record len
   int  key_num;             // current key number
   int  status;              // error status
   int  opened;              // opened flag, not really essential because data
                             //   seemed like it was as natural a flag
                             //   as possible, since we don't want to write
                             //   data to null.
   char *data;               // The data, of course...
   char owner[60];           // owner of the file, used for secured files.
public:
  // file name, lenght, owner, and open mode
  // Note that constructor opens file.
   bfile(char *name,int len,char *towner=0,int newmode=0);
   ~bfile();
  // Close file, free up data pointer above.
   int  close();
  // Open, really SB reopen I guess since only useful after close...
   int  open(int newmode=-1);
  // Gets a record.  Uses key 0 unless you set key number (below).
   int  get_rec(char *keystr,int op=B_GET_EQ);
  // Self explanatory...
   void set_key_num(int key=0)
        {
           key_num=key;
        }
  // take newdata and copy it into the data element.
   int  set_data(char *newdata)
        {
           if ( data!=NULL )
           {
              memcpy(data,newdata,rec_len);
              return(1);
           }
           return(0);
        }
  // return pointer to data.
   char *get_data()
        {
           return data;
        }
  // Insert or update record.  could make seperate functions to force one
  //   or the other.  I prefer this.
   int  put_rec(char *keystr,int =0);
  // self explanatory...
   int  del_rec(char *keystr);
  // allow user to get status after operation.
   int  get_status(){ return status; }
};
#endif
