/*C4*/
//****************************************************************
//	Author:	Jethro Wright, III 			TS :  1/20/1994 18:19
//	Date:	01/01/1994
//
//			cdx.cpp :	main module for the cdx (cd exerciser)
//			pgm which demos the audio cd fn of mscdex....
//
//	History:
//		01/01/1994  jw3	 also sprach zarathrustra....
//****************************************************************/


#include 		<stdio.h>
#include		<stdlib.h>
#include		<ctype.h>

			//
			//	if you want to change the order of these #includes
			//	then you must change the contents and the other sources
			//	that depend on them as well....
			//

#include		"types.h"				// some simple utility types
#include		"device.h"				// device driver related structures
#include		"ioctl.hpp"				// not used here, but the next does
#include		"cdrom.hpp"				// is further explanation needed ? 


extern unsigned	_stklen = 0x2000 ;		// this is for bc++ and is 
										//   non-portable....


int			main_pgm( int, char ** ) ;
int			main( int, char ** ) ;
void		usage( void ) ;
void		title( void ) ;


//********************************************************
//
//		main  :-
//
//		a simple driver that makes sure the CDRom class
//		has been initialized....
//
//********************************************************/

int		main( int argc, char ** argv )
{

	title() ;
	if ( CDRom::InitClass() )
		return( main_pgm( argc, argv ) ) ;
	printf( "Couldn't initialize using the CDRom::InitClass().\n"
			"Probably due to the fact that there are no CDROM drives "
			"attached to this system.\n") ;
	printf( ""
			"\n" ) ;
	usage() ;
	return( 5 ) ;

}

//********************************************************
//
//		title  :-
//
//********************************************************/

void	title( void )
{
	printf( "\nCD (Audio) Exerciser V-1.0  Copyright (c) 1994, "
			"Jethro Wright, III\n" ) ;
	printf( ""
			"\n" ) ;
	return ;
}


//********************************************************
//
//		usage  :-
//
//********************************************************/

void	usage( void )
{

	printf( "Exercise MSCDEX's audio CD functions from the DOS "
			"command line.\n" ) ;
	printf( ""
			"\n" ) ;
	printf( "Usage :-\n" ) ;
	printf( "  cdx [<trk_nbr>] | [-c] | [-e] | [-l] | [-p] | [-r] "
			"| [-s] | [-t<trk_nbr>]\n" ) ;
	printf( "If no cmd-line parameter is supplied, CDX displays only the "
			"current CD's\n" ) ;
	printf( "table of contents.  <trk_nbr> is the number of a desired "
			"audio track.\n" ) ;
	printf( "If supplied alone, audio play begins w/ this track and "
			"continues til the end\n" ) ;
	printf( "of the disk.  Otherwise, use any one of the options listed "
			"below:\n" ) ;
	printf( " -c continues a CD paused w/ -s    -e ejects the CD (if "
			"avail) \n" ) ;
	printf( " -l close the CD door (if avail)   " ) ;
	printf( "-p starts a %d-sec preview of all tracks\n", _PRVW_LGTH ) ;
	printf( " -r resets the CD subsystem        -s stops the current audio "
			"selection\n" ) ;
	printf( " -t<trk_nbr> plays a single track\n" ) ;
	return ;

}


//********************************************************
//
//		AccessCD  :-
//
//		access the cd, by reading the toc and subsequently
//		printing its contents.  needed in order to play
//		anything or to display position-relative info....
//
//********************************************************/

int		AccessCD( CDRom& theDrive )
{

	//	get and display the cd's table of contents.  this generally shud
	//	be the first thing done after instancing a CDRom obj.  not
	//	always a safe thing to do for all drivers, as it may interrupt
	//	an audio play operation in progress, but it works w/ the sony driver,
	//	as its driver caches the toc (one of the things it does right),
	//	according to a suggestion in the mscdex spec....
	if ( theDrive.IsDiskInDrive() ) {
		if ( theDrive.ReadTOC() ) {
			printf( "%%%%%% Can't read the CD's table of contents.\n\n" ) ;
			usage() ;
			return( 2 ) ;
		}
		else theDrive.PrintTOC() ;
	}
	else {
		printf( "%%%%%% No disk in the drive.  Nothing to do.\n" ) ;
		usage() ;
		return( 4 ) ;
	}
	printf( ""
			"\n" ) ;

	return( 0 ) ;

}


//********************************************************
//
//		main_pgm  :-
//
//		guts of a test pgm for the cd classes/routines that 
//		take various args from the cmd line arg to display
//		the status and other info from the cd driver and
//		to play cd audio tracks....
//
//********************************************************/

int		main_pgm( int argc, char ** argv )
{

	int		tMins, tSecs, dMins, dSecs ;
	WORD	paused = 0 ;
	DWORD	trackDetails, trackTime, diskTime ;
	CDRom	theDrive( 0 ) ;				// use the 1st cdrom, altho if no
										//	arg is supplied, the result will
										//	be the same


	//	play the cd starting at the track requested on the 
	//	command line, if an arg was supplied....
	if ( argc > 1 ) {
		if ( argv[ 1 ][ 0 ] == '-' ) {
			switch( tolower( argv[ 1 ][ 1 ] ) ) {

				case 'l':
					// load the disk & display its contents....
					theDrive.CloseTray() ;
					AccessCD( theDrive ) ;
					break ;

				case 's':				// stop the presses !
					if ( ! AccessCD( theDrive ) )
						theDrive.Stop() ;
					break ;

				case 'c':				// as you were....
					if ( ! AccessCD( theDrive ) )
						theDrive.Stop( 0 ) ;
					break ;

				case 'r':				// reset the drive subsystem....
					theDrive.Reset() ;
					break ;

				case 'e':				// kick it !
					theDrive.Eject() ;
					break ;

				case 't':				// play a sgl....
					if ( ! AccessCD( theDrive ) )
						theDrive.PlayTrack( atoi( &argv[ 1 ][ 2 ] ) ) ;
					break ;

				case 'p':				// preview the cd....
					if ( ! AccessCD( theDrive ) ) {
						printf( "Press any key to stop the preview....\n" ) ;
						theDrive.PlayPreview() ;
					}
					break ;

				default:
					//	show both the toc and the pgm options....
					AccessCD( theDrive ) ;
					usage() ;
					return( 3 ) ;
			}
		}
		else {
			if ( ! AccessCD( theDrive ) ) {
				theDrive.PlayDisk( atoi( argv[ 1 ] ) ) ;
				printf( "CDX -? for info on other program options.\n" ) ;
			}
		}
	}
	else {
		//	prep theDrive's toc, display it, and current audio pgm info....
		if ( ! AccessCD( theDrive ) ) {
			theDrive.GetPlayStatus( ( WORD far * ) &paused, NULL, NULL ) ;
			if ( theDrive.IsBusy() || paused ) {
				printf( "Current Q-Channel Info:\n" ) ;
				theDrive.GetQInfo( ( DWORD far * ) &trackDetails,
								   ( DWORD far * ) &trackTime,
								   ( DWORD far * ) &diskTime ) ;
				theDrive.PrintQInfo( trackDetails, trackTime, diskTime ) ;
				theDrive.GetTimeRemaining( ( int far * ) &tMins,
										   ( int far * ) &tSecs,
										   ( int far * ) &dMins,
										   ( int far * ) &dSecs ) ;
				printf( "Time remaining on  track: %2dm:%02ds  program: "
						"%2dm:%02ds\n", tMins, tSecs, dMins, dSecs ) ;
			    printf( ""
						"\n" ) ;
				if ( paused )
					printf( "%%%%%%  Drive paused.\n" ) ;
			}
		}
		printf( "CDX -? for info on other program options.\n" ) ;
	}

	return( 0 ) ;

}

