/*C4*/
//****************************************************************
//	Author:	Jethro Wright, III 			TS :  1/18/1994  9:36
//	Date:	01/01/1994
//
//			ioctl.hpp :	definitions/declarations for an
//			ioctl-oriented command interface for audio
//			cd access via mscdex
//
//	History:
//		01/01/1994  jw3	 also sprach zarathustra....
//****************************************************************/


#if		! defined( __IOCTL_HPP__ )
#define			__IOCTL_HPP__

#include		"types.h"
#include		"device.h"

	
			//		the principle error codes we're concerned w/ after each
			//		ioctl operation.  the entire status word from the
			//		last ioctl operation is returned from each ioctl cmd....

#define		IOS_ERROR			0x8000	// == some sort of failure
#define		IOS_BUSY			0x200	// == play audio is engaged


			//		device status info bits from the GetDeviceStatus() fn....

#define		STATUS_DOOR_OPEN		0x01
#define		STATUS_DOOR_UNLOCKED	0x02
#define		STATUS_COOKED_RAW_READS	0x04
#define		STATUS_READ_WRITE		0x08
#define		STATUS_DATA_AUDIO_CAPBL	0x10
#define		STATUS_RESERVED			0x20
#define		STATUS_PREFETCH			0x40
#define		STATUS_AUDIO_MANIP		0x80
#define		STATUS_DUAL_ADDRESSG	0x100
#define		STATUS_NO_DISK			0x800


		//
		//	to use the IOCTL class, one simply creates an instance of the
		//	class, specifying the mscdex drive to be accessed during
		//	subsequent calls.  since most pc systems are likely to have only 
		//	a sgl cdrom drive, the defalts are setup to go for the 1st drive
		//	in the target system.  the IOCTL instance shud be retained
		//	for the entire lifetime of the object that uses it (or at least
		//	until it no longer needs to issue cdrom cmds.
		//
		//	maybe someone else will adapt this to make it more generic, but
		//	so far the only other possible application for an ioctl-based
		//	interface 
		//

class IOCTL {

		//
		//	the public mbr fns of this class correspond to all of conventional
		//	(read, anticipated) cmds one would want to perform on an audio cd
		//	via mscdex.  the c code which inspired this system, while
		//	adequately coded, was less than organized in its approach to
		//	the subject.  this was probably true bec the mscdex spec doesn't
		//	lend itself to understanding the means by which one gets audio out
		//	of a cdrom.  hence the design of this system, which reflects the
		//	notion of encapsulating functionality where required.  if add'l
		//	capabilities are needed, it shud be fairly obvious how one would
		//	supplement the classes in this kit.  as stated above and in other
		//	places in this kit, the goal of this proj was to 
		//
		//	anyway, when one of the these fn is invoked, it immed dispatches
		//	a service request (a cmd) to the device driver and retns the
		//	status word from the request header, for interrogation by the
		//	caller....
		//

	public:
		IOCTL( int, int, VFP, VFP ) ;
		~IOCTL() ;

		WORD		Play( DWORD, DWORD, BYTE ) ;
		WORD		Stop( Boolean ) ;
		WORD		LockDoor( Boolean ) ;
		WORD		EjectDisk( void ) ;
		WORD		CloseTray( void ) ;
		WORD		ResetDisk( void ) ;
		WORD		GetUPC( struct UPCCommand far * ) ;
		WORD		GetTrackInfo( struct TrackInfoCmd far * ) ;
		WORD		GetQInfo( struct QChannelInfoCmd far * ) ;
		WORD		GetDiskInfo( struct DiskInfoCmd far * ) ;
		WORD		GetDeviceStatus( DWORD far * ) ;
		WORD		GetPlayStatus( struct PlayStatusCmd far * ) ;

	private:
		IOCTLSvcReq	theRequest ;

		//	these are the unit and sub-unit nbrs passed via the cstor.
		//	normally, we req svc for the sub unit of the desired device, but
		//	since it's only an extra couple of byts, let's hold onto the
		//	unit nbr as well, in case we need it in the future....

		int			unitNbr, subUnitNbr ;
		VFP			devStrategy ;		// == addr of the device strategy fn
										//	for this drive
		VFP			devInterrupt ;		// == addr of its device interrupt fn
		void		DoCmd( void ) ;		// dispatch the cmd to the device
										//	driver
		inline void	Setup( WORD sCmd, VFP sData, int sCnt ) {
			theRequest.rqh.command = sCmd ;
			theRequest.rqh.unit = subUnitNbr ;
			theRequest.rqh.len = sizeof( IOCTLSvcReq ) ;
			theRequest.xferBufr = sData ;
			theRequest.byteCnt = sCnt ;
			theRequest.media = theRequest.sector = 0 ;
			theRequest.volumeId = 0 ;
		} ;

};

#endif									// end:  if ! defined( __IOCTL_HPP__ )


