/***************************************************************
File: CMDL.H                  Copyright 1992 by Dlugosz Software
header file for the CMDL package for command-line parsing
This version may be used freely, with attribution.
***************************************************************/

class cmdlscan;  //used internally

class cmdl {
public:
   // need to put the type first
   enum errval { OK, NotFound, Duplicate, NoValue, BadValue };  //more later
private:
   // linked list management
   static cmdl* head;
   static cmdl* last;
   cmdl* next;
   // parser helpers
   static bool parse_switches (cmdlscan&, unsigned flags);
   static bool parse_keywords (cmdlscan&, unsigned flags);
   static cmdl* find_positional (unsigned flags);
   static cmdl* find_switch (char);
   static cmdl* find_switch (char*);
   static cmdl* find_keyword (char);
   static cmdl* find_keyword (char*);
protected:
   // recognition
   virtual char* getvalue (cmdlscan&);
   bool prelude();
   virtual bool scan (cmdlscan&) =0;
   virtual void post_process (unsigned) {}
   virtual void validate (unsigned fl);
   union {
      char cname;
      const char* sname;
      };
   unsigned flags;
   enum {charname=1024, noname= 2048, used=4096, valueoptional=8192};
   const char* helpstring;
   // constructor helpers
   void linkin();
public:
   // error output
   static char* signon_string;
   static void output (const char*);
   static void output (char);
   virtual void report_error();
   virtual void output_name();
   void foutput (const char*);  //formatted output
   // types
   enum {keyword=1, caps=2, required=4, expand_file= 8, once= 16};
   // constructors and destructor
   cmdl (const char* name, const char* helpstring= 0, unsigned flags= 0);
   cmdl (char name, const char* helpstring= 0, unsigned flags= 0);
   ~cmdl() {}
   // use
   enum parse_flags {plain=1};
   static bool parseit (cmdlscan& s, unsigned fl);
   static bool parseit (char*, unsigned flags=0);
   static bool parseit (unsigned flags=0);
   static void reset() { head= last= 0; }
   static void signon (char* s) { signon_string= s; }
   static void show_usage();
   // misc
   bool iskeyword() { return flags&keyword; }
   bool ischar() { return flags&charname; }
   bool hasvalue() { return (flags&used); }
   static errval error;
   static int count;  //how many parameters were found
   bool matchname (const char* s);
   const char* get_helpstring() { return helpstring; }
   // linked list traversal
   static cmdl* get_head() { return head; }
   cmdl* get_next() { return next; }
   };

class cmdl_flag : public cmdl {      // a boolean switch or flag
protected:
   bool scan (cmdlscan&);
   bool value;
   void report_error();
public:
   cmdl_flag (const char* name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {value= FALSE;}
   cmdl_flag (char name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {value= FALSE;}
   bool operator()() { return value; }
   void set (bool val= TRUE) { value= val; }
   void clear() { value= FALSE; }
   };

class cmdl_string : public cmdl {
protected:
   bool scan (cmdlscan&);
   char* value;
   void report_error();
public:
   cmdl_string (const char* name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {value= 0;}
   cmdl_string (char name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {value= 0;}
   char* operator()() { return value; }
   void set (char* val) { value= val; }  //note:  string not duplicated!
   };

class cmdl_int : public cmdl {
protected:
   bool scan (cmdlscan&);
   int value;
   void report_error();
public:
   cmdl_int (const char* name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {value= 0;}
   cmdl_int (char name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {value= 0;}
   int operator()() { return value; }
   void set (int val) { value= val; }
   };


class cmdl_help : public cmdl {  //special switch for invoking help
protected:
   bool scan (cmdlscan&);
public:
   cmdl_help (const char* name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {flags|=valueoptional;}
   cmdl_help (char name, const char* helpstring= 0, unsigned flags= 0) : cmdl (name,helpstring,flags) {flags|=valueoptional;}
   cmdl_help();  //simple form for -? ability
   };

