// command line test program
// John M. Dlugosz


#include "usual.h"
#include "cmdl.h"
#include <stdio.h>

// these can be static globals, spread in several modules even.
typedef cmdl_flag flag;
flag v ('v', "requests verbose mode");
flag s ('s', "specifies alternate algorythm");
flag T ('T', "prevents the foobar from clearing (debugging)"  ,cmdl::once);
cmdl_string pos1 ((char*)0, "first positional parameter", cmdl::required);
cmdl_string pos2 ((char*)0, "second positional parameter");
cmdl_string pos3 ((char*)0, "third positional parameter");
cmdl_int count ('c', "iteration count");
cmdl_help helper;

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

int main()
{
cmdl::signon (
   "stupid test program to test parameter passing.\n"
   "Written by John M. Dlugosz\n"
   "use:  TEST3 <flags> <param> [param] [param]\n");
cmdl::parseit();
// report on what was found
if (v()) puts ("you selected -v");
if (s()) puts ("you selected -s");
if (T()) puts ("you selected -T");
if (pos1()) printf ("first positional parameter is \"%s\"\n", pos1());
if (pos2()) printf ("second positional parameter is \"%s\"\n", pos2());
if (pos3()) printf ("third positional parameter is \"%s\"\n", pos3());
if (count.hasvalue()) printf ("count= %d\n", count());
}
