#include <math.h>
#include "dlmatrix.h"



CDLReal DotProduct(CDL1x4Matrix matrix1, CDL1x4Matrix matrix2)
{
  int iX, iY;
  CDLReal rResult;

  rResult = 0.0;

  for (iX = 0; iX < 1; iX++)
    {
    for (iY = 0; iY < 4; iY++)
      {
      rResult += matrix1.Get(iX, iY) * matrix2.Get(iX, iY);
      }
    }
  return rResult;
}


CDLReal DotProduct(CDL4x4Matrix matrix1, CDL4x4Matrix matrix2)
{
  int iX, iY;
  CDLReal rResult;

  rResult = 0.0;

  for (iX = 0; iX < 4; iX++)
    {
    for (iY = 0; iY < 4; iY++)
      {
      rResult += matrix1.Get(iX, iY) * matrix2.Get(iX, iY);
      }
    }
  return rResult;
}


CDL1x4Matrix operator + (CDL1x4Matrix matrix1, CDL1x4Matrix matrix2)
{
  int iX, iY;
  CDL1x4Matrix matrixResult;

  for (iX = 0; iX < 1; iX++)
    {
    for (iY = 0; iY < 4; iY++)
      {
      matrixResult.Put(iX, iY, matrix1.Get(iX, iY) + matrix2.Get(iX, iY));
      }
    }
  return matrixResult;
}

CDL4x4Matrix operator + (CDL4x4Matrix matrix1, CDL4x4Matrix matrix2)
{
  int iX, iY;
  CDL4x4Matrix matrixResult;

  for (iX = 0; iX < 4; iX++)
    {
    for (iY = 0; iY < 4; iY++)
      {
      matrixResult.Put(iX, iY, matrix1.Get(iX, iY) + matrix2.Get(iX, iY));
      }
    }
  return matrixResult;
}


CDL4x4Matrix operator * (CDL4x4Matrix matrix1, CDL4x4Matrix matrix2)
{
  int iX, iY, iIndex;
  CDLReal rResult;
  CDL4x4Matrix matrixResult;

  for (iY = 0; iY < 4; iY++)
    {
    for (iX = 0; iX < 4; iX++)
      {
      rResult = 0.0;
      for (iIndex = 0; iIndex < 4; iIndex++)
        {
        rResult += matrix1.Get(iIndex, iY) * matrix2.Get(iX, iIndex);
        }
      matrixResult.Put(iX, iY, rResult);
      }
    }

  return matrixResult;
}


CDL1x4Matrix operator * (CDL4x4Matrix matrix1, CDL1x4Matrix matrix2)
{
  int iX, iY, iIndex;
  CDLReal rResult;
  CDL1x4Matrix matrixResult;

  for (iY = 0; iY < 4; iY++)
    {
    for (iX = 0; iX < 1; iX++)
      {
      rResult = 0.0;
      for (iIndex = 0; iIndex < 4; iIndex++)
        {
        rResult += matrix1.Get(iIndex, iY) * matrix2.Get(iX, iIndex);
        }
      matrixResult.Put(iX, iY, rResult);
      }
    }

  return matrixResult;
}



void CDL4x4Matrix::PutIdentity()
{
  int iX, iY;

  for (iX = 0; iX < 4; iX++)
    {
    for (iY = 0; iY < 4; iY++)
      {
      Put(iX, iY, (iX == iY) ? 1.0 : 0.0);
      }
    }
}

void CDL4x4Matrix::PutTranslation( CDLReal rX, CDLReal rY, CDLReal rZ)
{
  PutIdentity();
  Put(3, 0, rX);
  Put(3, 1, rY);
  Put(3, 2, rZ);
}

void CDL4x4Matrix::PutScale( CDLReal rX, CDLReal rY, CDLReal rZ)
{
  PutIdentity();
  Put(0, 0, rX);
  Put(1, 1, rY);
  Put(2, 2, rZ);
}

void CDL4x4Matrix::PutPerspective( CDLReal rX, CDLReal rY, CDLReal rZ)
{
  PutIdentity();
  Put(0, 3, rX);
  Put(1, 3, rY);
  Put(2, 3, rZ);
}




void CDL4x4Matrix::PutRotation( CDLAngle angleTheta, 
                                CDLReal rX, 
                                CDLReal rY, 
                                CDLReal rZ)
{
  CDLReal rCos, rSin, rMinusSin;

  rCos = angleTheta.Cos();
  rSin = angleTheta.Sin();
  rMinusSin = -rSin;

  PutIdentity();

  Put(0, 0, rCos * (rY + rZ));
  Put(0, 1, rSin * rZ);
  Put(0, 2, rMinusSin * rY);

  Put(1, 0, rMinusSin * rZ);
  Put(1, 1, rCos * (rX + rZ));
  Put(1, 2, rSin * rX);
  Put(2, 0, rSin * rY);
  Put(2, 1, rMinusSin * rX);
  Put(2, 2, rCos * (rX + rY));
}


void CDL4x4Matrix::PutXRotation( CDLAngle angleTheta)
{
  CDLReal rCos, rSin, rMinusSin;

  rCos = angleTheta.Cos();
  rSin = angleTheta.Sin();
  rMinusSin = -rSin;

  PutIdentity();
  Put(1, 1, rCos);
  Put(2, 1, rMinusSin);
  Put(1, 2, rSin);
  Put(2, 2, rCos);
}

void CDL4x4Matrix::PutYRotation( CDLAngle angleTheta)
{
  CDLReal rCos, rSin, rMinusSin;

  rCos = angleTheta.Cos();
  rSin = angleTheta.Sin();
  rMinusSin = -rSin;

  PutIdentity();
  Put(0, 0, rCos);
  Put(2, 0, rSin);
  Put(0, 2, rMinusSin);
  Put(2, 2, rCos);
}


void CDL4x4Matrix::PutZRotation( CDLAngle angleTheta)
{
  CDLReal rCos, rSin, rMinusSin;

  rCos = angleTheta.Cos();
  rSin = angleTheta.Sin();
  rMinusSin = -rSin;

  PutIdentity();
  Put(0, 0, rCos);
  Put(1, 0, rMinusSin);
  Put(0, 1, rSin);
  Put(1, 1, rCos);
}


//#define CDLWORLD_MAX_MATRICES 4
//
//class CDLWorld
//{
//  private :
//    CDL4x4Matrix m_aMatrixView[CDLWORLD_MAX_MATRICES];
//    int m_iMatrixViewHighWater;
//  protected :
//    CDL1x4Matrix TranslatePoint(CDL1x4Matrix);
//  public :
//    CDLWorld();
//    void PushView(void);
//    void PopView(void);
//    void PutIdentity();
//    void PutTranslation( CDLReal rX, CDLReal rY, CDLReal rZ);
//    void PutScale( CDLReal rX, CDLReal rY, CDLReal rZ);
//    void PutXRotation( CDLAngle angleTheta);
//    void PutYRotation( CDLAngle angleTheta);
//    void PutZRotation( CDLAngle angleTheta);
//    void PutRotation( CDLAngle angleTheta, 
//                      CDLReal rX, 
//                      CDLReal rY, 
//                      CDLReal rZ);
//};
//
//CDLWorld::CDLWorld()
//{
//  m_iMatrixViewHighWater = 0;
//  PutIdentity();
//}
//
//CDLWorld::PushView(void)
//{
//  DL_ASSERT(m_iMatrixViewHighWater < CDLWORLD_MAX_MATRICES - 1);
//
//  m_iMatrixViewHighWater++;
//  m_aMatrixView[m_iMatrixViewHighWater] = 
//    m_aMatrixView[m_iMatrixViewHighWater - 1];
//}
//
//CDLWorld::PopView(void)
//{
//  DL_ASSERT(m_iMatrixViewHighWater > 0);
//
//  m_iMatrixViewHighWater--;
//}
//
//
//void CDLWorld::PutIdentity()
//{
//  m_aMatrixView[m_iMatrixViewHighWater].PutIdentity();
//}
//
//
//CDL1x4Matrix CDLWorld::TranslatePoint(CDL1x4Matrix matrixPoint)
//{
//  return m_aMatrixView[m_iMatrixViewHighWater] * matrixPoint;
//}
//
//
//void CDLWorld::PutTranslation( CDLReal rX, CDLReal rY, CDLReal rZ)
//{
//  CDLMatrix4x4 matrix;
//
//  matrix.PutTranslation( rX, rY, rZ);
//  m_aMatrixView[m_iMatrixViewHighWater] =
//    m_aMatrixView[m_iMatrixViewHighWater] * matrix;
//}
//
//void CDLWorld::PutScale( CDLReal rX, CDLReal rY, CDLReal rZ)
//{
//  CDLMatrix4x4 matrix;
//
//  matrix.PutScale( rX, rY, rZ);
//  m_aMatrixView[m_iMatrixViewHighWater] =
//    m_aMatrixView[m_iMatrixViewHighWater] * matrix;
//}
//
//void CDLWorld::PutXRotation( CDLAngle angleTheta)
//{
//  CDLMatrix4x4 matrix;
//
//  matrix.PutXRotation( angleTheta);
//  m_aMatrixView[m_iMatrixViewHighWater] =
//    m_aMatrixView[m_iMatrixViewHighWater] * matrix;
//}
//
//void CDLWorld::PutYRotation( CDLAngle angleTheta)
//{
//  CDLMatrix4x4 matrix;
//
//  matrix.PutYRotation( angleTheta);
//  m_aMatrixView[m_iMatrixViewHighWater] =
//    m_aMatrixView[m_iMatrixViewHighWater] * matrix;
//}
//
//void CDLWorld::PutZRotation( CDLAngle angleTheta)
//{
//  CDLMatrix4x4 matrix;
//
//  matrix.PutZRotation( angleTheta);
//  m_aMatrixView[m_iMatrixViewHighWater] =
//    m_aMatrixView[m_iMatrixViewHighWater] * matrix;
//}
//
//void CDLWorld::PutRotation( CDLAngle angleTheta,
//                            CDLReal rX, 
//                            CDLReal rY, 
//                            CDLReal rZ);
//{
//  CDLMatrix4x4 matrix;
//
//  matrix.PutRotation( angleTheta, 
//  m_aMatrixView[m_iMatrixViewHighWater] =
//    m_aMatrixView[m_iMatrixViewHighWater] * matrix;
//}









