#ifndef __DLMATRIX_H__
#define __DLMATRIX_H__

typedef double CDLReal;

class CDLAngle
{
  private :
    CDLReal m_rTheta;

  public :
    CDLAngle(CDLReal rTheta)
      {
      m_rTheta = rTheta * 3.14159265 / 180.0;
      }
    CDLReal Sin() { return sin(m_rTheta);}
    CDLReal Cos() { return cos(m_rTheta);}
};


class CDL1x4Matrix
{
  private :
    CDLReal m_arData[4];

  public :
    CDLReal Get(int iX, int iY);
    void Put(int iX, int iY, CDLReal rWhat);
    CDLReal GetX();
    CDLReal GetY();
    CDLReal GetZ();
    CDLReal GetW();
    void PutX(CDLReal rWhat);
    void PutY(CDLReal rWhat);
    void PutZ(CDLReal rWhat);
    void PutW(CDLReal rWhat);
};


class CDL4x4Matrix
{
  private :
    CDLReal m_aarData[4][4];
  public :
    CDLReal Get(int iX, int iY);
    void Put(int iX, int iY, CDLReal rWhat);
    void PutIdentity();

    void PutTranslation( CDLReal rX, CDLReal rY, CDLReal rZ);
    void PutScale( CDLReal rX, CDLReal rY, CDLReal rZ);
    void PutPerspective( CDLReal rX, CDLReal rY, CDLReal rZ);
    void PutXRotation( CDLAngle angleTheta);
    void PutYRotation( CDLAngle angleTheta);
    void PutZRotation( CDLAngle angleTheta);
    void PutRotation( CDLAngle angleTheta, 
                      CDLReal rX, 
                      CDLReal rY, 
                      CDLReal rZ);

};



CDLReal DotProduct(CDL1x4Matrix matrix1, CDL1x4Matrix matrix2);
CDLReal DotProduct(CDL4x4Matrix matrix1, CDL4x4Matrix matrix2);
CDL1x4Matrix operator + (CDL1x4Matrix matrix1, CDL1x4Matrix matrix2);
CDL4x4Matrix operator + (CDL4x4Matrix matrix1, CDL4x4Matrix matrix2);
CDL4x4Matrix operator * (CDL4x4Matrix matrix1, CDL4x4Matrix matrix2);
CDL1x4Matrix operator * (CDL4x4Matrix matrix1, CDL1x4Matrix matrix2);




// CDL1x4Matrix - Inline functions

inline CDLReal CDL1x4Matrix::GetX()
{
  return Get(0, 0);
}

inline CDLReal CDL1x4Matrix::GetY()
{
  return Get(0, 1);
}

inline CDLReal CDL1x4Matrix::GetZ()
{
  return Get(0, 2);
}

inline CDLReal CDL1x4Matrix::GetW()
{
  return Get(0, 3);
}

inline void CDL1x4Matrix::PutX(CDLReal rWhat)
{
  Put(0, 0, rWhat);
}

inline void CDL1x4Matrix::PutY(CDLReal rWhat)
{
  Put(0, 1, rWhat);
}

inline void CDL1x4Matrix::PutZ(CDLReal rWhat)
{
  Put(0, 2, rWhat);
}

inline void CDL1x4Matrix::PutW(CDLReal rWhat)
{
  Put(0, 3, rWhat);
}


inline CDLReal CDL1x4Matrix::Get(int iX, int iY)
{
  return m_arData[iY];
}

inline void CDL1x4Matrix::Put(int iX, int iY, CDLReal rWhat)
{
  m_arData[iY] = rWhat;
}



// CDL4x4Matrix - Inline functions



inline CDLReal CDL4x4Matrix::Get(int iX, int iY)
{
  return m_aarData[iX][iY];
}

inline void CDL4x4Matrix::Put(int iX, int iY, CDLReal rWhat)
{
  m_aarData[iX][iY] = rWhat;
}


#endif // #ifndef __DLMATRIX_H__

