#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <commdlg.h>

#include "matrix.h"
#include <time.h>


#include "dlmatrix.h"



#define MAX_TRANSLATION_MATRICES 20

CDL4x4Matrix g_aUserMatrices[MAX_TRANSLATION_MATRICES];
CDL4x4Matrix g_aResultMatrices[MAX_TRANSLATION_MATRICES];
int g_iCurrent;




HINSTANCE _hInstance;
char _szMatrixShowClass[] = CLASS_MATRIX_SHOW;
char _szDisplay3dClass[] = CLASS_DISPLAY3D;

char _szAppDialogName[] = "Dan's Transformation Matrix Explorer";


#define MAX_SIMULTANEOUS_STRINGS 3
#define MAX_STRING_LENGTH 256


char *DanString(WORD wString)
{
	static char _aachBuffer[MAX_SIMULTANEOUS_STRINGS][MAX_STRING_LENGTH];
	static int _iCounter = 0;
	char *pszReturn;


	LoadString(_hInstance, 
		wString, 
		_aachBuffer[_iCounter], 
		MAX_STRING_LENGTH - 1);

	pszReturn = _aachBuffer[_iCounter];
	_iCounter++;
	_iCounter %= MAX_SIMULTANEOUS_STRINGS;

	return pszReturn;

} // char *DanString(WORD wString)



CDL4x4Matrix GetWhichMatrix(int iWhich)
{
	CDL4x4Matrix matrixResult;

	matrixResult.PutIdentity();

	switch (iWhich)
		{
		case CTRL_MATRIX_SHOW_CURRENT :
			matrixResult = g_aResultMatrices[g_iCurrent];
			break;
		case CTRL_MATRIX_SHOW_PREVIOUS :
			if (g_iCurrent > 0)
				matrixResult = g_aResultMatrices[g_iCurrent - 1];
			break;
		}
	return matrixResult;
}

LONG FAR PASCAL MatrixShowWndProc(HWND hWnd, 
	WORD wMessage, 
	WORD wParam, 
	LONG lParam)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rect;


	switch(wMessage)
		{
		case WM_SIZE :
			break;

		case WM_PAINT :
			{
			CDL4x4Matrix matrix;
			int iRow, iColumn;
			int iX, iY;
			TEXTMETRIC strTextMetrics;
			char achBuffer[32];

			matrix = GetWhichMatrix(GetWindowWord(hWnd, GWW_ID));

			hdc = BeginPaint(hWnd, &ps);


//			GetTextMetrics(hdc, &strTextMetrics);
			GetClientRect(hWnd, &rect);

			for (iColumn = 0; iColumn < 4; iColumn++)
				{
				for (iRow = 0; iRow < 4; iRow++)
					{
					iX = (rect.right - rect.left) * iColumn / 4;
					iY = (rect.bottom - rect.top) * iRow / 4;
					sprintf(achBuffer, "%f", matrix.Get(iColumn, iRow));
					achBuffer[6] = '\0';
					TextOut(hdc, iX, iY, achBuffer, strlen(achBuffer));
					}
				}


			EndPaint(hWnd, &ps);
			}
			break;
		case WM_DESTROY :
			return 0;

		} // end switch on wMessage

	return DefWindowProc(hWnd, wMessage, wParam, lParam);
}

void Draw3dLine(HWND hWnd, HDC hdc, CDL1x4Matrix matrixFrom, CDL1x4Matrix matrixTo, COLORREF color)
{
	HPEN hPen;
	CDL1x4Matrix matrixPoint;
	RECT rect;
	int iCenterX;
	int iCenterY;
	double dX, dY;


	GetClientRect(hWnd, &rect);

	iCenterX = (rect.right - rect.left) / 2;
	iCenterY = (rect.bottom - rect.top) / 2;


	hPen = CreatePen(PS_SOLID, 1, color);

	hPen = SelectObject(hdc, hPen);


	matrixPoint = GetWhichMatrix(CTRL_MATRIX_SHOW_CURRENT) * matrixFrom;

	if (matrixPoint.GetW() != 0.0)
		{
		dX = (matrixPoint.GetX() / matrixPoint.GetW());
		dY = (matrixPoint.GetY() / matrixPoint.GetW());
		}
	else
		{
		dX = (matrixPoint.GetX());
		dY = (matrixPoint.GetY());
		}

	MoveTo(hdc, 
		iCenterX + (int)(dX / 3.0 * (float)iCenterX),
		iCenterY + (int)(dY / 3.0 * (float)iCenterY));

	matrixPoint = GetWhichMatrix(CTRL_MATRIX_SHOW_CURRENT) * matrixTo;

	if (matrixPoint.GetW() != 0.0)
		{
		dX = (matrixPoint.GetX() / matrixPoint.GetW());
		dY = (matrixPoint.GetY() / matrixPoint.GetW());
		}
	else
		{
		dX = (matrixPoint.GetX());
		dY = (matrixPoint.GetY());
		}

	LineTo(hdc, 
		iCenterX + (int)(dX / 3.0 * (float)iCenterX),
		iCenterY + (int)(dY / 3.0 * (float)iCenterY));

	hPen = SelectObject(hdc, hPen);
	DeleteObject(hPen);
}




LONG FAR PASCAL Display3dWndProc(HWND hWnd, 
	WORD wMessage, 
	WORD wParam, 
	LONG lParam)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rect;


	switch(wMessage)
		{
		case WM_SIZE :
			break;

		case WM_PAINT :
			{
			CDL1x4Matrix matrixFrom;
			CDL1x4Matrix matrixTo;

			hdc = BeginPaint(hWnd, &ps);
			GetClientRect(hWnd, &rect);


			matrixFrom.PutX(1.0);
			matrixFrom.PutY(1.0);
			matrixFrom.PutZ(1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(1.0);
			matrixTo.PutY(-1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(255,0,0));

			matrixFrom.PutX(1.0);
			matrixFrom.PutY(-1.0);
			matrixFrom.PutZ(1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(-1.0);
			matrixTo.PutY(-1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,255,0));

			matrixFrom.PutX(-1.0);
			matrixFrom.PutY(-1.0);
			matrixFrom.PutZ(1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(-1.0);
			matrixTo.PutY(1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,0,255));

			matrixFrom.PutX(-1.0);
			matrixFrom.PutY(1.0);
			matrixFrom.PutZ(1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(1.0);
			matrixTo.PutY(1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(255,0,255));





			matrixFrom.PutX(1.0);
			matrixFrom.PutY(1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(1.0);
			matrixTo.PutY(-1.0);
			matrixTo.PutZ(-1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(128,0,0));

			matrixFrom.PutX(1.0);
			matrixFrom.PutY(-1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(-1.0);
			matrixTo.PutY(-1.0);
			matrixTo.PutZ(-1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,128,0));

			matrixFrom.PutX(-1.0);
			matrixFrom.PutY(-1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(-1.0);
			matrixTo.PutY(1.0);
			matrixTo.PutZ(-1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,0,128));

			matrixFrom.PutX(-1.0);
			matrixFrom.PutY(1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(1.0);
			matrixTo.PutY(1.0);
			matrixTo.PutZ(-1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(128,0,128));






			matrixFrom.PutX(1.0);
			matrixFrom.PutY(1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(1.0);
			matrixTo.PutY(1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,0,0));

			matrixFrom.PutX(1.0);
			matrixFrom.PutY(-1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(1.0);
			matrixTo.PutY(-1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,0,0));

			matrixFrom.PutX(-1.0);
			matrixFrom.PutY(-1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(-1.0);
			matrixTo.PutY(-1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,0,0));

			matrixFrom.PutX(-1.0);
			matrixFrom.PutY(1.0);
			matrixFrom.PutZ(-1.0);
			matrixFrom.PutW(1.0);

			matrixTo.PutX(-1.0);
			matrixTo.PutY(1.0);
			matrixTo.PutZ(1.0);
			matrixTo.PutW(1.0);

			Draw3dLine(hWnd, hdc, matrixFrom, matrixTo, RGB(0,0,0));



			EndPaint(hWnd, &ps);
			}
			break;
		case WM_DESTROY :
			return 0;

		} // end switch on wMessage

	return DefWindowProc(hWnd, wMessage, wParam, lParam);
}


int g_iMatrixOperation;



BOOL _export FAR PASCAL EditMatrixDlgProc(HWND hWnd, UINT wMessage, UINT wParam, LONG lParam)
{
	char achBufferX[32];
	char achBufferY[32];
	char achBufferZ[32];

	switch (wMessage)
		{
		case WM_INITDIALOG :
			SetDlgItemText(hWnd, CTRL_TEXT_WHATS_CHANGING, DanString(g_iMatrixOperation));
			return TRUE;

		case WM_COMMAND :
			switch (wParam)
				{
				case IDOK :
					GetDlgItemText(hWnd, 
						CTRL_EDIT_X, 
						achBufferX, 
						sizeof(achBufferX) - 1);

					GetDlgItemText(hWnd, 
						CTRL_EDIT_Y, 
						achBufferY, 
						sizeof(achBufferY) - 1);

					GetDlgItemText(hWnd, 
						CTRL_EDIT_Z, 
						achBufferZ, 
						sizeof(achBufferZ) - 1);


					switch (g_iMatrixOperation)
						{
						case IDS_DO_ROTATE		:
							g_aUserMatrices[g_iCurrent].PutIdentity();
							if (atof(achBufferX) != 0.0)
								{
								g_aUserMatrices[g_iCurrent].PutXRotation(atof(achBufferX));
								}
								
							if (atof(achBufferY) != 0.0)
								{
								g_aUserMatrices[g_iCurrent].PutYRotation(atof(achBufferY));
								}
								
							if (atof(achBufferZ) != 0.0)
								{
								g_aUserMatrices[g_iCurrent].PutZRotation(atof(achBufferZ));
								}
							break;

						case IDS_DO_TRANSLATE	:
							g_aUserMatrices[g_iCurrent].PutIdentity();
							g_aUserMatrices[g_iCurrent].PutTranslation(
								atof(achBufferX),
								atof(achBufferY),
								atof(achBufferZ));
							break;

						case IDS_DO_SCALE			:
							g_aUserMatrices[g_iCurrent].PutIdentity();
							g_aUserMatrices[g_iCurrent].PutScale(
								atof(achBufferX),
								atof(achBufferY),
								atof(achBufferZ));
							break;

						case IDS_DO_PERSPECTIVE	:
							g_aUserMatrices[g_iCurrent].PutIdentity();
							g_aUserMatrices[g_iCurrent].PutPerspective(
								atof(achBufferX),
								atof(achBufferY),
								atof(achBufferZ));
							break;

						default :
							break;
						}
					EndDialog(hWnd, 0);
					return TRUE;

				default :
					break;
				}
			break;
		default :
			break;
		}
	return FALSE;
}



void DoSetMatrix(HWND hWnd, int iType)
{
	switch (iType)
		{
		case CTRL_BTN_ROTATE :
			g_iMatrixOperation = IDS_DO_ROTATE;
			break;

		case CTRL_BTN_TRANSLATE :
			g_iMatrixOperation = IDS_DO_TRANSLATE;
			break;

		case CTRL_BTN_SCALE :
			g_iMatrixOperation = IDS_DO_SCALE;
			break;

		case CTRL_BTN_PERSPECTIVE :
			g_iMatrixOperation = IDS_DO_PERSPECTIVE;
			break;

		}
	DialogBox(_hInstance, "EditMatrixDlg", hWnd, EditMatrixDlgProc);

}



LONG FAR PASCAL MainWndDlgWndProc(HWND hWnd, 
	WORD wMessage, 
	WORD wParam, 
	LONG lParam)
{
	switch (wMessage)
		{
		case WM_SIZE :
//			if (wParam == SIZEFULLSCREEN || wParam == SIZENORMAL)
//				{
//				InvalidateRect(hWnd, NULL, TRUE);
//				}
			break;

		case WM_GETMINMAXINFO :
//			g_strMainWndSize.SetMinMaxInfo((POINT _far *)lParam);
			return 0L;

		default :
			break;
		}

	return DefDlgProc(hWnd, wMessage, wParam, lParam);
}




void FillInPointValues(HWND hWnd)
{
	char achBuffer[32];
	CDL1x4Matrix matrixPoint;

	matrixPoint.Put(0,0, 1.0);
	matrixPoint.Put(0,1, 1.0);
	matrixPoint.Put(0,2, 1.0);
	matrixPoint.Put(0,3, 1.0);

	matrixPoint = GetWhichMatrix(CTRL_MATRIX_SHOW_CURRENT) * matrixPoint;

	sprintf(achBuffer, "%f", matrixPoint.Get(0,0));
	SetDlgItemText(hWnd, CTRL_TXT_PT_X, achBuffer);
	sprintf(achBuffer, "%f", matrixPoint.Get(0,1));
	SetDlgItemText(hWnd, CTRL_TXT_PT_Y, achBuffer);
	sprintf(achBuffer, "%f", matrixPoint.Get(0,2));
	SetDlgItemText(hWnd, CTRL_TXT_PT_Z, achBuffer);
	sprintf(achBuffer, "%f", matrixPoint.Get(0,3));
	SetDlgItemText(hWnd, CTRL_TXT_PT_W, achBuffer);
}






void SetDlgItemsFromMatrix(HWND hWnd, CDL4x4Matrix matrix)
{
	int iX, iY;
	char achBuffer[32];

	for (iX = 0; iX < 4; iX++)
		{
		for (iY = 0; iY < 4; iY++)
			{
			sprintf(achBuffer, "%f", matrix.Get(iX, iY));
			achBuffer[6] = '\0';
			SetDlgItemText(hWnd, CTRL_MATRIX_EDIT_BASE + iX + iY * 4, achBuffer);
			}
		}
}

CDL4x4Matrix GetMatrixFromDlgItems(HWND hWnd)
{
	int iX, iY;
	char achBuffer[32];
	CDL4x4Matrix matrix;

	for (iX = 0; iX < 4; iX++)
		{
		for (iY = 0; iY < 4; iY++)
			{
			GetDlgItemText(hWnd, CTRL_MATRIX_EDIT_BASE + iX + iY * 4, 
				achBuffer, sizeof(achBuffer) - 1);
			matrix.Put(iX, iY, atof(achBuffer));
			}
		}

	return matrix;
}


void UpdateResults()
{
	int iCounter;
	CDL4x4Matrix matrixOld;

	for (iCounter = 0; iCounter < MAX_TRANSLATION_MATRICES; iCounter++)
		{
		if (iCounter)
			matrixOld = g_aResultMatrices[iCounter - 1];
		else
			matrixOld.PutIdentity();

		g_aResultMatrices[iCounter] = matrixOld * g_aUserMatrices[iCounter];
		}
}


void UpdateEverythingFromMatrix(HWND hWnd)
{
	SetDlgItemsFromMatrix(hWnd, g_aUserMatrices[g_iCurrent]);
	UpdateResults();
	FillInPointValues(hWnd);
	InvalidateRect(GetDlgItem(hWnd, CTRL_MATRIX_SHOW_CURRENT), NULL, TRUE);
	InvalidateRect(GetDlgItem(hWnd, CTRL_DISPLAY3D), NULL, TRUE);
}

BOOL _export FAR PASCAL MainWndDlgProc(HWND hWnd, UINT wMessage, UINT wParam, LONG lParam)
{
	char achBuffer[32];
	static BOOL _fChanging = FALSE;

	switch (wMessage)
		{
		case WM_INITDIALOG :
			SetScrollRange(GetDlgItem(hWnd, CTRL_SCR_MATRIX), 
				SB_CTL, 
				0, 
				MAX_TRANSLATION_MATRICES - 1,
				FALSE);
			SetScrollPos(GetDlgItem(hWnd, CTRL_SCR_MATRIX), 
				SB_CTL, 
				g_iCurrent,
				TRUE);
			SetDlgItemInt(hWnd, CTRL_TXT_MATRIX_NUM, g_iCurrent, TRUE);
			UpdateEverythingFromMatrix(hWnd);
			return TRUE;



		case WM_COMMAND :
			switch (wParam)
				{
				case CTRL_BTN_ROTATE :
				case CTRL_BTN_TRANSLATE :
				case CTRL_BTN_SCALE :
				case CTRL_BTN_PERSPECTIVE :
					DoSetMatrix(hWnd, wParam);
					UpdateEverythingFromMatrix(hWnd);
					break;

				case CTRL_BTN_IDENTITY :
					g_aUserMatrices[g_iCurrent].PutIdentity();
					UpdateEverythingFromMatrix(hWnd);
					break;

				case CTRL_BTN_REDRAW :
					g_aUserMatrices[g_iCurrent] = GetMatrixFromDlgItems(hWnd);
					UpdateEverythingFromMatrix(hWnd);
					break;

				case CTRL_BTN_HELP :
					WinHelp(hWnd, "matrix.hlp", HELP_INDEX,0L);
					break;
				} // end of wm command switch
			break;

		case WM_VSCROLL :
//			if (HIWORD(lParam) == CTRL_SCR_MATRIX)
				{
				BOOL fChanged;

				fChanged = FALSE;
				switch (wParam)
					{
					case SB_TOP :
						g_iCurrent = MAX_TRANSLATION_MATRICES - 1;
						fChanged = TRUE;
						break;

					case SB_BOTTOM :
						g_iCurrent = 0;
						fChanged = TRUE;
						break;

					case SB_LINEDOWN :
					case SB_PAGEDOWN :
						if (g_iCurrent < MAX_TRANSLATION_MATRICES - 1)
							g_iCurrent++;
						fChanged = TRUE;
						break;

					case SB_LINEUP :
					case SB_PAGEUP :
						if (g_iCurrent > 0)
							g_iCurrent--;
						fChanged = TRUE;
						break;

					case SB_THUMBPOSITION :
						g_iCurrent = LOWORD(lParam);
						fChanged = TRUE;
						break;
					}

				if (fChanged)
					{
					SetScrollPos(GetDlgItem(hWnd, CTRL_SCR_MATRIX), 
						SB_CTL, 
						g_iCurrent, 
						TRUE);
					SetDlgItemsFromMatrix(hWnd, g_aUserMatrices[g_iCurrent]);
					SetDlgItemInt(hWnd, CTRL_TXT_MATRIX_NUM, g_iCurrent, TRUE);
					UpdateEverythingFromMatrix(hWnd);
					}
				}
			break;


		case WM_CLOSE :
				DestroyWindow(hWnd);
				PostQuitMessage(0);
			return TRUE;

		default :
			break;

		} // end of message switch
//			EnableWindow(GetDlgItem(hWnd,CTRL_TARGETANGLEDEFAULT),0);

	return FALSE;
}













int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
	LPSTR lpszCmdParam, int nCmdShow)
{
	HWND hWnd;
	MSG msg;
	WNDCLASS wndclass;


	if (!hPrevInstance)
		{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = (void *)MatrixShowWndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = NULL;
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = _szMatrixShowClass;

		RegisterClass(&wndclass);

		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = (void *)Display3dWndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = NULL;
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = _szDisplay3dClass;

		RegisterClass(&wndclass);
		}


	_hInstance = hInstance;



	for (g_iCurrent = 0; g_iCurrent < MAX_TRANSLATION_MATRICES; g_iCurrent++)
		{
		g_aUserMatrices[g_iCurrent].PutIdentity();
		g_aResultMatrices[g_iCurrent].PutIdentity();
		}

	g_iCurrent = 0;



	hWnd = CreateDialog(hInstance, "MatrixDlg", 0, MainWndDlgProc);
	SetWindowLong(hWnd, GWL_WNDPROC, (LONG)MainWndDlgWndProc);
   SetClassWord(hWnd,GCW_HICON, (WORD)LoadIcon(hInstance,"LoomIco"));

	while (GetMessage(&msg, NULL, 0, 0))
		{
		if (!IsDialogMessage(hWnd,&msg))
			{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
			}
		}

	return 0;
} // End: WinMain
