//
//	Date representation is a unsigned long, counting from the fictional date March 1st, year 1200 Gregorian
//
typedef	unsigned long DATE;

//
//	Day, month, year are passed as unsigned short values
//
typedef unsigned short USHORT;

//
//	Convert a day number to year, month, day
//
BOOL GetDate(DATE d, USHORT &year, USHORT &month, USHORT &day);

//
//	Convert year, month, day to a day number
//
BOOL SetDate(DATE &d, USHORT year, USHORT month, USHORT day);

//
//	Calculate the date of easter
//
//	Other Christian religious days can be calculate by adding the following constants to the date of easter:
//	Ash Wednesday		-46
//	Good Friday			-2
//	Ascension day 		39
//	Pentecost 			49
//
BOOL CalcEaster(USHORT year, DATE &d);

//
//	Calculate the week number
//
BOOL CalcWeekNumber (DATE d, USHORT &w);

//
//	Encoding of days of the week. For the US calendar the week starts on Sunday, 
//	for the ISO calendar it's on Monday.
//
#ifndef WEEK_STARTS_SUNDAY
const USHORT MONDAY = 0, TUESDAY = 1, WEDNESDAY = 2, THURSDAY = 3, FRIDAY = 4, SATURDAY = 5, SUNDAY = 6;
#else
const USHORT SUNDAY = 0, MONDAY = 1, TUESDAY = 2, WEDNESDAY = 3, THURSDAY = 4, FRIDAY = 5, SATURDAY = 6;
#endif

//
//	Calculate the day of the week
//
inline USHORT DayOfWeek (DATE d)
{
	return (USHORT)(d % 7);
}

//
//	Get the current date
//
DATE GetCurrentDate ();


//
//	TIMEDATE representation, using minutes from the Epoch
//
typedef unsigned long TIMEDATE;

//
//	Construct a TIMEDATE
//
BOOL SetTimeDate(TIMEDATE &d, USHORT yy, USHORT mm, USHORT dd, USHORT hh, USHORT mmm);
BOOL SetTimeDate(TIMEDATE &d, DATE date, USHORT hh, USHORT mmm);

//
//	Extract the information from a TIMEDATE
//
BOOL GetTimeDate(TIMEDATE d, USHORT &yy, USHORT &mm, USHORT &dd, USHORT &hh, USHORT &mmm);
BOOL GetTimeDate(TIMEDATE d, DATE &date, USHORT &hh, USHORT &mmm);

//
//	Get the current time & date, this routine is O/S dependent
//
TIMEDATE GetCurrentTimeDate ();
