#include <stdio.h>
#include <stdarg.h>
#include "dllpower.h"
#include "dllmem.h"
/*
 * This is a DLL which has two exports, they are used in the program PROG.EXE
 */


extern "C"
{
  /*
   * I use extern "C" so the names don't get mangled...
   */

  void _export NewPrintf( char *format, ... )
  {
    char msgbuf[256];
    va_list arglist;
    va_start( arglist, format );
    vsprintf( msgbuf, format, arglist );
    printf(msgbuf);
    va_end( arglist );
  }

  int _export MyAdd(int a, int b)
  {
    return a + b;
  }
}

void main()
{
  printf("DLL Starting up!\n");
}

void dllexit()
{
  printf("DLL Shutting down!\n");
}


