/*
 *  dllpower.h - Copyright (c) 1995, 1996 by Tony Toole.
 *  DLLPower v2.51 header file.
 */

#ifndef DLLPOWER_H
  #define DLLPOWER_H
  #include <stdio.h>

  #ifdef __cplusplus
  extern "C"
  {
  #endif
    /*
     * Prototype for dllexit... just makes it so you don't need to extern "C"
     * it yourself under C++...
     */
    void dllexit();

    /*
     * Memory allocation stuff... Look in dllpmem.h
     * Added in v1.00
     */
    void *PowerMalloc(size_t s);
    void *PowerCalloc(size_t s1, size_t s2);
    void  PowerFree(void *s);

    /*
     * 2 functions to get DLLPower's version numbers.
     * Added in v2.12
     */
    char   PowerGetHiVer ();
    char   PowerGetLoVer ();

    /*
     * Get program command line and environment.
     * Mainly used within dlls.
     * Added in v2.12
     */
    int    PowerGetPCount();
    char **PowerGetParm  ();
    char **PowerGetEnv   ();

    /*
     * Stuff for manually loading DLLs (Way more to be added!)
     * Added in v2.51
     */
    long  PowerLoadDLL(char *Name);
    void  PowerFreeDLL(long Handle);        // <- This don't do anything yet!
    void* PowerGetDLLProc(char *Name, long Handle);
  
  #ifdef __cplusplus
  }
  #endif
#endif
