/*
 * PESTUB - copyright(c) 1995, 1996 by Tony Toole.
 * Feel free to modify for own use.
 */
#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <errno.h>
#include <string.h>

/* Add environment strings to be searched here */
struct ExeStub
{
  char ID[6];
  char DLLPath[128];
  char VirtualSet;
  long VirtualMin;
  long VirtualMax;
  long VirtualSwapMin;
  long VirtualSwapInc;
  long VirtualSize;
  char VirtualName[128];
} Stub = {"STUBID", ".\\", 0, 512, 16384, 1024, 1024, 16384, ".\\VIRTMEM.SWP"};

char *paths_to_check[] =
{
  "DLLPOWERPATH",
  "PATH"
};

char FullName[_MAX_PATH];

char *peloader_path()
{
  static char fullpath[80];
  char *peloaderpath;
  int i;

  if (peloaderpath = getenv("DLLPOWERPATH"))
  {
    strlwr (strcpy (fullpath, peloaderpath));
    if     (strstr (fullpath, ".exe")) return (fullpath);
  }
  for( i = 0; i < sizeof( paths_to_check    ) /
                  sizeof( paths_to_check[0] ); i++ )
  {
    _searchenv( "dllpower.exe", paths_to_check[i], fullpath );
    if( fullpath[0] ) return( &fullpath );
  }
  return( "dllpower.exe" );
}

char Path[200];
void Init()
{
  FILE *ap;
  char *ExistPath;
  putenv("DOS4G=QUIET");
  ExistPath = getenv("DLLPATH");
  if(ExistPath != NULL) sprintf(Path, "DLLPATH=%s;%s", ExistPath, Stub.DLLPath);
  else                  sprintf(Path, "DLLPATH=%s", Stub.DLLPath);
  putenv(Path);
  if(Stub.VirtualSet)
  {
    if((ap = fopen("VMMSET.VMC", "wt")) == NULL)
    {
      printf("STUB Error: Can't create configuration file VMMSET.VMC\n");
      exit(1);
    }
    fprintf(ap, "deleteswap\n");
    fprintf(ap, "maxmem      = %ld\n", Stub.VirtualMax);
    fprintf(ap, "minmem      = %ld\n", Stub.VirtualMin);
    fprintf(ap, "swapmin     = %ld\n", Stub.VirtualSwapMin);
    fprintf(ap, "swapinc     = %ld\n", Stub.VirtualSwapInc);
    fprintf(ap, "virtualsize = %ld\n", Stub.VirtualSize);
    fprintf(ap, "swapname    = %s\n", Stub.VirtualName);
    fclose(ap);
    putenv("DOS4GVM=@VMMSET.VMC");
    _fullpath(FullName, "VMMSET.VMC", _MAX_PATH);
  }
}
void UnInit()
{
  if(Stub.VirtualSet)
  {
    unlink(FullName);
  }
}
int main( int argc, char *argv[] )
{
  char *av[4];
  auto char cmdline[128];
  int ret;

  av[0] = peloader_path();
  av[1] = argv[0];
  av[2] = getcmd( cmdline );
  av[3] = NULL;

  Init();
  if((ret = spawnvp(P_WAIT, av[0], av )) == -1)
  {
    printf("STUB Error, unable to execute DOS Extender [%s]\n", av[0]);
    printf("Reason: %s", strerror(errno));
    UnInit();
    exit( 1 );
  }
  UnInit();
  return ret;
}
