// EARTHQUA.CPP - The main program for the Earthquake Damage Prevention
// program. Displays the menus.
// Created by Misha Koshelev.

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <process.h>
#include <graphics.h>
#include "svga256.h"
#include "tutor.h"

// Definitons
#define TUTORIAL 0
#define SIMULATION 1

#define INTRO 0
#define EQSIM 1
#define BMSIM 2

#define QUIT 255

#define UP_ARROW 72
#define DOWN_ARROW 80

void eqsimmain(void);

// Function definitons
int huge Svga256Detect(void);
void drawtitle(void);
void loadpal(char *);
void hrainbow(int, int, int, int, int, int, int, int);
void vrainbow(int, int, int, int, int, int, int, int);
void highlightitem(int, int, int, int, int, int);
void unhighlightitem(int, int, int, int, int, int);
void nextitem(int, int);
void previtem(int, int);
int mainmenu(void);
int tutormenu(void);

int page;

void main(int argc, char *argv[])
{
   int gd = DETECT, gm, errorcode;
   int y = 10;
   int ret, done=0, tdone = 0;

   // Set up graphics mode

   // Install the Super VGA 256 color driver
   installuserdriver("Svga256", Svga256Detect);

   // read the result of installation
   errorcode = graphresult();

   if (errorcode != grOk)  // an error occurred
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to quit...");
      getch();
      exit(1);
   }

   // Initalize graphics mode
   initgraph(&gd, &gm, "");

   // read result of initialization
   errorcode = graphresult();

   if (errorcode != grOk)  // an error occurred
   {
      printf("Graphics error: %s\n", grapherrormsg(errorcode));
      printf("Press any key to quit...");
      getch();
      exit(1);
   }

   // Load the palette
   loadpal("std.pal");

   // Display the title screen
   setactivepage(1);
   page = 1;
   cleardevice();

   setcolor(WHITE);
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 7);
   outtextxy(10, 10,"EARTHQUAKE");

   y += textheight("EARTHQUAKE") + 10;
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 2);
   outtextxy(170, y, "DAMAGE PREVENTION");

   y += textheight("DAMAGE PREVENTION") + 10;
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
   outtextxy(170, y, "Press any key to continue...");

   y += textheight("Press any key to continue...") + 10;
   hrainbow(1,1,640,y,WHITE,1,96,111);

   setvisualpage(1);

   while(!kbhit());
   getch();

   setfillstyle(SOLID_FILL, BLACK);
   bar(1, y-20, 640, y);

   while (!done)
   {
      ret = mainmenu();
      if (ret == QUIT)
	 done = 1;
      if (ret == TUTORIAL)
      {
	    setfillstyle(SOLID_FILL, BLACK);
	    bar(1, 120, 640, 480);
	    tdone = 0;
	    while (!tdone)
	    {
		  ret = tutormenu();
		  if (ret == QUIT)
			tdone = 1;
		  if (ret == INTRO)
		  {
			tutorintro();
			// Draw the title screen
			drawtitle();
		  }
		  if (ret == EQSIM)
		  {
			tutoreqsim();
			// Draw the title screen
			drawtitle();
		  }
		  if (ret == BMSIM)
		  {
			tutorbmsim();
			// Draw the title screen
			drawtitle();
		  }
	    }
	    setfillstyle(SOLID_FILL, BLACK);
	    bar(1, 120, 640, 480);
	 }
	 if (ret == SIMULATION)
      {
	    setviewport(0,0,639,479,1);
	    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	    setcolor(WHITE);
	    eqsimmain();
	    cleardevice();
	    // Draw the title screen
	    drawtitle();
      }
   }
   closegraph();
}

// Returns what video mode to use.
//
int huge Svga256Detect(void)
{
   return SVGA640x480x256;
}

// Draws the title screen in the appropriate page and displays it.
//
void drawtitle(void)
{
   int y;

   // Display the title screen
   if (page == 1)
	 page = 0;
   if (page == 0)
	 page = 1;
   setactivepage(page);
   cleardevice();

   y = 10;
   setcolor(WHITE);
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 7);
   outtextxy(10, 10,"EARTHQUAKE");

   y += textheight("EARTHQUAKE") + 10;
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 2);
   outtextxy(170, y, "DAMAGE PREVENTION");

   y += textheight("DAMAGE PREVENTION") + 10;
   settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
   hrainbow(1,1,640,y,WHITE,1,96,111);

   setvisualpage(page);
}

// Loads the palette from a raw palette file.
//
void loadpal(char *fn)
{
   int color;
   int r, g, b;
   FILE *pal;

   pal = fopen(fn, "rb");

   if (pal == NULL)
   {
      closegraph();
      printf("Error: Could not open palette file %s", fn);
      exit(1);
   }
   for (color = 0; color < 256; color++)
   {
      fread(&r, 1, 1, pal);
      fread(&g, 1, 1, pal);
      fread(&b, 1, 1, pal);
      setrgbpalette(color, r, g, b);
   }
   fclose(pal);
};

// Draws a horizontal "rainbow" on every pixel between (x1, y1) and
// (x2, y2) of keycolor, where each color
// takes barsize pixels, and the colors start from startc and end
// with endc.
//
void hrainbow(int x1, int y1, int x2, int y2, int keyc, int barsize,
	     int startc, int endc)
{
   int currcolor = startc;
   int ccpix = barsize;

   for (int k=y1; k<y2+1; k++)
   {
      for (int l=x1; l<x2+1; l++)
      {
	 if (getpixel(l, k) == keyc)
	 {
	    if (ccpix == 0)
	    {
	       ccpix = barsize;
	       currcolor++;
	       if (currcolor > endc)
		  currcolor = startc;
	    }
	    putpixel(l, k, currcolor);
	    ccpix--;
	 }
      }
      ccpix = barsize;
      currcolor = startc;
   }
}

// Draws a vertical "rainbow" on every pixel between (x1, y1) and
// (x2, y2) of keycolor, where each color
// takes barsize pixels, and the colors start from startc and end
// with endc.
//
void vrainbow(int x1, int y1, int x2, int y2, int keyc, int barsize,
	     int startc, int endc)
{
   int currcolor = startc;
   int ccpix = barsize;

   for (int k=x1; k<x2+1; k++)
   {
      for (int l=y1; l<y2+1; l++)
      {
	 if (getpixel(k, l) == keyc)
	 {
	    if (ccpix == 0)
	    {
	       ccpix = barsize;
	       currcolor++;
	       if (currcolor > endc)
		  currcolor = startc;
	    }
	    putpixel(k, l, currcolor);
	    ccpix--;
	 }
      }
      ccpix = barsize;
      currcolor = startc;
   }
}

// Highlights an unselected item with a specific color, in which the
// text is a specific color
void highlightitem(int x, int y, int x2, int y2, int hc, int tc)
{
   int i,j;

   for (i=y; i<y2+1; i++)
   {
      for (j=x; j<x2+1; j++)
      {
	  if (getpixel(j,i) != tc)
	     putpixel(j,i,hc);
      }
   }
}

// Unhighlights an unselected item with a specific color, in which the
// text is a specific color
void unhighlightitem(int x, int y, int x2, int y2, int hc, int tc)
{
   int i,j;

   for (i=y; i<y2+1; i++)
   {
      for (j=x; j<x2+1; j++)
      {
	  if (getpixel(j,i) != tc)
	     putpixel(j,i,hc);
      }
   }
}

// Returns the next item if ci is the current item and maxi is the number
// of items
void nextitem(int *ci, int maxi)
{
   if (*ci == maxi-1)
      *ci = 0;
   else
      *ci+=1;
}

// Returns the previous item if ci is the current item and maxi is the number
// of items
void previtem(int *ci, int maxi)
{
   if (*ci == 0)
      *ci = maxi-1;
   else
      *ci-=1;
}

// Displays the main menu. Returns the number of the item selected.
//
int mainmenu(void)
{
   int x[2], y[2], x2[2], y2[2];
   int curritem = 0;
   int done = 0;
   char ch;

   // Write the instructions
   settextstyle(SOLID_FILL, HORIZ_DIR, 2);
   setcolor(WHITE);

   outtextxy(70,130, "Use the arrow keys to choose an item,  ");
   outtextxy(70,150, "and press the <ENTER> key to select it.");
   outtextxy(70,170, "     Press the <ESC> key to quit.      ");

   // Draw a bluish rectangle
   setcolor(143);
   rectangle(10,250,630,469);

   // Write text in a red color
   settextstyle(SOLID_FILL, HORIZ_DIR, 4);
   setcolor(32);

   x[0] = 250; y[0] = 320;
   outtextxy(x[0],y[0],"Tutorial");
   x[0] -= 10;
   x2[0] = x[0] + textwidth("Tutorial") + 10;
   y2[0] = y[0] + textheight("Tutorial") + 10;

   x[1] = 230; y[1] = 370;
   outtextxy(x[1],y[1],"Simulation");
   x[1] -= 10;
   x2[1] = x[1] + textwidth("Simulation") + 10;
   y2[1] = y[1] + textheight("Simulation") + 10;

   // Highlight in a greenish color
   highlightitem(x[curritem], y[curritem], x2[curritem], y2[curritem],
     96, 32);

   while (!done)
   {
      ch = getch();
      if (ch != 0 && ch != 13 && ch != 27)
      {
	 sound(440);
	 delay(100);
	 nosound();
      }
      if (ch == 13)
	 return curritem;
      if (ch == 27)
	 return QUIT;
      if (ch == 0)
      {
	 ch = getch();
	 if (ch != UP_ARROW && ch != DOWN_ARROW)
	 {
	    sound(440);
	    delay(100);
	    nosound();
	 }
	 if (ch == UP_ARROW)
	 {
	    unhighlightitem(x[curritem], y[curritem],
			    x2[curritem], y2[curritem],
			    0, 32);
	    previtem(&curritem, 2);
	    highlightitem(x[curritem], y[curritem],
			  x2[curritem], y2[curritem],
			  96, 32);
	 }
	 if (ch == DOWN_ARROW)
	 {
	    unhighlightitem(x[curritem], y[curritem],
			    x2[curritem], y2[curritem],
			    0, 32);
	    nextitem(&curritem, 2);
	    highlightitem(x[curritem], y[curritem],
			  x2[curritem], y2[curritem],
			  96, 32);
	 }
      }
   }
}

// Displays the tutorial menu. Returns the number of the item selected.
//
int tutormenu(void)
{
   int x[3], y[3], x2[3], y2[3];
   int curritem = 0;
   int done = 0;
   char ch;

   // Write the instructions
   settextstyle(SOLID_FILL, HORIZ_DIR, 2);
   setcolor(WHITE);

   outtextxy(70,130, "Use the arrow keys to choose an item,  ");
   outtextxy(70,150, "and press the <ENTER> key to select it.");
   outtextxy(50,170, "Press the <ESC> key go back to the main menu");

   // Draw a bluish rectangle
   setcolor(143);
   rectangle(10,250,630,469);

   // Write text in a red color
   settextstyle(SOLID_FILL, HORIZ_DIR, 4);
   setcolor(32);

   x[0] = 218; y[0] = 260;
   outtextxy(x[0],y[0],"Introduction");
   x[0] -= 10;
   x2[0] = x[0] + textwidth("Introduction") + 10;
   y2[0] = y[0] + textheight("Introduction") + 10;

   x[1] = 130; y[1] = 300;
   outtextxy(x[1],y[1],"How does the earthquake");
   x[1] -= 10;
   x2[1] = x[1] + textwidth("How does the earthquake") + 10;
   y2[1] = y[1] + textheight("How does the earthquake") + 5;
   outtextxy(x[1]+80, y2[1],"simulator work?");
   y2[1] += textheight("simulator work?") + 5;

   x[2] = 130; y[2] = 380;
   outtextxy(x[2],y[2],"How does the building");
   x[2] -= 30;
   x2[2] = x[2] + textwidth("movement simulator work?") + 10;
   y2[2] = y[2] + textheight("How does the building") + 5;
   outtextxy(x[2]+4, y2[2],"movement simulator work?");
   y2[2] += textheight("movement simulator work?") + 5;

   // Highlight in a greenish color
   highlightitem(x[curritem], y[curritem], x2[curritem], y2[curritem],
     96, 32);

   while (!done)
   {
      ch = getch();
      if (ch != 0 && ch != 13 && ch != 27)
      {
	 sound(440);
	 delay(100);
	 nosound();
      }
      if (ch == 13)
	 return curritem;
      if (ch == 27)
	 return QUIT;
      if (ch == 0)
      {
	 ch = getch();
	 if (ch != UP_ARROW && ch != DOWN_ARROW)
	 {
	    sound(440);
	    delay(100);
	    nosound();
	 }
	 if (ch == UP_ARROW)
	 {
	    unhighlightitem(x[curritem], y[curritem],
			    x2[curritem], y2[curritem],
			    0, 32);
	    previtem(&curritem, 3);
	    highlightitem(x[curritem], y[curritem],
			  x2[curritem], y2[curritem],
			  96, 32);
	 }
	 if (ch == DOWN_ARROW)
	 {
	    unhighlightitem(x[curritem], y[curritem],
			    x2[curritem], y2[curritem],
			    0, 32);
	    nextitem(&curritem, 3);
	    highlightitem(x[curritem], y[curritem],
			  x2[curritem], y2[curritem],
			  96, 32);
	 }
      }
   }
}


