/*\t*******************************************************************/
/*    Creation Date .......  Thu  05-06-1993  13:15:40                */
/*    Filename  ...........  erapdefs.h                               */
/*    Project .............  Parts Database                           */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C/C++                                    */
/*    Operating System  ...  NONE                                     */
/*    Processor  ..........  ERA - Error Handler application          */
/*    Function: Public constants and structures for                   */
/*      error handling functions.                                     */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------

**\r*/

/*\m********************************************************************
**                       Definitions
***********************************************************************/

#ifndef _ERAPDEFS_H_
#define _ERAPDEFS_H_

/****************************************
* These filename constants should be
* used for DOS applications only,
* using erados.c or erados.cpp,
* for error logging.  For erawin.cpp,
* you should give a legal disk file
* name for logging errors.
*/

#define ERP_LOGTO_STDOUT "stdout"

#define ERP_LOGTO_STDERR "stderr"

#define ERP_LOGTO_STDPRN "stdprn" /* For MSDOS only */

#define ERP_STD_LOGFILE  "error.log" /* Standard log file name */

#define ERP_OVERWRITE    "w"

#define ERP_APPEND       "a"

enum ERP_CMD { ER_WARNING,      // Just a warning, log it but don't display
                                // Used mostly for debug purposes
               ER_REPORT,       // Log it and DISPLAY it, forcing user
                                // acknowledge
               ER_INFO,         // Same as ER_REPORT but it is NOT LOGGED,
                                // Use to display information to the
                                // user but don't add to error log file.
               ER_ABORT,        // Warning, detected serious flaw, user
                                // should "save" and "exit" application
                                // immediately if possible
               ER_FATAL };      // Fatal flaw detected, cannot recover,
                                // Terminate application now, without
                                // returning to the caller.
                                // Most often only ER_WARNING and ER_REPORT
                                // are used.  You should not "release"
                                // software with ER_ABORT or ER_FATAL in
                                // it, mostly used for "hardware debug"
                                // and "software bug shakeout"

typedef enum ERP_CMD ERP_CMD_TY;

#endif

