/*\t*******************************************************************/
/*    Creation Date .......  Thu  05-06-1993  12:52:42                */
/*    Filename  ...........  erapprtf.cpp                             */
/*    Project .............  Parts Database                           */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS                                      */
/*    Processor  ..........  ERA - Error Logging Application          */
/*    Function:         DOS Error logging utility.                    */
/*      Pass in procedure name or NULL. Pass in "printf" style        */
/*      argument list and associated arguments.  If error logging     */
/*      enabled, errors are sent to associated log file too.          */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------

**\r*/

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/
#include <stdarg.h>
#include <stdio.h>
#include <string.h>


/********************** Constant Include Files ************************/
#include "liidSys.h"
#include "erapdefs.h" // era public definitions

/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/
#define NOVAR_DEF   // Include prototypes, except for varargs
                    // prototypes. Can't prototype vararg functions
                    // for the source file they're defined in.

#include "eraprpt.h"



/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

#define ERM_ERR_FILE "error.log"

/************************* Module Variables ***************************/

/**************************************************
* Errors are logged to stdout by default,
* unless a call to ERAsetErrorFile() is
* made to change it.
*/

FILE    *ermUserFile = stdout;
int      ermCloseFlag= FALSE_;


LOCAL int             ermShowAllErrors        = FALSE_;
/************************* Module Procedures **************************/

/*\m*/

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  ERAsetErrorFile

    PURPOSE:  to set an error file for output of
      "fprintf()" error messages.  If fail, use
      'stderr' for error output.  The string pasFopenMode
      is "w" to overwrite any existing error log file and
      "a" is to append to an error file, if it exists.

        Output to               pasFileName==
        ---------               -----------------
        stdout                  "stdout"
        stderr                  "stderr"
        FILE.TXT                "FILE.TXT"

        If MSDOS

        stdprn                  "stdprn"  - system line printer

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   erlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE ERAsetErrorFile
( CHAR *pasFileName,  /* file name or NULL for default "error.log" */
  CHAR *pasFopenMode ) /* "w" or "a" usually                        */

{ /* ERAsetErrorFile procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
STAT_TYPE               erlErr=SUCCEEDED_; /* Iniz error return value */

/************************* Procedure Body *****************************/

ermCloseFlag = FALSE_; /* NO need to close on terminate */

if (strcmp(pasFileName,"stderr") == 0)
  {
  ermUserFile = stderr;
  }
else if (strcmp(pasFileName,"stdout") == 0)
  {
  ermUserFile = stdout;
  }
else if (strcmp(pasFileName, "stdprn") == 0)
  {
  ermUserFile = stdprn;
  }
else
  {
  ermUserFile = fopen( pasFileName, pasFopenMode);

  if (ermUserFile == NULL)
    {
    ermUserFile = stderr;
    fprintf(stderr,
      "Failed to open error log file %s, using 'stderr' instead\n",
      pasFileName );
    erlErr = FAILED_;
    }
  else
    {
    ermCloseFlag= TRUE_;
    }
  }

return(erlErr);
} /* ERAsetErrorFile end */

/*\p*******************************************************************/
/*                                                                    */
/*  NAME: ERAerrorInit                                                */
/*                                                                    */
/*  PURPOSE: Initialize the error Handler.                            */
/*                                                                    */
/*                                                                    */
/*  INPUTS:                                                           */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*                                                                    */
/*  OUTPUTS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*  GLOBALS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*\p*******************************************************************/

STAT_TY ERAerrorInit( CHAR *pasLocationStr )

{ /* ERAerrorInit  procedure */

/**********************************************************************/
/*                        LOCAL CONSTANT DECLARATIONS                 */
/**********************************************************************/


/**********************************************************************/
/*                        LOCAL VARIABLE DECLARATIONS                 */
/**********************************************************************/
STAT_TYPE erlErr;


/**********************************************************************/
/*                            Procedure Body                          */
/**********************************************************************/
erlErr = SUCCEEDED_;
erlErr = ERAsetErrorFile( pasLocationStr, "w" );

return(erlErr);

}

/*\p*******************************************************************/
/*                                                                    */
/*  NAME: ERAerrorLog                                                 */
/*                                                                    */
/*  PURPOSE: Allow routines to log an error message in the log file.  */
/*  This procedure transmits an IPC to the error handler process.     */
/*                                                                    */
/*                                                                    */
/*  INPUTS:                                                           */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         pasLocationPtr  ERP_LOC_TY * string     where err occured  */
/*         pasErrorTextPtr ERP_TEXT_TY *  string   error Text         */
/*                                                                    */
/*  OUTPUTS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*  GLOBALS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*\p*******************************************************************/

VOID_RTN ERAerrorLog
(    CHAR *pasLocationPtr,       // Function where error occurred
     CHAR *pasFormatStr,         // 'printf' format string
     ...   )                     //  macro that defines va_alist

{ /* ERAerrorLog  procedure */

/**********************************************************************/
/*                        LOCAL CONSTANT DECLARATIONS                 */
/**********************************************************************/


/**********************************************************************/
/*                        LOCAL VARIABLE DECLARATIONS                 */
/**********************************************************************/

va_list  erlArgs;
CHAR     erlMsg[257];
/**********************************************************************/
/*                            Procedure Body                          */
/**********************************************************************/
va_start (erlArgs, pasFormatStr);
vsprintf(erlMsg,pasFormatStr,erlArgs);
va_end (erlArgs);

if (ermUserFile != NULL)
  {
  fprintf(ermUserFile, "LOG %s:%s\n",pasLocationPtr,erlMsg);
  fflush(ermUserFile);
  }

if (ermShowAllErrors)
  {
  printf( "LOG:%s:%s\n", pasLocationPtr, erlMsg );
  }

} /* ERAerrorLog end */

VOID_RTN ERAparameterError
(    CHAR *pasLocationPtr )      // Function where error occurred
{

ERAerrorLog( pasLocationPtr, "Invalid Parameter" );

}


/*\p*******************************************************************/
/*                                                                    */
/*  NAME: ERAerrorReport                                              */
/*                                                                    */
/*  PURPOSE: Allow routines to log or display and error message.      */
/*  This procedure transmits an IPC to the error handler process.     */
/*  Several commands are aavailable. See errorC.inc for constants     */
/*  used to specify the command paimeter. See "Mini-QUIC Error        */
/*  Reporter and Logger" document for a description of the various    */
/*  commands                                                          */
/*                                                                    */
/*  INPUTS:                                                           */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         pasCommand   ERP_CMD_TY    constant from errorC.inc        */
/*         pasLocationPtr ERP_LOC_TY * string     where error occurred*/
/*         pasErrorTextPtr ERP_TEXT_TY *  string   error Text         */
/*                                                                    */
/*  OUTPUTS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*  GLOBALS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*\p*******************************************************************/

VOID_RTN ERAerrorReport
(   ERP_CMD_TY    pasCommand,
    CHAR         *pasLocationPtr,
    CHAR         *pasFormatStr,
    ... )               /*  macro that defines va_alist  */

{ /* ERAerrorReport  procedure */

/**********************************************************************/
/*                        LOCAL CONSTANT DECLARATIONS                 */
/**********************************************************************/


/**********************************************************************/
/*                        LOCAL VARIABLE DECLARATIONS                 */
/**********************************************************************/

CHAR     erlReport[512];
int      erlCmd;
va_list  erlArgs;
CHAR     erlMsg[257];
CHAR     erlWarn[40];
/**********************************************************************/
/*                            Procedure Body                          */
/**********************************************************************/

va_start (erlArgs, pasFormatStr);
vsprintf(erlMsg,pasFormatStr,erlArgs);
va_end (erlArgs);

sprintf(erlReport, "REPORT %s:%s\n",pasLocationPtr,erlMsg);
if (ermUserFile != NULL)
  {
  fflush(ermUserFile);
  }

switch( pasCommand )
  {
  case ER_WARNING:
    strcpy(erlWarn, "WARNING");
    break;
  case ER_REPORT:
    strcpy(erlWarn, "INFORMATION");
    break;
  case ER_ABORT:
    strcpy(erlWarn, "ABORT!");
    break;
  case ER_FATAL:
    strcpy(erlWarn, "FATAL ERROR!!");
    break;
  default:
    strcpy(erlWarn, "UNDEFINED");
    break;
  }

printf( "%s:%s", erlWarn, erlReport );
if (ermUserFile != NULL)
  {
  fprintf(ermUserFile, "%s:%s\n", erlWarn, erlReport );
  fflush (ermUserFile);
  }

}

/*\p*******************************************************************/
/*                                                                    */
/*  NAME:  ERAerrorTerm                                               */
/*                                                                    */
/*  PURPOSE:  to terminate use of the error handler.                  */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  INTERFACE DEFINITION:                                             */
/*     variable         def.          expected/description            */
/*   ------------       -----  -------------------------------------  */
/*   erlErr             FNC    (SUCCEEDED_ / FAILED_) error return    */
/*\p*******************************************************************/

STAT_TYPE ERAerrorTerm()
{ /* ERAerrorTerm procedure */
/**********************************************************************/
/*                   Local Constant Declarations                      */
/**********************************************************************/
//CHARPTR ERL_PROC_NAME = "ERAerrorTerm";

/**********************************************************************/
/*                   Local Variable Declarations                      */
/**********************************************************************/
STAT_TYPE  erlErr            ;/* error return flag                    */

/**********************************************************************/
/*                          Procedure Body                            */
/**********************************************************************/


erlErr = SUCCEEDED_;

if (ermCloseFlag)
  {
  if (ermUserFile != NULL)
    {
    fclose(ermUserFile);
    }
  }

ermCloseFlag = FALSE_;
ermUserFile  = NULL;

return(erlErr);
} /* end ERAerrorTerm */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  ERAdisplayLogErrors

    PURPOSE:  to enable or disable the display of all errors
        logged.  Helpful to enable this when first bringing
        up software.  Once "stable", disable (default), and
        just log errors to a file.

**                                                                    **
**                                                                    **
**\p*******************************************************************/

VOID_RTN ERAdisplayLogErrors( int pasDisplayAll )

{ /* ERAdisplayLogErrors procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

ermShowAllErrors        = pasDisplayAll;

} /* ERAdisplayLogErrors end */
