/*\t*******************************************************************/
/*    Creation Date .......  Thu  05-06-1993  13:55:59                */
/*    Filename  ...........  eraprpt.h                                */
/*    Project .............  Error Handling                           */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C/C++                                    */
/*    Operating System  ...  NONE                                     */
/*    Processor  ..........  ERA - Error Report application prototypes*/
/*    Function: To report errors, you must provide functions to       */
/*      "fill in" the interface shown below.  It can be implemented   */
/*      with simple "printf" calls for simple text output user        */
/*      interfaces.  For more sophisticated user interfaces, such     */
/*      as MS Windows, you need to provide a "message box" interface  */
/*      for presenting these error messages.  At the bare minimum     */
/*      you should implement a means to log errors to a file that     */
/*      may be reviewed after your program "crashes".                 */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
05-May-93  MJWR         Error log prototypes for Parts Database project.


**\r*/

/*\m********************************************************************
**                       Definitions
***********************************************************************/


STAT_TYPE ERAsetErrorFile
( CHAR  *pasFileName,
  CHAR  *pasFopenMode );

STAT_TY ERAerrorInit
( CHAR            *pasLocationStr ); // Filename where errors are logged

STAT_TY ERAerrorTerm (); // Terminate error handler

// Normally errors are sent to logfile only.
// However, call this function with a TRUE_
// flag and every error log will be displayed.
// (In the case of "erawin.cpp" they will be
// presented in message boxes.)

VOID_RTN ERAdisplayLogErrors( int pasTrueShow );

#ifndef NOVAR_DEF // Can't prototpye varargs in the source file that
                  // implements varargs functions.
VOID_RTN ERAerrorReport
(    ERP_CMD_TY    pasCommand,
     CHAR         *pasLocationPtr,
     CHAR         *pasFormatStr,
     ... );

VOID_RTN ERAerrorLog
(    CHAR        *pasLocationPtr,
     CHAR        *pasFormatStr,
     ... );


VOID_RTN ERAparameterError
( CHAR *pasLocationPtr );   // Function where error occurred

#endif
