/*\t*******************************************************************/
/*    Creation Date .......  Thu  05-06-1993  12:52:42                */
/*    Filename  ...........  erawin.cpp                               */
/*    Project .............  Parts Database                           */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS/Windows                              */
/*    Processor  ..........  ERA - Error Logging Application          */
/*    Function:         Windows Error logging utility.                */
/*      Pass in procedure name or NULL. Pass in "printf" style        */
/*      argument list and associated arguments.  If error logging     */
/*      enabled, errors are sent to associated log file too.          */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------

**\r*/

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/
#include <windows.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>


/********************** Constant Include Files ************************/
#include "liidSys.h"
#include "liustrg.h"
#include "erapdefs.h" // era public definitions
#include "fipfile.h"

/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/

#define NOVAR_DEF   // Include prototypes, except for varargs
                    // prototypes. Can't prototype vararg functions
                    // for the source file they're defined in.
#include "fiufile.h"
#include "eraprpt.h"



/*\i*/

/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

#define  ERM_STRLEN 240
#define  ERM_BUF_SIZ 4096

#define  ERM_ERR_FILE "error.log"

#define  ERM_DEBUG 1 // 1=debug 0=normal

/**************************************************
* Errors are logged to stdout by default,
* unless a call to ERAsetErrorFile() is
* made to change it.
*/

LOCAL char    *ermFileName = NULL;


/****************************************
* Parent window of application, for
* creating message boxes.
*/

LOCAL HWND            ermHparent              = NULL;
LOCAL int             ermShowAllErrors        = FALSE_;

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\m*/

char *eraGetLocStr( char *pasLocationStr )
{
if (!pasLocationStr) return("FYI");
else                 return(pasLocationStr);
}
/****************************************
* NAME: eraGetFptr
*
* If file name specified previously,
* then open the error file for append
* and return a file pointer to it,
* else return NULL, indicating no
* file logging of error(s).
*/

FILE *eraGetFptr()
{
FILE *erlFptr;

if (ermFileName)
  {
  erlFptr = FIUfopen(ermFileName,"a");
  }
else
  {
  erlFptr = NULL;
  }
return(erlFptr);
}



/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  ERAsetErrorFile

    PURPOSE:  to set an error file for output of
      "fprintf()" error messages.  If fail, use
      'stderr' for error output.  The string pasFopenMode
      is "w" to overwrite any existing error log file and
      "a" is to append to an error file, if it exists.

        Output to               pasFileName==
        ---------               -----------------
        stdout                  "stdout"
        stderr                  "stderr"
        FILE.TXT                "FILE.TXT"

        If MSDOS

        stdprn                  "stdprn"  - system line printer

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   erlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE ERAsetErrorFile
( CHAR *pasFileName,  /* file name or NULL for default "error.log" */
  CHAR *pasFopenMode ) /* "w" or "a" usually                        */

{ /* ERAsetErrorFile procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
STAT_TYPE               erlErr=SUCCEEDED_; /* Iniz error return value */
FILE                   *erlFptr;

/************************* Procedure Body *****************************/

if (ermFileName) LIMDELA(ermFileName);
if (pasFileName != NULL)
  {
  if (*pasFileName)
    {
    ermFileName = new char[strlen(pasFileName)+1];
    strcpy(ermFileName,pasFileName);
    erlFptr = FIUfopen(ermFileName,pasFopenMode);
    if (erlFptr == NULL)
      {
      MessageBox( ermHparent,
                  "Can't Open Error File",
                  pasFileName, MB_OK );
      LIMDELA(ermFileName);
      erlErr = FAILED_;
      }
    else
      {
      FIUfclose(&erlFptr);
      }
    }
  }

return(erlErr);
} /* ERAsetErrorFile end */

/*\p*******************************************************************/
/*                                                                    */
/*  NAME: ERAerrorInit                                                */
/*                                                                    */
/*  PURPOSE: Initialize the error Handler.                            */
/*                                                                    */
/*                                                                    */
/*  INPUTS:                                                           */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*                                                                    */
/*  OUTPUTS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*  GLOBALS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*\p*******************************************************************/

STAT_TY ERAerrorInit( CHAR *pasLocationStr )

{ /* ERAerrorInit  procedure */

/**********************************************************************/
/*                        LOCAL CONSTANT DECLARATIONS                 */
/**********************************************************************/


/**********************************************************************/
/*                        LOCAL VARIABLE DECLARATIONS                 */
/**********************************************************************/
STAT_TYPE erlErr = SUCCEEDED_;


/**********************************************************************/
/*                            Procedure Body                          */
/**********************************************************************/

erlErr = ERAsetErrorFile( pasLocationStr, "w" );

return(erlErr);
}

/*\p*******************************************************************/
/*                                                                    */
/*  NAME: ERAerrorLog                                                 */
/*                                                                    */
/*  PURPOSE: Allow routines to log an error message in the log file.  */
/*  This procedure transmits an IPC to the error handler process.     */
/*                                                                    */
/*                                                                    */
/*  INPUTS:                                                           */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         pasLocationPtr  ERP_LOC_TY * string     where err occured  */
/*         pasErrorTextPtr ERP_TEXT_TY *  string   error Text         */
/*                                                                    */
/*  OUTPUTS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*  GLOBALS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*\p*******************************************************************/

VOID_RTN ERAerrorLog
(    CHAR *pasLocationPtr,       // Function where error occurred
     CHAR *pasFormatStr,         // 'printf' format string
     ...   )                     //  macro that defines va_alist

{ /* ERAerrorLog  procedure */

/**********************************************************************/
/*                        LOCAL CONSTANT DECLARATIONS                 */
/**********************************************************************/


/**********************************************************************/
/*                        LOCAL VARIABLE DECLARATIONS                 */
/**********************************************************************/

va_list  erlArgs;
CHAR     *erlMsg;
CHAR     *erlWarn;
CHAR     *erlWptr;
FILE     *erlFptr;
/**********************************************************************/
/*                            Procedure Body                          */
/**********************************************************************/
erlMsg  = new char[ERM_BUF_SIZ];
erlWarn = new char[ERM_BUF_SIZ];

va_start (erlArgs, pasFormatStr);
vsprintf(erlMsg,pasFormatStr,erlArgs);
va_end (erlArgs);

erlFptr = eraGetFptr();

pasLocationPtr = eraGetLocStr(pasLocationPtr);
if (erlFptr)
  {
  strcpy(erlWarn,erlMsg);
  erlWptr = erlWarn;
  while (*erlWptr)
    {
    if ((*erlWptr == '\r') ||
        (*erlWptr == '\n') ||
        (*erlWptr == '\t'))
      {
      *erlWptr = ' ';
      }
    erlWptr++;
    }
  fprintf(erlFptr, "LOG %s:%s\n",pasLocationPtr,erlWarn);
  FIUfclose(&erlFptr);
  }

if (ermShowAllErrors)
  {
  MessageBox ( ermHparent,
               erlMsg,
               pasLocationPtr,
               MB_OK | MB_ICONINFORMATION | MB_TASKMODAL );
  }

LIMDELA(erlMsg);
}

VOID_RTN ERAparameterError
( CHAR *pasLocationPtr )      // Function where error occurred
{

ERAerrorLog( pasLocationPtr, "Invalid Parameter" );

}


/*\p*******************************************************************/
/*                                                                    */
/*  NAME:  ERAerrorTerm                                               */
/*                                                                    */
/*  PURPOSE:  to terminate use of the error handler.                  */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*  INTERFACE DEFINITION:                                             */
/*     variable         def.          expected/description            */
/*   ------------       -----  -------------------------------------  */
/*   erlErr             FNC    (SUCCEEDED_ / FAILED_) error return    */
/*\p*******************************************************************/

STAT_TYPE ERAerrorTerm()

{ /* ERAerrorTerm procedure */
/**********************************************************************/
/*                   Local Constant Declarations                      */
/**********************************************************************/

/**********************************************************************/
/*                   Local Variable Declarations                      */
/**********************************************************************/
STAT_TYPE  erlErr=SUCCEEDED_;

/**********************************************************************/
/*                          Procedure Body                            */
/**********************************************************************/


LIMDELA(ermFileName);
                          
///////////////////////////////////////
// Parent window
// no longer available.
// Dialogs may remain enabled,
// however, because a value of NULL
// for the parent window is valid.

ermHparent              = NULL;

return(erlErr);
} /* end ERAerrorTerm */


/*\p*******************************************************************/
/*                                                                    */
/*  NAME: ERAerrorReport                                              */
/*                                                                    */
/*  PURPOSE: Allow routines to log or display and error message.      */
/*  This procedure transmits an IPC to the error handler process.     */
/*  Several commands are aavailable. See errorC.inc for constants     */
/*  used to specify the command paimeter. See "Mini-QUIC Error        */
/*  Reporter and Logger" document for a description of the various    */
/*  commands                                                          */
/*                                                                    */
/*  INPUTS:                                                           */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         pasCommand   ERP_CMD_TY    constant from errorC.inc        */
/*         pasLocationPtr ERP_LOC_TY * string     where error occurred*/
/*         pasErrorTextPtr ERP_TEXT_TY *  string   error Text         */
/*                                                                    */
/*  OUTPUTS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*  GLOBALS:                                                          */
/*         variable       type        expected         description    */
/*         --------       ----        --------         -----------    */
/*         None                                                       */
/*\p*******************************************************************/

VOID_RTN ERAerrorReport
(   ERP_CMD_TY    pasCommand,
    CHAR         *pasLocationPtr,
    CHAR         *pasFormatStr,
    ... )               /*  macro that defines va_alist  */

{ /* ERAerrorReport  procedure */

/**********************************************************************/
/*                        LOCAL CONSTANT DECLARATIONS                 */
/**********************************************************************/


/**********************************************************************/
/*                        LOCAL VARIABLE DECLARATIONS                 */
/**********************************************************************/

int      erlCmd;
va_list  erlArgs;
CHAR    *erlMsg;
CHAR    *erlWarn;
CHAR    *erlWptr;
FILE    *erlFptr;
BOOLEAN  erlReported;
int      erlIcon;

/**********************************************************************/
/*                            Procedure Body                          */
/**********************************************************************/

erlMsg    = new CHAR[ERM_BUF_SIZ];
erlWarn   = new CHAR[ERM_BUF_SIZ];

va_start (erlArgs, pasFormatStr);
vsprintf(erlMsg,pasFormatStr,erlArgs);
va_end (erlArgs);
pasLocationPtr = eraGetLocStr(pasLocationPtr);

erlFptr = eraGetFptr();

if (erlFptr)
  {
  /****************************************
  * In a file a report resides entirely
  * on one LINE.
  */
  strcpy(erlWarn,erlMsg);
  erlWptr = erlWarn;
  while (*erlWptr)
    {
    if ((*erlWptr == '\r') ||
        (*erlWptr == '\n') ||
        (*erlWptr == '\t'))
      {
      *erlWptr = ' ';
      }
    erlWptr++;
    }
  fprintf(erlFptr, "REPORT %s:%s\n",pasLocationPtr,erlWarn);
  FIUfclose(&erlFptr);
  }

erlReported = FALSE_;
erlIcon     = MB_ICONASTERISK;
switch( pasCommand )
  {
  case ER_WARNING:
    sprintf(erlWarn, "WARNING:%s", pasLocationPtr);
    break;
  case ER_REPORT:
  case ER_INFO:
    sprintf(erlWarn, "INFORMATION:%s", pasLocationPtr);
    break;
  case ER_ABORT:
    sprintf(erlWarn, "ABORT ASAP!:%s", pasLocationPtr);
    erlIcon = MB_ICONSTOP;
    break;
  case ER_FATAL:
    sprintf(erlWarn, "FATAL ERROR!!:%s", pasLocationPtr);
    strcat(erlMsg,"\r\nEXIT NOW?");
    erlCmd = MessageBox( ermHparent,
                         erlMsg,
                         erlWarn,
                         MB_OKCANCEL | MB_ICONHAND | MB_TASKMODAL );
    erlReported = TRUE_;
    if (erlCmd == IDOK)
      {
      PostQuitMessage(-1);
      }
    break;
  default:
    sprintf(erlWarn, "UNDEFINED ID:%s", pasLocationPtr);
    break;
  }

if (!erlReported)
  {
  MessageBox( ermHparent,
              erlMsg,
              erlWarn,
              MB_OK | erlIcon | MB_TASKMODAL );
  }

LIMDELA(erlMsg);
LIMDELA(erlWarn);
} /* ERAerrorReport end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  ERAsetWindowParent

    PURPOSE:  to set the parent window for this error handling
        package based on Microsoft Windows.


**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   erlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

void ERAsetWindowParent( UINT pasHparent )

{ /* ERAsetWindowParent procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

ermHparent = (HWND)pasHparent;



} /* ERAsetWindowParent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  ERAdisplayLogErrors

    PURPOSE:  to enable or disable the display of all errors
        logged.  Helpful to enable this when first bringing
        up software.  Once "stable", disable (default), and
        just log errors to a file.

**                                                                    **
**                                                                    **
**\p*******************************************************************/

VOID_RTN ERAdisplayLogErrors( int pasDisplayAll )

{ /* ERAdisplayLogErrors procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

ermShowAllErrors        = pasDisplayAll;

} /* ERAdisplayLogErrors end */
