/*\t*******************************************************************
   Creation Date .......  Fri  06-17-1994  11:19:00
   Filename  ...........  figfile.h
   Project .............  File Utilities
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C++
   Operating System  ...  DOS or Windows
   Prefix ..............  FIG - File, group private
   Function:  Group private structs for file processing

 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------

**\r*/
#ifndef _FIGFILE_H_
#define _FIGFILE_H_

/*\m******************** Include Requirements *************************
* List of files which must be included BEFORE this file can be included:
* #include ...
* #include ...
*/

/*\m******************** Definitions **********************************/

/* File attribute constants */

#define FIG_NORMAL   0x00    /* Normal file - No read/write restrictions */
#define FIG_RDONLY   0x01    /* Read only file */
#define FIG_HIDDEN   0x02    /* Hidden file */
#define FIG_SYSTEM   0x04    /* System file */
#define FIG_VOLID    0x08    /* Volume ID file */
#define FIG_SUBDIR   0x10    /* Subdirectory */
#define FIG_ARCH     0x20    /* Archive file */

typedef struct  {
    char        reserved[21];
    char        attrib;
    unsigned    ftime;
    unsigned    fdate;
    long        fsize;
    char        name[13];
} FIG_DOS_FBLK_TY;


STAT_TYPE       fiuFindFirst( const char *pasFilePath,
                              FIG_DOS_FBLK_TY *refFblk,
                              unsigned         pasSeaMode = FIG_NORMAL );

STAT_TYPE       fiuFindNext( FIG_DOS_FBLK_TY *refFblk );

/*\m****************** END Definitions ********************************/
#endif

